/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IEntry;
import com.iscobol.rts.Config;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Entry
extends Verb
implements CobolToken,
ErrorsNumbers,
IEntry {
    private static final String entryPoint = "_entry_Point$";
    private final Token name;
    private final String methodName;
    private final String entryName;
    private Token elkToken;
    private String serviceBridgeOperation = null;
    private boolean callRequired = true;
    VariableNameList using = new VariableNameList();
    private HashSet byValueVars = new HashSet();
    private final boolean serviceBridgeActivated;
    VariableDeclaration usingVarargs;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entry(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk;
        this.serviceBridgeActivated = p.isServiceBridgeActivated();
        TokenList xtlK = t.delExtraInfo("ELK");
        if (xtlK != null) {
            this.elkToken = xtlK.getFirst();
            if ("OPERATION".equalsIgnoreCase(xtlK.getNext().getWord())) {
                if (xtlK.getNext().getToknum() == 61) {
                    this.serviceBridgeOperation = xtlK.getNext().getWord();
                } else {
                    this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
                }
            } else {
                this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
            }
        }
        if ((tk = this.tm.getToken()).getToknum() != 10001) {
            throw new GeneralErrorException(97, 4, this.keyWord, tk.getWord(), this.error);
        }
        this.name = tk;
        tk = this.tm.getToken();
        if (tk.getToknum() == 802) {
            boolean byValue = false;
            while ((tk = this.tm.getToken()).getToknum() == 10009 || tk.getToknum() == 312 || tk.getToknum() == 803 || tk.getToknum() == 676) {
                if (tk.getToknum() == 312) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 803) {
                        byValue = true;
                    } else {
                        if (tk.getToknum() != 676) throw new ExpectedFoundException(tk, this.error, "VALUE|REFERENCE");
                        byValue = false;
                    }
                } else if (tk.getToknum() == 803) {
                    byValue = true;
                } else if (tk.getToknum() == 676) {
                    byValue = false;
                } else {
                    this.tm.ungetToken();
                }
                tk = this.tm.getToken();
                if (tk.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                this.tm.ungetToken();
                VariableName vn = VariableName.getAnyUsing(this.tm, this.error, this.parent, this.pc);
                if (!vn.getVarDecl().isInLinkage()) throw new GeneralErrorException(139, 4, vn.getNameToken(), vn.getName(), this.error);
                if (vn.getDimension() > 0) {
                    throw new GeneralErrorException(55, 4, vn.getNameToken(), vn.getName(), this.error);
                }
                this.using.addItem(vn);
                if (byValue) {
                    this.byValueVars.add(vn);
                }
                if (vn.getVarDecl().parent == null) continue;
                throw new GeneralErrorException(27, 4, tk, tk.getWord(), this.error);
            }
        }
        if (this.pc.data != null && this.pc.data.linkSec != null) {
            this.usingVarargs = this.pc.data.linkSec.checkUsingVarargs(this.using);
        }
        this.tm.ungetToken();
        if (par.nesting > 0) {
            throw new GeneralErrorException(98, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        String n = this.name.getPlain().replace('-', '_');
        int len = n.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isJavaIdentifierPart(n.charAt(i))) continue;
            throw new GeneralErrorException(144, 4, this.keyWord, this.name.getWord(), this.error);
        }
        this.methodName = entryPoint + n + "()";
        if (this.name.isHexdecimal()) {
            String word = this.name.getWord();
            this.entryName = "\"" + TokenManager.stringToHex(word.substring(1, word.length() - 1), this.name.isNational(), true) + "\"";
        } else {
            this.entryName = this.name.getLitArg().toUpperCase(Locale.US).replace('-', '_');
        }
        if (this.pc.setEntryPoint(this)) return;
        throw new GeneralErrorException(67, 4, this.keyWord, this.keyWord.getWord(), this.error);
    }

    public String getNameTokenValue() {
        if (this.name.getToknum() == 10001) {
            return this.name.getOriginalWord().substring(1, this.name.getOriginalWord().length() - 1);
        }
        return this.name.getOriginalWord();
    }

    public String getServiceBridgeValueName() {
        if (this.serviceBridgeOperation != null) {
            return this.serviceBridgeOperation;
        }
        return this.getNameTokenValue();
    }

    @Override
    public Token getElkToken() {
        return this.elkToken;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public Token getNameToken() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o instanceof Entry && ((Entry)o).entryName.equals(this.entryName);
    }

    public int hashCode() {
        return this.entryName.hashCode();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public VariableNameList getUsing() {
        return this.using;
    }

    @Override
    public String getServiceBridgeOperation() {
        return this.serviceBridgeOperation;
    }

    @Override
    public String getServiceBridgeName() {
        if (this.serviceBridgeOperation != null) {
            return this.serviceBridgeOperation;
        }
        return this.entryName;
    }

    @Override
    public String getCode() {
        boolean debug;
        Paragraph p;
        StringBuffer Return2 = new StringBuffer();
        if ((Config.getProperty(".compiler.easylinkage", 0) == 1 || Config.getProperty(".compiler.easylinkage", false) || Config.getProperty(".compiler.easylinkage", 0) == 3 && Config.getProperty(".compiler.easylinkage", 0) != 2) && this.pc.getDataDivision() != null) {
            this.pc.getDataDivision().getEasyLinkCode(this.pc, this.entryName.replace("\"", ""), this.using, this.byValueVars, true);
        }
        if (this.serviceBridgeActivated && this.pc.getDataDivision() != null) {
            String name = this.getNameToken().getOriginalWord();
            String callName = this.entryName;
            if (this.serviceBridgeOperation != null) {
                name = this.serviceBridgeOperation;
            }
            this.pc.getDataDivision().getServiceBridgeCobCode(this.pc, name.replace("\"", ""), callName.replace("\"", ""), this.using, this.pc.getNumEntry(this.entryName), true);
        }
        boolean hasDebugCode = Paragraph.getDebugSection(this.pc, p = this.parent.getParent()) != null;
        boolean hasLocalStorage = false;
        boolean hasThreadLocalStorage = false;
        if (this.pc.data != null) {
            hasLocalStorage = this.pc.data.lsSec != null;
            hasThreadLocalStorage = this.pc.data.tlsSec != null;
        }
        boolean bl = debug = this.pc.getOption("-d") != null;
        if ((debug || hasLocalStorage || hasThreadLocalStorage || hasDebugCode) && this.getDeferredMethodId() == 0) {
            Return2.append(" } ");
        }
        Return2.append("      return ");
        Return2.append(this.methodName);
        Return2.append(";");
        Return2.append(eol);
        Return2.append("   }");
        Return2.append(eol);
        Return2.append("   final ");
        if (!this.pc.getSplitFlag()) {
            Return2.append("private ");
        }
        Return2.append("int ");
        Return2.append(this.methodName);
        Return2.append(" throws GotoException {");
        if ((debug || hasLocalStorage || hasThreadLocalStorage) && this.getDeferredMethodId() == 0) {
            Return2.append(" { ");
        }
        if (hasLocalStorage) {
            Return2.append(eol);
            Return2.append("   ");
            this.pc.getLocalStorageCode(Return2);
        }
        if (hasThreadLocalStorage) {
            Return2.append(eol);
            Return2.append("   ");
            this.pc.getThreadLocalStorageCode(Return2);
        }
        Return2.append(eol);
        return Return2.toString();
    }

    public boolean isCallRequired() {
        return this.callRequired;
    }

    public void setCallRequired(boolean callRequired) {
        this.callRequired = callRequired;
    }

    public Set getByValueParameters() {
        return this.byValueVars;
    }
}

