/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.EfdHint;
import com.iscobol.compiler.EfdWhen;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.interfaces.compiler.IEfdParser;
import java.util.Enumeration;
import java.util.Vector;

public class EfdParser
implements ErrorsNumbers,
IEfdParser {
    private static final int ASIS = 0;
    private static final int ALPHA = 1;
    private static final int BINARY = 2;
    private static final int DATE = 3;
    private static final int NUMERIC = 4;
    private static final int SERIAL = 5;
    private static final int LONGCHAR = 6;
    private static final int LONGBINARY = 7;
    private static final int CHAR = 8;
    private Token first;
    private Errors error;
    private TokenList tl;
    private String cobTrigger;
    private boolean foundHint;
    private boolean wrongFormat;
    private String comment;
    private String file;
    private String name;
    private boolean split;
    private boolean hidden;
    private boolean readOnly;
    private boolean useGroup;
    private boolean convertError;
    private EfdWhen when;
    private EfdHint hint;
    private String always = null;
    private int alwaysNum = 0;
    private Vector hintList = new Vector();
    private int dbType;
    private int origDbType = -1;
    private String format;
    private String temporaryType;
    private String defValue;
    private boolean foundBindefault;
    private boolean foundCbdefault;
    private boolean temporary = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EfdParser(TokenList t, boolean efc, Errors err) {
        this.error = err;
        this.tl = t;
        this.defValue = "";
        this.foundBindefault = false;
        this.foundCbdefault = false;
        this.foundHint = false;
        this.wrongFormat = false;
        this.convertError = true;
        this.first = this.tl.getFirst();
        Token tk = this.tl.getNext();
        while (tk != null) {
            block78: {
                if (tk.getToknum() != 44 && tk.getToknum() != 92) {
                    try {
                        if ("ALPHA".equals(tk.getWord())) {
                            if (this.dbType != 6) {
                                if (this.dbType != 0) {
                                    this.errPrintW();
                                } else {
                                    this.dbType = 1;
                                }
                            }
                            break block78;
                        }
                        if ("BINDEFAULT".equals(tk.getWord())) {
                            if (this.tl.getNext().getToknum() == 61) {
                                if (this.defValue.equals("")) {
                                    if (this.foundBindefault) {
                                        this.error.print(221, 2, this.first, this.first.getWord());
                                    }
                                    this.defValue = this.tl.getNext().getCode().replace("\\\\x", "\\x");
                                    this.foundBindefault = true;
                                    break block78;
                                }
                                this.errPrintW();
                                return;
                            }
                            this.errPrintW();
                            return;
                        }
                        if ("CBDEFAULT".equals(tk.getWord())) {
                            if (this.tl.getNext().getToknum() == 61) {
                                if (this.defValue.equals("")) {
                                    this.defValue = this.tl.getNext().getCode();
                                    if (this.foundCbdefault) {
                                        this.error.print(221, 2, this.first, this.first.getWord());
                                    }
                                    this.foundCbdefault = true;
                                    this.foundBindefault = false;
                                    break block78;
                                }
                                this.errPrintW();
                                return;
                            }
                            this.errPrintW();
                            return;
                        }
                        if ("BINARY".equals(tk.getWord())) {
                            if (this.dbType == 6) {
                                this.dbType = 7;
                            } else if (this.dbType != 0) {
                                this.errPrintW();
                            } else {
                                this.dbType = 2;
                            }
                            break block78;
                        }
                        if ("COBTRIGGER".equals(tk.getWord())) {
                            if (this.tl.getNext().getToknum() == 61) {
                                if (this.cobTrigger != null) {
                                    this.error.print(221, 2, this.first, this.first.getWord());
                                }
                                this.cobTrigger = this.tl.getNext().getCode();
                                break block78;
                            }
                            this.errPrintW();
                            return;
                        }
                        if ("COMMENT".equals(tk.getWord())) {
                            this.comment = "";
                            int lineC = tk.getFLN();
                            while ((tk = this.tl.getNext()) != null && tk.getFLN() == lineC) {
                                this.comment = this.comment + tk.getWord() + " ";
                            }
                            if (tk != null) {
                                tk = this.tl.getPrevious();
                            }
                            break block78;
                        }
                        if ("DATE".equals(tk.getWord())) {
                            if (this.dbType == 3) {
                                this.error.print(221, 2, this.first, this.first.getWord());
                            } else if (this.dbType != 0) {
                                this.errPrintW();
                            }
                            this.dbType = 3;
                            tk = this.tl.getNext();
                            if (tk != null) {
                                if (tk.getToknum() == 61) {
                                    this.format = this.tl.getNext().getCode();
                                    if (!this.checkDateFormat()) {
                                        this.errPrintW();
                                        return;
                                    }
                                } else {
                                    this.tl.getPrevious();
                                }
                            }
                            break block78;
                        }
                        if ("SERIAL".equals(tk.getWord())) {
                            if (this.dbType != 0) {
                                this.errPrintW();
                            }
                            this.dbType = 5;
                            tk = this.tl.getNext();
                            if (tk == null) break block78;
                            if (tk.getToknum() == 61) {
                                try {
                                    int i = Integer.parseInt(this.tl.getNext().getCode());
                                    this.format = "" + i;
                                    break block78;
                                }
                                catch (NumberFormatException _ex) {
                                    this.errPrintW();
                                    return;
                                }
                            }
                            this.tl.getPrevious();
                            break block78;
                        }
                        if ("VAR-LENGTH".equals(tk.getWord())) {
                            this.origDbType = this.dbType;
                            if (this.dbType == 2) {
                                this.dbType = 7;
                            } else if (this.dbType == 0 || this.dbType == 1) {
                                this.dbType = 6;
                            } else {
                                this.errPrintW();
                            }
                            break block78;
                        }
                        if ("FIX-LENGTH".equals(tk.getWord())) {
                            if (this.dbType == 0 || this.dbType == 1) {
                                this.dbType = 8;
                            } else {
                                this.errPrintW();
                            }
                            break block78;
                        }
                        if ("FILE".equals(tk.getWord())) {
                            if (this.tl.getNext().getToknum() == 61) {
                                if (this.file != null) {
                                    this.error.print(221, 2, this.first, this.first.getWord());
                                }
                                this.file = this.tl.getNext().getCode();
                                break block78;
                            }
                            this.errPrintW();
                            return;
                        }
                        if ("NAME".equals(tk.getWord())) {
                            if (this.tl.getNext().getToknum() == 61) {
                                if (this.name != null) {
                                    this.error.print(221, 2, this.first, this.first.getWord());
                                }
                                this.name = this.tl.getNext().getCode();
                                this.checkName(this.name);
                                break block78;
                            }
                            this.errPrintW();
                            return;
                        }
                        if ("NUMERIC".equals(tk.getWord())) {
                            if (this.dbType != 0) {
                                this.errPrintW();
                            }
                            this.dbType = 4;
                            break block78;
                        }
                        if ("SPLIT".equals(tk.getWord())) {
                            this.split = true;
                            break block78;
                        }
                        if ("HIDDEN".equals(tk.getWord())) {
                            this.hidden = true;
                            break block78;
                        }
                        if ("READ-ONLY".equals(tk.getWord())) {
                            this.readOnly = true;
                            break block78;
                        }
                        if ("USE".equals(tk.getWord())) {
                            if ("GROUP".equals(this.tl.getNext().getWord())) {
                                this.useGroup = true;
                                break block78;
                            }
                            this.errPrintW();
                            return;
                        }
                        if ("WHEN".equals(tk.getWord())) {
                            while (tk != null && "WHEN".equals(tk.getWord())) {
                                this.when = new EfdWhen(this.tl, err, this.first);
                                if (this.when.isWrongFormat()) {
                                    this.errPrintW();
                                }
                                tk = this.tl.getNext();
                            }
                            if (tk != null) {
                                this.tl.getPrevious();
                            }
                            break block78;
                        }
                        if (efc && "ALWAYS".equals(tk.getWord())) {
                            tk = this.tl.getNext();
                            if (tk != null) {
                                if ("TABLENAME".equals(tk.getWord())) {
                                    if (this.tl.getNext().getToknum() != 61) throw new NullPointerException();
                                    if (this.always != null) {
                                        this.error.print(221, 2, this.first, this.first.getWord());
                                    }
                                    this.always = this.tl.getNext().getCode();
                                } else {
                                    this.tl.getPrevious();
                                }
                            }
                            break block78;
                        }
                        if ("HINT".equals(tk.getWord())) {
                            this.hint = new EfdHint(this.tl);
                            this.hintList.addElement(this.hint);
                            break block78;
                        }
                        if ("NOCONVERTERROR".equals(tk.getWord())) {
                            this.convertError = false;
                            break block78;
                        }
                        if ("TEMPORARY".equals(tk.getWord())) {
                            if (this.temporary) {
                                this.error.print(221, 2, this.first, this.first.getWord());
                            }
                            this.temporary = true;
                            this.temporaryType = "GLOBAL";
                            tk = this.tl.getNext();
                            if (tk != null) {
                                if (tk.getToknum() == 61) {
                                    this.temporaryType = this.tl.getNext().getCode().toUpperCase();
                                    if (!this.temporaryType.equals("GLOBAL") && !this.temporaryType.equals("PRIVATE")) {
                                        this.errPrintW();
                                        return;
                                    }
                                } else {
                                    this.tl.getPrevious();
                                }
                            }
                            break block78;
                        }
                        this.errPrintW();
                        return;
                    }
                    catch (NullPointerException _ex) {
                        this.errPrintW();
                        return;
                    }
                }
            }
            tk = this.tl.getNext();
        }
    }

    @Override
    public boolean isAlpha() {
        return this.dbType == 1;
    }

    @Override
    public boolean isBinary() {
        return this.dbType == 2;
    }

    @Override
    public boolean isLongChar() {
        return this.dbType == 6;
    }

    @Override
    public boolean isChar() {
        return this.dbType == 8;
    }

    @Override
    public boolean isLongBinary() {
        return this.dbType == 7;
    }

    @Override
    public String getCobtrigger() {
        return this.cobTrigger;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getXmlComment() {
        return "<!--" + this.comment + "-->";
    }

    @Override
    public String getDate() {
        if (this.dbType == 3) {
            if (this.format != null) {
                return this.format;
            }
            return "";
        }
        return null;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNumeric() {
        return this.dbType == 4 || this.dbType == 3;
    }

    @Override
    public boolean isSplit() {
        return this.split;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isUseGroup() {
        return this.useGroup;
    }

    @Override
    public boolean isConvertError() {
        return this.convertError;
    }

    @Override
    public boolean hasWhen() {
        return this.when != null;
    }

    public EfdWhen getWhen() {
        return this.when;
    }

    @Override
    public String getWhenCondValue() {
        String Return2 = "";
        String actTok = null;
        Vector allTokenXml = this.when.getAllTokenXml();
        if (this.when != null) {
            Enumeration en = allTokenXml.elements();
            while (en.hasMoreElements()) {
                actTok = (String)en.nextElement();
                if (actTok.equals("eq")) {
                    Return2 = Return2 + "= ";
                    continue;
                }
                if (actTok.equals("ne")) {
                    Return2 = Return2 + "NOT = ";
                    continue;
                }
                if (actTok.equals("le")) {
                    Return2 = Return2 + "<= ";
                    continue;
                }
                if (actTok.equals("lt")) {
                    Return2 = Return2 + "< ";
                    continue;
                }
                if (actTok.equals("gt")) {
                    Return2 = Return2 + "> ";
                    continue;
                }
                if (actTok.equals("ge")) {
                    Return2 = Return2 + ">= ";
                    continue;
                }
                Return2 = Return2 + " " + actTok;
            }
        }
        return Return2;
    }

    @Override
    public String getWhenTableName() {
        if (this.when != null) {
            return this.when.getTableName();
        }
        return null;
    }

    public void setWhen(EfdWhen w) {
        this.when = w;
    }

    @Override
    public String getAlways() {
        return this.always;
    }

    public void setAlwaysNumber(int num) {
        this.alwaysNum = num;
    }

    @Override
    public int getAlwaysNumber() {
        return this.alwaysNum;
    }

    @Override
    public String getSerial() {
        if (this.dbType == 5) {
            if (this.format != null) {
                return this.format;
            }
            return "";
        }
        return null;
    }

    private boolean checkDateFormat() {
        char[] f = this.format.toCharArray();
        block4: for (int i = 0; i < f.length; ++i) {
            switch (f[i]) {
                case 'D': 
                case 'E': 
                case 'H': 
                case 'J': 
                case 'M': 
                case 'N': 
                case 'S': 
                case 'T': 
                case 'Y': {
                    continue block4;
                }
                case 'd': 
                case 'e': 
                case 'h': 
                case 'j': 
                case 'm': 
                case 'n': 
                case 's': 
                case 't': 
                case 'y': {
                    f[i] = Character.toUpperCase(f[i]);
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        this.format = new String(f);
        return true;
    }

    public static String getDefaultDateFormat(int len) {
        String dateFormat = "YYYYMMDD";
        if (len < 8) {
            return dateFormat.substring(8 - len, 8);
        }
        return dateFormat;
    }

    @Override
    public String getDefValue() {
        return this.defValue;
    }

    @Override
    public boolean hasBindefault() {
        return this.foundBindefault;
    }

    public EfdHint getHint() {
        return this.hint;
    }

    public Vector getHints() {
        return this.hintList;
    }

    @Override
    public boolean hasHint() {
        return this.foundHint;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public String getTemporaryType() {
        return this.temporaryType;
    }

    public void errPrintW() {
        if (!this.wrongFormat) {
            this.error.print(120, 4, this.first, this.first.getWord());
            this.wrongFormat = true;
        }
    }

    public void errPrintWarnDate() {
        if (!this.wrongFormat) {
            this.error.print(260, 2, this.first, this.first.getWord());
        }
    }

    public void updateDbType() {
        if (this.origDbType != -1) {
            this.dbType = this.origDbType;
        }
    }

    public void checkName(String name) {
        String intName = name.toUpperCase();
        for (int i = 0; i < name.length(); ++i) {
            if (intName.charAt(i) >= 'A' && intName.charAt(i) <= 'Z' || intName.charAt(i) >= '0' && intName.charAt(i) <= '9' || intName.charAt(i) == '-' || intName.charAt(i) == '_') continue;
            this.error.print(306, 2, this.first, name);
            break;
        }
    }
}

