/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Invoke;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.MethodProcedure;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.interfaces.compiler.ICobolMethod;
import com.iscobol.interfaces.compiler.IDataSection;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class CobolMethod
extends Pcc
implements ICobolMethod {
    static final String localDataPrefix = "data$";
    static final String localClassPrefix = "class$";
    static final String $This$ = "$This$";
    private int progMethod;
    private EnvironmentDivision environment;
    private Token methodId;
    private String externName;
    private boolean override;
    private Invoke superInvoke;
    private int visibility = 1;
    private Token firstToken;
    private Token lastToken;
    private String doc;
    private boolean isFinalize;
    private boolean isSet;
    private boolean isGet;
    private boolean isDefault;
    private boolean isStatic;
    private final HashSet finallyCode = new HashSet(){

        @Override
        public String toString() {
            StringBuffer Return2 = new StringBuffer();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Return2.append(i.next().toString());
            }
            return Return2.toString();
        }
    };

    public CobolMethod(Pcc p) {
        super(p);
        this.parent = p;
        this.createFixedVars(false, this);
        VariableDeclaration vd = this.fixedVars.getFirst();
        while (vd != null) {
            this.loadVariable(vd);
            vd = this.fixedVars.getNext();
        }
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    boolean getSplitFlag() {
        return this.parent.getSplitFlag();
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean start() {
        boolean Return2 = true;
        try {
            Token tk;
            try {
                this.methodId();
            }
            catch (GeneralErrorException e) {
                Return2 = false;
                this.tm.skipTill(new int[]{458, 388, 705, 651, 422});
            }
            try {
                tk = this.tm.getToken();
                if (tk.getToknum() == 458) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 410) throw new UnexpectedTokenException(tk, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, tk, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.environment = new EnvironmentDivision(this, this.tm, this.error, tk);
            }
            catch (GeneralErrorException e) {
                Return2 = false;
                this.tm.skipTill(new int[]{388, 705, 651, 422});
            }
            try {
                tk = this.tm.getToken();
                if (tk.getToknum() == 388) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 410) throw new UnexpectedTokenException(tk, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, tk, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.data = new DataDivision(this, this.tm, this.error, tk);
            }
            catch (GeneralErrorException e) {
                Return2 = false;
                this.tm.skipTill(new int[]{705, 651, 422});
            }
            try {
                this.checkPost();
                if (this.gEnvironment != null) {
                    this.gEnvironment.check(this);
                }
                if (this.environment != null) {
                    this.environment.check(this);
                }
                if (this.data != null) {
                    this.data.check();
                }
            }
            catch (GeneralErrorException e) {
                Return2 = false;
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 705) {
                if (this.data != null) {
                    try {
                        this.data.scanScreenSection(tk);
                        this.loadVariablesScreenSec();
                    }
                    catch (GeneralErrorException e) {
                        Return2 = false;
                        this.tm.skipTill(new int[]{651, 422});
                    }
                }
            } else {
                this.tm.ungetToken();
            }
            if ((tk = this.tm.getToken()).getToknum() == 651) {
                try {
                    this.procedure = new MethodProcedure(this, this.tm, this.error, this.getVisDescr(), tk);
                    if (this.data != null && this.data.linkSec != null) {
                        this.data.linkSec.checkVarargsItems();
                    }
                }
                catch (GeneralErrorException e) {
                    Return2 = false;
                }
            } else {
                this.tm.ungetToken();
            }
            this.checkUsed();
            tk = this.tm.getToken();
            if (tk.getToknum() == 422 && (tk = this.tm.getToken()).getToknum() == 584) {
                Token tk1 = this.tm.getToken();
                if (tk1.getToknum() == 10009) {
                    if (this.methodId == null || !this.methodId.getWord().equals(tk1.getWord())) {
                        this.error.print(83, 3, tk1, tk1.getWord());
                    }
                } else if (tk1.getToknum() == 10001) {
                    if (this.externName == null || !this.externName.equals(tk1.getCode())) {
                        this.error.print(83, 3, tk1, tk1.getWord());
                    }
                } else {
                    this.tm.ungetToken();
                }
                if ((tk1 = this.tm.getToken()).getToknum() != 10006) {
                    this.error.print(188, 3, tk, "'.'");
                    this.tm.ungetToken();
                } else {
                    tk = tk1;
                }
                this.lastToken = tk;
            } else {
                Return2 = false;
                this.error.print(31, 4, tk, "END METHOD./" + tk.getWord());
            }
            boolean bl = this.isFinalize = "finalize".equals(this.getMethodName()) && this.procedure != null && this.procedure.using.getItemNum() == 0;
            if (!this.isFinalize) return Return2;
            this.setUserDefinedFinalize(true);
            return Return2;
        }
        catch (EndOfProgramException e) {
            this.error.print(12, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
            return false;
        }
        catch (GeneralErrorException e) {
            this.error.print(11, 4, this.tm.getLineNumber(), 0, e.toString(), null, this.tm.getFileName());
            return false;
        }
    }

    private void methodId() throws GeneralErrorException, EndOfProgramException {
        Token mId;
        Token tk;
        this.firstToken = tk = this.tm.getToken();
        boolean isInterface = this.getRoot().isInterface();
        if (tk.getToknum() == 522 || tk.getToknum() == 521) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 410) {
                if (this.tm.getToken().getToknum() != 10006) {
                    this.error.print(188, 3, tk, "'.'");
                    this.tm.ungetToken();
                }
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            mId = this.tm.getToken();
        } else {
            mId = this.firstToken;
        }
        if (mId.getToknum() == 585) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            this.doc = mId.doc;
            tk = this.tm.getToken();
            boolean bl = this.isSet = tk.getToknum() == 719;
            if (this.isSet || (this.isGet = tk.getWord().equals("GET"))) {
                tk = this.tm.getToken();
                if (tk.getToknum() != 657) {
                    throw new ExpectedFoundException(tk, this.error, "PROPERTY");
                }
                tk = this.tm.getToken();
                if (tk.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                tk.setWord((this.isSet ? "set" : "get") + tk.getWord());
                this.externName = Pcc.isValidMethodName(tk.getCode());
                if (this.externName == null) {
                    throw new GeneralErrorException(83, 4, tk, tk.getCode(), this.error);
                }
                this.methodId = tk;
                this.visibility = 1;
                tk = this.tm.getToken();
            } else {
                if (tk.getToknum() == 10009) {
                    this.methodId = tk;
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 280) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 10001) {
                    if (this.methodId == null) {
                        this.methodId = new Token(tk);
                    }
                    this.externName = Pcc.isValidMethodName(tk.getCode());
                    if (this.externName == null) {
                        throw new GeneralErrorException(83, 4, tk, tk.getCode(), this.error);
                    }
                } else if (this.methodId != null) {
                    this.externName = Pcc.isValidMethodName(this.methodId.getCode());
                    if (this.externName == null) {
                        throw new GeneralErrorException(83, 4, this.methodId, this.methodId.getCode(), this.error);
                    }
                    this.tm.ungetToken();
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                if ((tk = this.tm.getToken()).getToknum() == 545) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 649) {
                    if (isInterface) {
                        throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
                    }
                    this.visibility = 2;
                    tk = this.tm.getToken();
                } else if (tk.getToknum() == 658) {
                    if (isInterface) {
                        throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
                    }
                    this.visibility = 4;
                    tk = this.tm.getToken();
                } else if (tk.getToknum() == 659) {
                    this.visibility = 1;
                    tk = this.tm.getToken();
                }
            }
            if (isInterface && (this.isUnnamed() || this.isConstructor())) {
                throw new GeneralErrorException(83, 4, this.methodId, this.methodId.getCode(), this.error);
            }
            if (tk.getToknum() == 396) {
                if (!isInterface || this.parent.isFactory()) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                this.isDefault = true;
                tk = this.tm.getToken();
            } else if (tk.getWord().equals("STATIC")) {
                if (!isInterface || !this.parent.isFactory()) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = this.tm.getToken();
                this.isStatic = true;
            }
            if (tk.getToknum() == 626) {
                this.override = true;
            } else {
                this.tm.ungetToken();
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            if (this.parent.isFactory() && isInterface && !this.isStatic) {
                throw new GeneralErrorException(247, 4, this.methodId, null, this.error);
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
    }

    @Override
    public boolean isConstructor() {
        return "new".equals(this.externName);
    }

    @Override
    public String getMethodName() {
        if ("new".equals(this.externName)) {
            return this.parent.getClassName();
        }
        return this.externName;
    }

    @Override
    public void loadProgVariable(VariableDeclaration v) {
        this.loadVariable(v);
    }

    protected void loadVariablesScreenSec() throws GeneralErrorException {
        if (this.data != null && this.data.screenSec != null) {
            VariableDeclaration v = this.data.screenSec.vars.getFirst();
            while (v != null) {
                this.loadVariable(v);
                v.calcOffset(this, 0);
                v = this.data.screenSec.vars.getNext();
            }
        }
    }

    public boolean isVarArgs() {
        return this.procedure != null && this.procedure.usingVarargs != null;
    }

    protected void doCheck() throws GeneralErrorException {
        Block b = this.allBlocks.getFirst();
        while (b != null) {
            b.check();
            b = this.allBlocks.getNext();
        }
        if (this.data != null && this.data.screenSec != null) {
            this.data.screenSec.check();
        }
        if (this.procedure == null) {
            throw new GeneralErrorException(73, 4, 0, 0, this.methodId.getWord(), this.tm.getFileName(), null, this.error);
        }
        if (this.isConstructor() && this.procedure.returning != null) {
            throw new GeneralErrorException(79, 4, 0, 0, this.methodId.getWord(), this.tm.getFileName(), null, this.error);
        }
        ArrayList<MyClass> thisExtends = new ArrayList<MyClass>();
        if (this.parent.getInheritsClass() != null) {
            try {
                thisExtends.add(MyClass.getInstance(this.parent.getInheritsClass(), this));
            }
            catch (ClassNotFoundException e) {
                thisExtends.add(MyClass.getInstance(Object.class));
            }
        } else {
            thisExtends.add(MyClass.getInstance(Object.class));
        }
        if (this.parent.getImplementsClass() != null) {
            for (String intf : this.parent.getImplementsClass()) {
                try {
                    MyClass c = MyClass.getInstance(intf, this);
                    thisExtends.add(c);
                    this.getInterfaces(c, thisExtends);
                }
                catch (ClassNotFoundException e) {
                    System.err.println(e);
                }
            }
        }
        if ("".equals(this.externName)) {
            if (this.procedure.using != null && !this.procedure.using.isEmpty()) {
                throw new GeneralErrorException(206, 4, this.methodId, "USING", this.error);
            }
            if (this.procedure.returning != null) {
                throw new GeneralErrorException(206, 4, this.methodId, "RETURNING", this.error);
            }
            if (this.procedure.raising != null) {
                throw new GeneralErrorException(206, 4, this.methodId, "RAISING", this.error);
            }
        } else if (!"new".equals(this.externName)) {
            VariableDeclaration vd;
            if (this.isSet) {
                if (this.getProcedureDivision().getUsing().getItemNum() != 1) {
                    throw new GeneralErrorException(237, 4, this.methodId, "", this.error);
                }
                if (this.getProcedureDivision().getReturning() != null) {
                    throw new GeneralErrorException(238, 4, this.methodId, "", this.error);
                }
                vd = this.getProcedureDivision().getUsing().getFirst().getVarDecl().cloneVarDecl("tmp" + this.externName, this.parent, 1);
                this.parent.getDataDivision().getWorkingStorageSection().getVariableDeclarationList().addItem(vd);
            } else if (this.isGet) {
                if (this.getProcedureDivision().getUsing().getItemNum() > 0) {
                    throw new GeneralErrorException(239, 4, this.methodId, "", this.error);
                }
                if (this.getProcedureDivision().getReturning() == null) {
                    throw new GeneralErrorException(240, 4, this.methodId, "", this.error);
                }
                vd = this.getProcedureDivision().getReturning().getVarDecl().cloneVarDecl("tmp" + this.externName, this.parent, 1);
                this.parent.getDataDivision().getWorkingStorageSection().getVariableDeclarationList().addItem(vd);
            }
            boolean foundOverridden = false;
            for (MyClass ext : thisExtends) {
                int i;
                MyMethod[] mm = ext.getMethods(true);
                for (i = mm.length - 1; i >= 0; --i) {
                    int j;
                    MyClass[] p2;
                    MyClass[] p1;
                    if (!this.externName.equals(mm[i].getName()) || Modifier.isStatic(mm[i].getModifiers()) != this.isFactory() || (p1 = mm[i].getParameterTypes()).length != (p2 = this.getParameterTypes()).length) continue;
                    for (j = p1.length - 1; j >= 0 && p1[j].equals(p2[j]); --j) {
                    }
                    if (j < 0) break;
                }
                if (i < 0) continue;
                foundOverridden = true;
                if (mm[i].getReturnType().isAssignableFrom(this.getReturnType())) {
                    if (this.override) continue;
                    this.error.print(161, 2, this.methodId, "without OVERRIDE: " + this.externName);
                    continue;
                }
                throw new GeneralErrorException(162, 4, this.methodId, this.externName, this.error);
            }
            if (!foundOverridden && this.override) {
                throw new GeneralErrorException(161, 4, this.methodId, "that doesn't exist: " + this.externName, this.error);
            }
        }
    }

    private void getInterfaces(MyClass c, ArrayList<MyClass> r) {
        for (MyClass intf : c.getInterfaces()) {
            r.add(intf);
            this.getInterfaces(intf, r);
        }
    }

    protected void doCode(PrintWriter progFile) throws GeneralErrorException {
        StringBuffer data = new StringBuffer();
        int innerClassCount = this.writeData(data);
        progFile.print(((MethodProcedure)this.procedure).getCode(this, data.toString(), this.getUniqueId(), this.doc, innerClassCount));
    }

    @Override
    public MyClass getReturnType() {
        return this.procedure != null ? ((MethodProcedure)this.procedure).getReturnType() : null;
    }

    public MyClass[] getParameterTypes() {
        return this.procedure != null ? ((MethodProcedure)this.procedure).getParameterTypes() : null;
    }

    private int writeData(StringBuffer Return2) throws GeneralErrorException {
        int innerClassCount = -1;
        StringBuffer dynPart = new StringBuffer();
        StringBuffer fixedVarPart = new StringBuffer();
        boolean debug = this.parent.getOption("-d") != null;
        boolean debugExt = this.parent.getOption("-dx") != null;
        boolean split = this.getSplitFlag();
        String localDataClass = this.getLocalDataClass();
        if (split) {
            innerClassCount = 0;
            Return2.append(eol + "   public class " + localDataClass + "inner_" + innerClassCount);
            if (debug) {
                Return2.append(" implements IscobolDebugger");
            }
            if (debugExt) {
                Return2.append(", IscobolDebuggerExtension");
            }
            Return2.append(" {" + eol);
            Return2.append("   public " + localDataClass + "inner_" + innerClassCount + "() {}" + eol);
            ++innerClassCount;
        }
        VariableDeclaration v = this.fixedVars.getFirst();
        while (v != null) {
            Return2.append(v.getCode(fixedVarPart));
            v = this.fixedVars.getNext();
        }
        if (this.data != null) {
            if (split) {
                int i = 0;
                StringBuffer ddCode = new StringBuffer();
                StringBuffer syncMem = new StringBuffer();
                ddCode.append(this.data.getCode(dynPart, syncMem, null));
                LineNumberReader lnr = new LineNumberReader(new StringReader(ddCode.toString()));
                String line = null;
                try {
                    line = lnr.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (line != null) {
                    if (i > 0 && i % 30000 == 0) {
                        Return2.append("   }" + eol);
                        Return2.append("   public class " + localDataClass + "inner_" + innerClassCount);
                        Return2.append(" extends " + localDataClass + "inner_" + (innerClassCount - 1));
                        if (debug) {
                            Return2.append(" implements IscobolDebugger");
                        }
                        if (debugExt) {
                            Return2.append(", IscobolDebuggerExtension");
                        }
                        Return2.append(" {" + eol);
                        Return2.append("   public " + localDataClass + "inner_" + innerClassCount + "() {}" + eol);
                        ++innerClassCount;
                    }
                    Return2.append(line + eol);
                    try {
                        line = lnr.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
                Return2.append(syncMem.toString());
                Return2.append("   }" + eol);
            } else {
                Return2.append(this.data.getCode(dynPart, null));
            }
        }
        if (this.environment != null) {
            Return2.append(this.environment.getCode(dynPart));
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (split) {
            innerClassCount = this.writeDeclaration(pw, dynPart, fixedVarPart, false, innerClassCount, localDataClass + "inner_", debug, debugExt);
        } else {
            this.writeDeclaration(pw, dynPart, fixedVarPart, false, -1, null, debug, debugExt);
        }
        Return2.append(sw.toString());
        return innerClassCount;
    }

    protected void setSuperInvoke(Invoke ik) {
        this.superInvoke = ik;
    }

    protected Invoke getSuperInvoke() {
        return this.superInvoke;
    }

    String getUniqueId() {
        if (this.progMethod == 0) {
            this.progMethod = this.parent.getNewProgClass();
        }
        return this.externName + '$' + this.progMethod;
    }

    @Override
    protected String getParaPrefix() {
        return this.getUniqueId() + "$$";
    }

    protected String getLocalDataClass() {
        return localClassPrefix + this.getUniqueId();
    }

    protected String getLocalDataName() {
        return localDataPrefix + this.getUniqueId();
    }

    @Override
    protected String getVarPrefix() {
        return this.getLocalDataName() + ".";
    }

    @Override
    protected boolean isFactory() {
        return this.parent.isFactory();
    }

    @Override
    public String getClassName() {
        return this.parent.getClassName();
    }

    @Override
    public String getFullClassName() {
        return this.parent.getFullClassName();
    }

    @Override
    public String getInheritsClass() {
        return this.parent.getInheritsClass();
    }

    @Override
    public String[] getImplementsClass() {
        return this.parent.getImplementsClass();
    }

    @Override
    public boolean isThisClass(String s) {
        return this.parent.isThisClass(s);
    }

    @Override
    public MyClass existsClass(String s) throws ClassNotFoundException {
        return this.parent.existsClass(s);
    }

    @Override
    public int getModifiers() {
        int Return2 = this.visibility;
        if (this.isFactory()) {
            Return2 |= 8;
        }
        return Return2;
    }

    public String toString() {
        return this.getMethodName();
    }

    @Override
    public SpecialNamesClass getSpecialNamesClass(String name) {
        SpecialNamesClass Return2 = super.getSpecialNamesClass(name);
        if (Return2 == null) {
            Return2 = this.parent.getSpecialNamesClass(name);
        }
        return Return2;
    }

    @Override
    public SelectList getSelectList() {
        SelectList glob;
        SelectList methd;
        SelectList Return2 = null;
        if (this.environment != null && (methd = this.environment.getSelects()) != null) {
            Return2 = new SelectList();
            Return2.addList(methd);
        }
        if ((glob = this.parent.getSelectList()) != null) {
            if (Return2 == null) {
                Return2 = new SelectList();
            }
            Return2.addList(glob);
        }
        return Return2;
    }

    @Override
    public Select getSelect(String fileName) {
        SelectList sl;
        if (this.environment != null && (sl = this.environment.getSelects()) != null) {
            Select Return2 = sl.getFirst();
            while (Return2 != null) {
                if (fileName.equals(Return2.fileName.getWord())) {
                    return Return2;
                }
                Return2 = sl.getNext();
            }
        }
        return this.parent.getSelect(fileName);
    }

    @Override
    public FileDescriptor getFdByRecord(VariableDeclaration vd) {
        FileDescriptor fd = super.getFdByRecord(vd);
        return fd == null ? this.parent.getFdByRecord(vd) : fd;
    }

    public boolean hasSameSignature(CobolMethod m) {
        MyClass[] ot;
        MyClass[] me;
        if (this.getMethodName().equals(m.getMethodName()) && (me = this.getParameterTypes()).length == (ot = m.getParameterTypes()).length) {
            for (int i = 0; i < ot.length; ++i) {
                if (me[i].equals(ot[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean isUnnamed() {
        return "".equals(this.externName);
    }

    public String getMethodDesc() {
        VariableDeclarationList vdl;
        LinkageSection lks;
        StringBuffer sb = new StringBuffer();
        sb.append(this.externName);
        DataDivision dd = this.getDataDivision();
        if (dd != null && (lks = dd.getLinkageSection()) != null && (vdl = lks.getVariableDeclarationList()).getItemNum() > 0) {
            sb.append("(");
            VariableDeclaration vd = vdl.getFirst();
            sb.append(vd.getTypeName());
            vd = vdl.getNext();
            while (vd != null) {
                sb.append(",");
                sb.append(vd.getTypeName());
                vd = vdl.getNext();
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isFinalize() {
        return this.isFinalize;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isGet() {
        return this.isGet;
    }

    private String getVisDescr() {
        switch (this.visibility) {
            case 2: {
                return "private";
            }
            case 4: {
                return "protected";
            }
        }
        return "public";
    }

    boolean hasFinallyCode() {
        return this.finallyCode.size() > 0;
    }

    void addFinallyCode(String s) {
        this.finallyCode.add(s);
    }

    String getFinallyCode() {
        return this.finallyCode.toString();
    }

    void printConstants(PrintWriter progFile, int[] count) {
        DataDivision dd = this.getDataDivision();
        if (dd != null) {
            for (IDataSection ds : new IDataSection[]{dd.getWorkingStorageSection(), dd.getLocalStorageSection(), dd.getThreadLocalStorageSection(), dd.getLinkageSection()}) {
                if (ds == null) continue;
                VariableDeclarationList vdl = (VariableDeclarationList)ds.getVariableDeclarationList();
                VariableDeclaration vd = vdl.getFirst();
                while (vd != null) {
                    CobolMethod.printConstants(vd, progFile, count);
                    vd = vdl.getNext();
                }
            }
        }
    }

    static void printConstants(VariableDeclaration vd, PrintWriter progFile, int[] count) {
        if (vd.getLevel() == 78) {
            StringBuffer buf = new StringBuffer();
            buf.append(vd.getName());
            buf.append(",");
            String val = vd.getValue(false);
            if (vd.getValueToken().getToknum() == 10001) {
                val = val.substring(1, val.length() - 1);
            }
            char[] c = val.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                String h = Integer.toHexString(c[i]);
                if (h.length() == 1) {
                    buf.append("0");
                }
                buf.append(h);
            }
            buf.append(";");
            int d = count[0] + buf.length() - 65000;
            if (d > 0) {
                progFile.print(buf.substring(0, buf.length() - d));
                progFile.print("\").append(\"");
                progFile.print(buf.substring(buf.length() - d));
                count[0] = d;
            } else {
                progFile.print(buf);
                count[0] = count[0] + buf.length();
            }
        } else {
            VariableDeclarationList children = vd.getChildren();
            VariableDeclaration cd = children.getFirst();
            while (cd != null) {
                CobolMethod.printConstants(cd, progFile, count);
                cd = children.getNext();
            }
        }
    }

    @Override
    VariableDeclaration getTypedefVar(String name) {
        CobolClass cc;
        VariableDeclaration Return2 = super.getTypedefVar(name);
        if (Return2 == null && (Return2 = this.parent.getTypedefVar(name)) == null && !this.isFactory() && (cc = this.parent.parent.getFactoryPart()) != null) {
            Return2 = cc.getTypedefVar(name);
        }
        return Return2;
    }
}

