/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.cobshell;

import com.iscobol.cobshell.CobolCommand;
import com.iscobol.cobshell.VSExecutor;
import com.veryant.joe.Block;
import com.veryant.joe.BreakCmdException;
import com.veryant.joe.BreakEndException;
import com.veryant.joe.ExecException;
import com.veryant.joe.Executor;
import com.veryant.joe.JOEException;
import com.veryant.joe.Parser;
import com.veryant.joe.ScriptManager;
import com.veryant.joe.Tokenizer;
import com.veryant.joe.WArray;
import com.veryant.joe.Wrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;

public class CobShell {
    public static final String usage = " [-tron] program";
    private Block block;

    public CobShell(String fileName) throws Exception {
        this(fileName, null);
    }

    public CobShell(String fileName, Object ... args) throws Exception {
        File f = new File(fileName).getCanonicalFile();
        CobolCommand cobcmd = new CobolCommand();
        VSExecutor exec = new VSExecutor(false);
        ScriptManager sm = new ScriptManager(f.getParentFile(), (Executor)exec, (Object)cobcmd);
        Object[] jargs = args != null ? new Object[]{new WArray(args)} : null;
        this.block = sm.newInstance(f.getName(), jargs);
    }

    public Object execBlock(String name) throws Exception {
        return this.execBlock(name, null);
    }

    public Object execBlock(String name, Object ... a1) throws Exception {
        Object Return2 = this.block.execBlock(name, a1);
        if (Return2 instanceof Wrapper) {
            Return2 = ((Wrapper)Return2).getWrapped();
        }
        return Return2;
    }

    public static void showException(CobolCommand cmd, Throwable ex) {
        cmd.display(ex.getMessage());
        Throwable cause = ex;
        while ((cause = cause.getCause()) != null) {
            cmd.display("Caused by: " + cause.toString());
        }
    }

    public static void main(String[] argv) {
        CobolCommand cobcmd = new CobolCommand();
        int rc = CobShell.imain(cobcmd, argv);
        if (rc != 0) {
            cobcmd.accept();
        }
        cobcmd.stopRun(rc);
    }

    public static int imain(String[] argv) {
        return CobShell.imain(new CobolCommand(), argv);
    }

    public static int imain(CobolCommand cobcmd, String[] argv) {
        while (true) {
            try {
                return CobShell._main(cobcmd, argv);
            }
            catch (ExecException newScript) {
                argv = newScript.cmds;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _main(CobolCommand cobcmd, String[] argv) throws ExecException {
        int Return2;
        boolean tron = false;
        VSExecutor exec = new VSExecutor(tron);
        int argIdx = 0;
        if (argIdx < argv.length && "-tron".equals(argv[argIdx])) {
            tron = true;
            ++argIdx;
        }
        if (argIdx < argv.length) {
            try {
                File f = new File(argv[argIdx]).getCanonicalFile();
                ScriptManager sm = new ScriptManager(f.getParentFile(), (Executor)exec, (Object)cobcmd);
                Object[] jarg = new Object[]{new WArray((Object[])argv)};
                sm.newInstance(f.getName(), jarg);
            }
            catch (BreakEndException ex) {
                Return2 = 0;
            }
            catch (ExecException ex) {
                throw ex;
            }
            catch (BreakCmdException ex) {
                CobShell.showException(cobcmd, new BreakCmdException("Block name not found: " + ex.getMessage()));
                Return2 = 2;
            }
            catch (JOEException ex) {
                CobShell.showException(cobcmd, ex);
                Return2 = 2;
            }
            catch (FileNotFoundException ex) {
                CobShell.showException(cobcmd, ex);
                Return2 = 3;
            }
            catch (IOException ex) {
                CobShell.showException(cobcmd, ex);
                Return2 = 4;
            }
            Return2 = 0;
        } else {
            Return2 = 0;
            File cwd = new File(System.getProperty("user.dir"));
            ScriptManager sm = new ScriptManager(cwd, (Executor)exec, (Object)cobcmd);
            Object cmd = cobcmd;
            String line = "";
            cobcmd.displayOut(true, "CobShell interactive ready, type 'exit' to exit the session");
            cobcmd.display();
            Parser prg = new Parser(cmd, (Executor)exec, "<stdin>");
            Block b = null;
            while (!"exit".equals(line)) {
                cobcmd.displayOut(false, "cs> ");
                line = cobcmd.accept().toString();
                ArrayDeque tokens = new ArrayDeque();
                Tokenizer tkzer = new Tokenizer();
                tkzer.tokenize(line.toCharArray(), tokens);
                try {
                    b = prg.compile(tokens);
                    try {
                        b.init();
                        cmd = prg.getCommand();
                    }
                    catch (JOEException ex) {
                        CobShell.showException(cobcmd, ex);
                        Return2 = 2;
                    }
                    finally {
                        b.clear();
                    }
                }
                catch (Exception ex) {
                    CobShell.showException(cobcmd, ex);
                    Return2 = 3;
                    break;
                }
            }
        }
        return Return2;
    }
}

