/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.turborun;

import com.iscobol.as.AppServerImpl;
import com.iscobol.as.turborun.TRServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.logging.Logger;

class SocketInputReader
extends Thread {
    private LinkedList<String> lines = new LinkedList();
    private final Socket sock;
    private final InputStream sockIn;
    private final String remoteHost;
    private final int remotePort;
    private final int id;
    Logger log;

    public SocketInputReader(Socket sock, InputStream sockIn, String remoteHost, int remotePort, int id) {
        this.setName("SocketInputReader-Thread-" + id);
        this.setDaemon(true);
        this.sock = sock;
        this.sockIn = sockIn;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            String line;
            if ((line = TRServer.readLine(this.sockIn, false)) == null) {
                this.log.info("Closed client connection from " + this.remoteHost + " on port " + this.remotePort);
                try {
                    this.sock.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            LinkedList<String> linkedList = this.lines;
            synchronized (linkedList) {
                this.lines.addLast(line);
                this.lines.notifyAll();
            }
        }
        AppServerImpl.kill(this.id, 253);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLine() {
        LinkedList<String> linkedList = this.lines;
        synchronized (linkedList) {
            while (this.lines.isEmpty()) {
                try {
                    this.lines.wait();
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }
            return this.lines.removeFirst();
        }
    }

    InputStream getSockIn() {
        return this.sockIn;
    }
}

