      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION.
       PROGRAM-ID. io-sequential.

       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT FILE1 ASSIGN TO "FileSequential"
                 ORGANIZATION IS SEQUENTIAL
                 LOCK MODE IS MANUAL
                 FILE STATUS IS FILE-STATUS.

       DATA DIVISION.
       FILE SECTION.
       FD  FILE1.
       01  REC-FILE1 PIC X(1000).

       WORKING-STORAGE SECTION.
       78  NUM-TIMES            VALUE 10000.

       77  FILE-STATUS          PIC X(2).
       77  SYNC-TIME-1          PIC 9(8).
       77  SYNC-TIME-2          PIC 9(8).
       77  TIME-DIFF            PIC 9(6)V99.
       77  BEGIN-SECS           PIC 9(6)V99.
       77  END-SECS             PIC 9(6)V99.
       77  BEGIN-TIME           PIC 9(8).
       01  BEGIN-TIME-FIELDS    REDEFINES BEGIN-TIME.
           03  BEGIN-HOURS      PIC 9(2).
           03  BEGIN-MINUTES    PIC 9(2).
           03  BEGIN-SECONDS    PIC 9(2).
           03  BEGIN-HUNDRETHS  PIC 9(2).
       77  END-TIME             PIC 9(8).
       01  END-TIME-FIELDS      REDEFINES END-TIME.
           03  END-HOURS        PIC 9(2).
           03  END-MINUTES      PIC 9(2).
           03  END-SECONDS      PIC 9(2).
           03  END-HUNDRETHS    PIC 9(2).
       77  TOTAL-TIME           PIC 9(7)V99 VALUE ZERO.
       77  TIME-DISP            PIC Z,ZZZ,ZZ9.99.
       77  IND                  PIC 9(9).
       77  FLAG-EOF             PIC 9.

       PROCEDURE DIVISION.
       MAIN-LOGIC.
           DISPLAY " "
           DISPLAY "SEQUENTIAL FILES"
           DISPLAY "NUM-TIMES:  " NUM-TIMES

           PERFORM LOAD-FILE1-TEST.
           PERFORM READ-FILE1-TEST.

           MOVE TOTAL-TIME TO TIME-DISP
           DISPLAY "Total Time: " TIME-DISP

           GOBACK
           .

       LOAD-FILE1-TEST.
           OPEN OUTPUT FILE1.
           PERFORM START-TIMER.
           PERFORM VARYING IND FROM 1 BY 1 UNTIL IND > NUM-TIMES
              MOVE IND TO REC-FILE1
              WRITE REC-FILE1
           END-PERFORM.
           PERFORM STOP-TIMER.
           CLOSE FILE1.
           ADD TIME-DIFF TO TOTAL-TIME.
           MOVE TIME-DIFF TO TIME-DISP
           DISPLAY "WRITE:      " TIME-DISP
           .

       READ-FILE1-TEST.
           OPEN INPUT FILE1.
           PERFORM START-TIMER.
           PERFORM UNTIL FLAG-EOF = 1
              READ FILE1 NEXT RECORD
               AT END 
                 MOVE 1 TO FLAG-EOF
              END-READ
           END-PERFORM.
           PERFORM STOP-TIMER.
           CLOSE FILE1.
           ADD TIME-DIFF TO TOTAL-TIME.
           MOVE TIME-DIFF TO TIME-DISP
           DISPLAY "READ:       " TIME-DISP
           .

       START-TIMER.
           ACCEPT SYNC-TIME-1 FROM TIME.
           PERFORM WITH TEST AFTER UNTIL SYNC-TIME-1 NOT = SYNC-TIME-2
               ACCEPT SYNC-TIME-2 FROM TIME
           END-PERFORM.
           ACCEPT BEGIN-TIME FROM TIME
           .

       STOP-TIMER.
           ACCEPT END-TIME FROM TIME.
           COMPUTE BEGIN-SECS = (BEGIN-HOURS * 3600) +
               (BEGIN-MINUTES * 60) + (BEGIN-SECONDS) +
               (BEGIN-HUNDRETHS / 100).
           COMPUTE END-SECS = (END-HOURS * 3600) +
               (END-MINUTES * 60) + (END-SECONDS) +
               (END-HUNDRETHS / 100).
           IF (END-SECS < BEGIN-SECS) THEN
               ADD 86400 TO END-SECS
           END-IF.
           COMPUTE TIME-DIFF = END-SECS - BEGIN-SECS
           .