      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. Print-Procedure.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           select print-file assign to "FILE1"
                   organization is line sequential
                   access is sequential.

       FILE SECTION.
       fd  print-file.
       01  print-rec.
           03 line-count           pic 9(10).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       78  78-ulimit               value 999999.
       78  78-stop-cancel-thread   value "A".
       78  78-stop-show-thread     value "B".
       77  hWin                    handle of window.
       77  hMain                   handle of thread.
       77  hCancel                 handle of thread.
       77  hPrint                  handle of thread.
       77  hShow                   handle of thread. 
       77  msg-string              pic x.
       77  crt-status is special-names crt status pic 999.
           88 k-esc                value 27.
           88 k-message            value W-MESSAGE.
       77  receive-status          pic 99.
       77  W-Result                pic 9(5).
       77  W-Remainder             pic 9(2).
       77  end-job-reason          pic 9 value 0.
           88 user-cancel          value 1.

       SCREEN SECTION.
       01  screen-info.
           03 label        line            2
                           col             2
                           title           "Print row"
                           size            10 cells 
                           .
           03 msg-label           
              label        col             + 1
                           size            10      cells
                           from            line-count
                           pic             z,zzz,zzz,zz9
                           .

       PROCEDURE DIVISION.
       MAIN-LOGIC.
           accept hMain from thread.

           display standard window background-low
                   handle hWin.
                
           display screen-info.
           open output print-file.

           call thread "CANCEL-PROC" handle in hCancel.

           perform thread SHOW-PROGRESS handle in hShow.

           perform test after varying line-count from 1 by 1 
                                until line-count >= 78-ulimit
              write print-rec

              divide line-count by 50 giving W-Result
                                   remainder W-Remainder
              if W-Remainder = 0
                 receive msg-string from hCancel 
                    no wait
                    not on exception
                       if msg-string = 78-stop-cancel-thread 
                          set user-cancel to true
                          exit perform
                       end-if
                 end-receive
              end-if

           end-perform.
           close print-file.

           send 78-stop-show-thread to hShow.
           wait for hShow.
           move 0 to hShow.

           send 78-stop-cancel-thread to hCancel.
           wait for hCancel.
           move 0 to hCancel.
            
           if user-cancel
              display message "User cancelled" icon mb-warning-icon
           else
              display message "Done" icon mb-default-icon
           end-if.

           destroy screen-info.  
           destroy hWin.
           goback.
           

       SHOW-PROGRESS.
           perform until 1 = 2
              display msg-label
              receive msg-string from hMain
                 before time 100
                 not on exception  
                    if msg-string = 78-stop-show-thread
                       exit perform
                    end-if
              end-receive
           end-perform.
           display msg-label.

