      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. pcustomer.
       input-output section.
       file-control.
           copy "customer.sel".
       data division.
       file section.
           copy "customer.fd".

       working-storage section.
       copy "constants.def".
       77  cust-status  pic xx.
       77  status-99    pic 99.
       77  num-para     pic 99 comp-1.
       77  size-para    pic 9(5).

       linkage section.
       77  lk-op-code   pic x.
       77  lk-rec       pic x(1000).

       procedure division using lk-op-code, lk-rec.
       main.
           call "C$NARG" using num-para
           if num-para > 1
              call "C$PARAMSIZE" using 2 giving size-para
           end-if
           evaluate lk-op-code
           when 78-open-input
                open input customer
                if cust-status = "35"
                   perform VALORIZE-INITIAL-DATA
                   open input customer
                end-if
           when 78-open-output
                open output customer
           when 78-open-i-o
                open i-o customer
                if cust-status = "35"
                   perform VALORIZE-INITIAL-DATA
                   open i-o customer
                end-if
           when 78-close
                close customer
           when 78-start
                move lk-rec(1:size-para) to cust-code(1:)
                start customer key is = cust-code
           when 78-start-great
                move lk-rec(1:size-para) to cust-code(1:)
                start customer key is > cust-code
           when 78-start-less
                move lk-rec(1:size-para) to cust-code(1:)
                start customer key is < cust-code
           when 78-read
                move lk-rec(1:size-para) to customer-rec
                read customer key is cust-code
                move customer-rec to lk-rec(1:size-para)
           when 78-read-next
                read customer next
                move customer-rec to lk-rec(1:size-para)
           when 78-read-prev
                read customer previous
                move customer-rec to lk-rec(1:size-para)
           when 78-write
                move lk-rec(1:size-para) to customer-rec
                write customer-rec
           when 78-rewrite
                move lk-rec(1:size-para) to customer-rec
                rewrite customer-rec
           when 78-delete
                move lk-rec(1:size-para) to cust-code
                delete customer record
           end-evaluate
           move cust-status to status-99
           goback status-99.

       VALORIZE-INITIAL-DATA.
           open output customer.
           move  1                                   to Cust-Code
           move "Veryant LLC"                        to Cust-First-Name
           move space                                to Cust-Last-Name
           move "6390 Greenwich Drive, Ste 225"      to Cust-Street
           move "San Diego"                          to Cust-City
           move "CA"                                 to Cust-State
           move "92122"                              to Cust-Zip
           move "M"                                  to Cust-Gender
           move "619-453-0945"                       to Cust-Phone 
           write Customer-Rec.

           add  1                                    to Cust-Code
           move "Mary"                               to Cust-First-Name
           move "Jones"                              to Cust-Last-Name 
           move "12 Main Street"                     to Cust-Street
           move "Los Angeles"                        to Cust-City
           move "CA"                                 to Cust-State
           move "92111"                              to Cust-Zip
           move "F"                                  to Cust-Gender
           move "123-234-3456"                       to Cust-Phone
           move "123-234-5432"                       to Cust-CellPhone
           write Customer-Rec.

           add  1                                    to Cust-Code
           move "Tom"                                to Cust-First-Name
           move "Johnson"                            to Cust-Last-Name
           move "100 Elm Street"                     to Cust-Street
           move "Hershey"                            to Cust-City
           move "PA"                                 to Cust-State
           move "12345"                              to Cust-Zip
           move "M"                                  to Cust-Gender
           move "515-626-7373"                       to Cust-Phone
           move "515-626-3737"                       to Cust-CellPhone
           write Customer-Rec.

           add  1                                    to Cust-Code
           move "Jose"                               to Cust-First-Name
           move "Garcia"                             to Cust-Last-Name
           move "Campos Eliseos No. 204"             to Cust-Street
           move "Polanco Chapultepe"                 to Cust-City
           move "MEX"                                to Cust-State
           move "11550"                              to Cust-Zip
           move "M"                                  to Cust-Gender
           move "011 52 55 5083"                     to Cust-Phone
           move "011 52 55 1234"                     to Cust-CellPhone
           write Customer-Rec.

           add  1                                    to Cust-Code
           move "Mario"                              to Cust-First-Name
           move "Rossi"                              to Cust-Last-Name
           move "Via Luigi Pirandello, 29"           to Cust-Street
           move "Piacenza"                           to Cust-City
           move "ITA"                                to Cust-State
           move "29121"                              to Cust-Zip
           move "M"                                  to Cust-Gender
           move "+39 0523 489919"                    to Cust-Phone
           move "+39 0523 489919"                    to Cust-CellPhone 
           write Customer-Rec.

           add  1                                    to Cust-Code
           move "Veryant Italia S.R.L."              to Cust-First-Name
           move space                                to Cust-Last-Name
           move "Via Luigi Pirandello, 29"           to Cust-Street
           move "Piacenza"                           to Cust-City
           move "ITA"                                to Cust-State
           move "29121"                              to Cust-Zip
           move "M"                                  to Cust-Gender
           move "+39 0523 489919"                    to Cust-Phone 
           write Customer-Rec.

           close customer.
