      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. State.

       WORKING-STORAGE SECTION.
       COPY "constants.def".
       COPY "state.wrk".
       77  key-status is special-names crt status pic 999.
       77  w-key                pic 9(5).
       77  sub-state            pic x(10).
       77  varx3                pic xxx.

       01                       pic 9.
           88 check-ok          value 0 false 1.
       77  err-message          pic x(60).

       SCREEN SECTION.
       01  s1.
           03 "State code:"           line 3 col 2.
           03 using state-code        col + 2 high prompt.
           03 "Name: "                line 4 col 2.
           03 using State-Description col + 2 high prompt.

       01  s-func.
           03 "F1=Lookup"             line 23 col 2 reverse.
           03 "F3=Del"                col + 2 reverse.
           03 "F5=First"              col + 2 reverse.
           03 "F6=Prev"               col + 2 reverse.
           03 "F7=Next"               col + 2 reverse.
           03 "F8=Last"               col + 2 reverse.
           03 "F9=Save"               col + 2 reverse.
           03 "ESC=Exit"              col + 2 reverse.

       PROCEDURE DIVISION.
       MAIN.
           call "PSTATE"    using 78-open-i-o

           display subwindow line 1 col 1 size 80 lines 25 erase screen
                   pop-up area sub-state

           display box title "STATE MAINTENANCE"
                   line 2 col 1 size 80 lines 20.
           display s1.
           display box line 22 col 1 size 80 lines 3.
           display s-func.

           perform until key-status = 27
              accept s1 
                 on exception 
                    continue 
              end-accept
              evaluate key-status
              when 1
                   perform LOOKUP
              when 2
                   continue
              when 3
                   perform REC-DELETE
              when 5
                   perform REC-FIRST
              when 6
                   perform REC-PREV
              when 7
                   perform REC-NEXT
              when 8
                   perform REC-LAST
              when 9
                   perform REC-SAVE
              end-evaluate
           end-perform.
           call "PSTATE"    using 78-close
           close window sub-state

           goback.
       
       REC-FIRST.
           move low-value to w-key(1:)
           call "PSTATE" using 78-start-great, w-key
           call "PSTATE" using 78-read-next, state-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              perform RESET-ERROR
              display S1
           end-if.

       REC-PREV.  
           call "PSTATE" using 78-read-prev, state-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              perform RESET-ERROR
              display S1
           end-if.

       REC-NEXT.  
           call "PSTATE" using 78-read-next, state-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              perform RESET-ERROR
              display S1
           end-if.

       REC-LAST.  
           move high-value to w-key
           call "PSTATE" using 78-start-less, w-key
           call "PSTATE" using 78-read-next, state-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              perform RESET-ERROR
              display S1
           end-if.

       REC-DELETE.
           display 
             "ARE YOU SURE YOU WANT TO DELETE THIS RECORD? (YES/NO)"  
             at 2501
           accept varx3 upper at 2577.
           display omitted erase eol line 25.
           
           if varx3 = "YES" or "Y"
              call "PSTATE" using 78-delete, state-code
              if return-code > 9
                 perform SHOW-FILE-ERROR
              else
                 perform RESET-ERROR
                 initialize State-Rec
                 display s1
              end-if
           end-if.

       REC-SAVE.
           perform CHECK-FIELDS.

           if check-ok
              call "PSTATE" using 78-write, state-rec
              if return-code = 22
                 call "PSTATE" using 78-rewrite, state-rec
                 if return-code > 9
                    perform SHOW-FILE-ERROR
                 end-if
              end-if
           end-if
           .

       CHECK-FIELDS.
           set check-ok   to true.

           if state-Code = space
              move "STATE CODE MANDATORY"   to err-message
              perform SHOW-ERROR
              move space  to State-Description
              set check-ok   to false
           end-if

           if check-ok and State-Description = space
              move "STATE DESCRIPTION MANDATORY"   to err-message
              perform SHOW-ERROR
              move space  to State-Description
              set check-ok   to false
           end-if
           
           if check-ok
              display omitted erase eol line 25
           end-if
           display s1
           .
       SHOW-ERROR.
           display omitted erase eol           line 25.
           display "Error: "                   at 2501
           display err-message                 at 2510
           .

       SHOW-FILE-ERROR.
           display omitted erase eol           line 25.
           display "Error: "                   at 2501
           if return-code = 10
              display "NO MORE RECORDS" high   at 2510
           else
              display return-code high         at 2510
           end-if
           display "Press Enter to continue"   at 2540
           accept omitted at 2578
              on exception
                 continue
           end-accept.
           display omitted erase eol line 25.

       RESET-ERROR.
           display omitted erase eol line 25.

       LOOKUP.
           call "LOOKUP-STATE" using state-rec
           display s1
           .

