      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       PROGRAM-ID. print-csv-data.
       CONFIGURATION SECTION.
       REPOSITORY.
           class JRXmlLoader
                   as "net.sf.jasperreports.engine.xml.JRXmlLoader"
           class CompileManager
                   as "net.sf.jasperreports.engine.JasperCompileManager"
           class JasperDesign
                   as "net.sf.jasperreports.engine.design.JasperDesign"
           class JasperReport
                   as "net.sf.jasperreports.engine.JasperReport"
           class JasperFillManager
                   as "net.sf.jasperreports.engine.JasperFillManager"
           class JasperPrint
                   as "net.sf.jasperreports.engine.JasperPrint"
           class JasperExportManager
                   as "net.sf.jasperreports.engine.JasperExportManager"
           class JasperPrintManager
                   as "net.sf.jasperreports.engine.JasperPrintManager"
           class JRCsvDataSource
                   as "net.sf.jasperreports.engine.data.JRCsvDataSource"
           class JRViewer
                   as "net.sf.jasperreports.view.JasperViewer"
           class jf
                   as "java.io.File"
           class vstring
                   as "java.lang.String[]"
           class HashMap
                   as "java.util.HashMap"
           class Map
                   as "java.util.Map"
           .

       working-storage section.
       77  myJasperDesign    object reference JasperDesign.
       77  myJasperReport    object reference JasperReport.
       77  myJasperPrint     object reference JasperPrint.
       77  myJRCsvDataSource object reference JRCsvDataSource.
       77  coloumnname       object reference vstring.
       77  parameters        object reference Map.
       77  report-name       pic x any length.
       77  csv-name          pic x any length.
       77  pdf-name          pic x any length.
       77  logo-name         pic x any length.
       77  wrk-date          pic 9(8).
       77  wrk-time          pic 9(8).

       linkage section.
           copy "PRINT-CSV.lnk".

       PROCEDURE DIVISION USING kind-of-print
                                string-parameters.
       MAIN.
           accept wrk-date from century-date
           accept wrk-time from time
           accept report-name from environment "report_source_path"
           string report-name  delimited by size
                               "reportCSV.jrxml" delimited by size
                  into report-name

           accept csv-name from environment "data_source_path"
           string csv-name      delimited by size
                  "product.csv" delimited by size
                  into csv-name

           accept pdf-name from environment "output_path"
           string pdf-name        delimited by size
                  "reportCSV_"    delimited by size
                  wrk-date        delimited by size
                  "_"             delimited by size
                  wrk-time        delimited by size
                  ".pdf"          delimited by size
                  into pdf-name

           accept logo-name from environment "resources_path"
           string logo-name          delimited by size
                  "VeryantLogo.gif"  delimited by size
                  into logo-name

           try
      *>   choose and compile the report
              set myJasperDesign 
                     to JRXmlLoader:>load (jf:>new(report-name)) 
                                                         as JasperDesign
              set myJasperReport 
                     to CompileManager:>compileReport(myJasperDesign) 
                                                         as JasperReport

      *>   set the name of the cvs file
              set myJRCsvDataSource 
                     to JRCsvDataSource:>new(jf:>new(csv-name))

      *>   set the structure of the csv file
              set coloumnname to vstring:>new(5)
              set coloumnname(0) to "Brand"
              set coloumnname(1) to "Code"
              set coloumnname(2) to "Name"
              set coloumnname(3) to "Description"
              set coloumnname(4) to "Price"

              myJRCsvDataSource:>setColumnNames(coloumnname)
              myJRCsvDataSource:>setUseFirstRowAsHeader(true)
              myJRCsvDataSource:>setFieldDelimiter ( ";" as char)

      *>   Set the parameters
              set parameters to HashMap:>new
              parameters:>put("param1" as string, 
                              string-parameters as string)
              parameters:>put("logo-path" as string, 
                              logo-name as string)

      *>   Fill the report
              set myJasperPrint  
                   to JasperFillManager:>fillReport(myJasperReport, 
                                                    parameters, 
                                                    myJRCsvDataSource) 
                                                 as JasperPrint   
 
              evaluate true
              when to-pdf
      *>   Create PDF from report
                   JasperExportManager:>exportReportToPdfFile
                                             (myJasperPrint, pdf-name);
              when to-printer
      *>   Print the report
                   JasperPrintManager:>printReport 
                                             (myJasperPrint, true);
              when to-preview
      *>   Preview the report
                   JRViewer:>viewReport(myJasperPrint);
              end-evaluate
 
              myJRCsvDataSource:>close
 
           catch exception
              exception-object:>printStackTrace
              stop run
           end-try

           if to-pdf
              call "C$EASYOPEN" using pdf-name
                                      1
           end-if
           goback
           .
