      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WSCALE.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  h-bitmap                pic s9(9) comp-4.
       77  h-bitmap-resize         pic s9(9) comp-4.
       77  flag-destroy            pic 9 value 0.
       77  v-local                 pic 9.
       77  bitmap-path             pic x(256).
       77  v-bmp1                  pic 9 value 1.
       77  wrk-cb-scale-mode       pic x any length.
       77  wrk-scale-mode          pic 9.

       78  cb-wscale-stretch       value "Stretch".
       78  cb-wscale-resize-xy     value "Resize X & Y".
       78  cb-wscale-resize-x      value "Resize X".
       78  cb-wscale-resize-y      value "Resize Y".
       78  cb-wscale-resize-none   value "None".

       77  wrk-cb-scale-align         pic x any length.
       77  wrk-scale-align            pic 9.
       78  cb-wscale-al-bottom-left   value "Bottom Left".
       78  cb-wscale-al-bottom-center value "Bottom Center".
       78  cb-wscale-al-bottom-right  value "Bottom Right".
       78  cb-wscale-al-middle-left   value "Middle Left".
       78  cb-wscale-al-middle-center value "Middle Center".
       78  cb-wscale-al-middle-right  value "Middle Rigth".
       78  cb-wscale-al-top-left      value "Top Left".
       78  cb-wscale-al-top-center    value "Top Center".
       78  cb-wscale-al-top-right     value "Top Rigth".

       SCREEN SECTION.
       01  Mask.
           03 Bmp1 
              bitmap
              line                 2
              col                  3
              lines                13 cells
              size                 66 cells
              visible              v-bmp1
              .
           03 Ef1  
              entry-field 
              line                 16 
              col                  2 
              size                 63 cells
              value                bitmap-path
              .
           03 Pb1  
              push-button
              line                 16
              col                  65
              size                 4 cells
              title                "..." 
              exception-value      101
              visible              v-local
              .
           03 label
              line              18
              col               2 
              size              10 cells
              title             "Scale Mode:"
              .
           03 cb-scale-mode
              combo-box
              drop-list
              unsorted
              line              18
              col               13
              size              15 cells
              value             wrk-cb-scale-mode
              .  
           03 label
              line              18
              col               38
              size              10 cells
              title             "Scale Align:"
              .
           03 cb-scale-align
              combo-box
              drop-list
              unsorted
              line              18
              col               49
              size              20 cells
              value             wrk-cb-scale-align
              .  
           03 Pb-image  
              push-button
              line                 20 
              col                  2 
              size                 12 cells
              title                "Load image" 
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       INI.
           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to v-local
           else
              move 1      to v-local
           end-if
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$SCALE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           move "files/img.png"             to bitmap-path
           move cb-wscale-stretch           to wrk-cb-scale-mode
           move cb-wscale-al-middle-center  to wrk-cb-scale-align
           display Mask

           modify cb-scale-mode item-to-add (cb-wscale-stretch,
                                             cb-wscale-resize-xy
                                             cb-wscale-resize-x
                                             cb-wscale-resize-y
                                             cb-wscale-resize-none).
           modify cb-scale-align item-to-add (cb-wscale-al-bottom-left
                                              cb-wscale-al-bottom-center
                                              cb-wscale-al-bottom-right
                                              cb-wscale-al-middle-left
                                              cb-wscale-al-middle-center
                                              cb-wscale-al-middle-right
                                              cb-wscale-al-top-left
                                              cb-wscale-al-top-center
                                              cb-wscale-al-top-right)

           perform SHOW-IMAGE

           perform  until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 101
                   perform CHOOSE-IMAGE
              when 102
                   perform SHOW-IMAGE
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-IMAGE.
           goback
           .

       CHOOSE-IMAGE.
           initialize opensave-data
           string "BMP Files (*.bmp)|*.bmp|"
                  "JPG Files (*.jpg)|*.jpg|"
                  "GIF Files (*.gif)|*.gif|"
                  "PNG Files (*.png)|*.png|"
                  "All images (*.bmp;*.jpg;*.gif;*.png)|"
                  "*.bmp;*.jpg;*.gif;*.png"
                  delimited by size
                  into opnsav-filters.

           move 5   to opnsav-default-filter

           call "C$OPENSAVEBOX" using opensave-open-box
                                      opensave-data
           if opnsav-basename not = spaces
              move opnsav-filename to bitmap-path
              modify Ef1 value bitmap-path
              perform SHOW-IMAGE
           end-if
           .

       SHOW-IMAGE.
           if flag-destroy = 0
              move 1 to flag-destroy
           else
              perform DESTROY-IMAGE
           end-if
           call "W$BITMAP" using wbitmap-load, bitmap-path
                           giving h-bitmap

           evaluate h-bitmap
           when -1
                move 0 to v-bmp1
                display message "W$BITMAP Error: "
                                "File not found or not readable"
                                icon mb-error-icon
           when -2
                move 0 to v-bmp1
                display message "W$BITMAP Error: "
                                "Out of memory loading the bitmap"
                                icon mb-error-icon
           when -3
                move 0 to v-bmp1
                display message "W$BITMAP Error: "
                                "Not a valid bitmap"
                                icon mb-error-icon
           when -4
                move 0 to v-bmp1
                display message "W$BITMAP Error: "
                                "Format not supported"
                                icon mb-error-icon
           when other
                move 1 to v-bmp1

                inquire cb-scale-mode value wrk-cb-scale-mode
                evaluate wrk-cb-scale-mode
                when cb-wscale-stretch
                     move wscale-stretch       to wrk-scale-mode
                when cb-wscale-resize-xy
                     move wscale-resize-xy     to wrk-scale-mode
                when cb-wscale-resize-x
                     move wscale-resize-x      to wrk-scale-mode
                when cb-wscale-resize-y
                     move wscale-resize-y      to wrk-scale-mode
                when cb-wscale-resize-none
                     move wscale-resize-none   to wrk-scale-mode
                end-evaluate

                inquire cb-scale-align value wrk-cb-scale-align
                evaluate wrk-cb-scale-align
                when cb-wscale-al-bottom-left  
                     move wscale-al-bottom-left   to wrk-scale-align
                when cb-wscale-al-bottom-center
                     move wscale-al-bottom-center to wrk-scale-align
                when cb-wscale-al-bottom-right 
                     move wscale-al-bottom-right  to wrk-scale-align
                when cb-wscale-al-middle-left  
                     move wscale-al-middle-left   to wrk-scale-align
                when cb-wscale-al-middle-center
                     move wscale-al-middle-center to wrk-scale-align
                when cb-wscale-al-middle-right 
                     move wscale-al-middle-right  to wrk-scale-align
                when cb-wscale-al-top-left
                     move wscale-al-top-left      to wrk-scale-align
                when cb-wscale-al-top-center
                     move wscale-al-top-center    to wrk-scale-align
                when cb-wscale-al-top-right    
                     move wscale-al-top-right     to wrk-scale-align
                end-evaluate

                call "w$scale" using h-bitmap 
                                     66 
                                     13
                                     hWin 
                                     wrk-scale-mode
                                     wrk-scale-align
                              giving h-bitmap-resize
                modify Bmp1 bitmap-handle h-bitmap-resize
           end-evaluate
           modify Bmp1 visible v-bmp1 
           .

       DESTROY-IMAGE.
           if function handle-type (h-bitmap) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy h-bitmap
           end-if
           if function handle-type (h-bitmap-resize) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy h-bitmap-resize
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
