      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. helpsample.

       WORKING-STORAGE SECTION.
       copy "iscoblib.def".   
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  path-help               pic x any length.
       77  path-copy-client-help   pic x any length.
       77  path-user-home          pic x any length.
       77  wstatus                 pic s9.

       01  file-info.
           02  file-size           pic x(8) comp-x.
           02  file-date           pic 9(8) comp-x.
           02  file-time           pic 9(8) comp-x.

       SCREEN SECTION.
       01  Mask.
           03 Pb-open
              push-button
              line                 4
              col                  2
              size                 15 cells
              title                "Open help"
              exception-value      101
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           accept terminal-abilities from terminal-info.
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "$WINHELP routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display mask

           perform LOAD-HELP

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 101
                   perform OPEN-HELP 
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       LOAD-HELP.
           if is-remote
              call client "C$GETENV" USING "user.home"
                                           path-user-home
              initialize path-help
              string path-user-home   delimited by trailing space
                     "/help.chm"      delimited by size
                    into path-help

              call client "C$FILEINFO" using path-help, 
                                             file-info
                                      giving wstatus

              evaluate wstatus
                       when 0
                            continue
                       when 1
                            initialize path-copy-client-help
                            string "@[DISPLAY]:"      delimited by size
                                   path-help  delimited by size
                            into path-copy-client-help
                            CALL "C$COPY" USING "files/help.chm" 
                                                path-copy-client-help
              end-evaluate
           else
              move "files/help.chm"   to path-help
           end-if.

       OPEN-HELP.
           if is-remote
              call client "$WINHELP" using path-help, help-contents
           else
              call "$WINHELP" using path-help , help-contents
           end-if.
