      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CSCR.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                       handle of window.
       77  fixed-font                 handle of font fixed-font.
       77  close-win                  pic 9 value 0.

       01  screen-position. 
           03 row-number              pic 99 comp-1. 
           03 column-number           pic 99 comp-1.
       77  character-buffer           pic x(128).
       77  status-code                pic s9.
       77  new-string                 pic x(30) value "My new string".
 
       77  string-length              PIC 99 comp-1.
       01  display-description        usage binary (2). 
           03 display-version         pic  9(4) value 0. 
           03 display-unit            pic  9(4) value 0. 
           03 display-line            pic  9(4). 
           03 display-position        pic  9(4). 
           03 display-length          pic  9(4). 
           03 display-exception-code  pic  9(4). 
           03 display-exception-value pic  9(4). 

       PROCEDURE DIVISION.
       MAIN.
           display window
                   line 2
                   title  "C$SCRD and C$SCWR Routines"
                   lines 24
                   size 80
                   font fixed-font
                   handle hWin 
                   event  WIN-EVT
                   .

           perform DRAW-MASK

           perform until crt-status = 27 or close-win = 1
              accept new-string at 1104 update
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 1
                   perform SHOW-RESULT
              when 27
                   exit perform
              end-evaluate
           end-perform

           destroy hWin
           goback
           .

       DRAW-MASK.
           display box lines 7 size 78      line 1 col 2

           display "String to read"         line 01 position 4.

           display "This line is the string to be read" 
                                            line 04 position 25.

           display box lines 4 size 78      line 9 col 2
           display "New String"             line 10 position 4.

           display box line 14 col 2        lines 5 size 78
           display "Writen strings"         line 14 position 4.

           display box lines 6 size 78      line 20 col 2

           display "F1  - Read the strings" line 21 position 4.
           display "ESC - exit"             line 23 position 4.
           .
           
       SHOW-RESULT.
           initialize character-buffer
                      string-length
                      status-code
           perform READ-SCR.

           move 16  to row-number 
           move 4   to column-number
           perform WRITE-SCR

           move 17  to row-number
           move new-string   to character-buffer
           perform WRITE-SCR
           .

       READ-SCR.
           move 4   to row-number 
           move 25  to column-number

           move 40 to string-length.
           call "C$SCRD" using character-buffer, 
                               string-length, 
                               row-number, 
                               column-number
           .

       WRITE-SCR.
           initialize display-description
           move row-number      to display-line
           move column-number   to display-position
           move 40              to display-length
           call "C$SCWR" using display-description, 
                               character-buffer
           if display-exception-code not = 0
              display message box "Unable to write the screen"
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
