      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. COPENSAVEBOX.

       WORKING-STORAGE SECTION. 
       COPY "isopensave.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.
       77  opensave-status         pic s9.
       77  env-code                pic 9.
       77  wrk-message             pic x any length. 
       77  hWin                    handle of window.

       SCREEN SECTION.
       01  mask.
           03 push-button 
              line                 4
              col                  16 
              size                 40 
              title                "OPENSAVE-BROWSE-FOLDER" 
              exception-value      1
              .
           03 push-button 
              line                 6
              col                  16 
              size                 40 
              title                "OPENSAVE-OPEN-BOX"
              exception-value      2
              .
           03 push-button 
              line                 8
              col                  16 
              size                 40 
              title                "OPENSAVE-SAVE-BOX"
              exception-value      3
              .
           03 push-button 
              line                 10
              col                  16 
              size                 40 
              title                "OPENSAVE-SAVE-BOX-CHECKED"
              exception-value      4
              .
           03 push-button 
              line                 12
              col                  16
              size                 40 
              title                "OPENSAVE-OPEN-BOX-MULTI"
              exception-value      6
              .
           03 push-button 
              line                 14
              col                  16
              size                 40 
              title                "OPENSAVE-BROWSE-FOLDER-MULTI" 
              exception-value      5
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.  

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$OPENSAVEBOX Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           CALL "C$OPENSAVEBOX" USING OPENSAVE-SUPPORTED
                               GIVING opensave-status

           if opensave-status = -1
              display message 
              "This system doesn't support the C$OPENSAVEBOX"
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 1 
                   perform COP-BROWSE-FOLDER
              when 2 
                   perform COP-OPEN-BOX
              when 3 
                   perform COP-SAVE-BOX
              when 4 
                   perform COP-SAVE-BOX-CHECKED
              when 5 
                   perform COP-BROWSE-FOLDER-MULTI
              when 6 
                   perform COP-OPEN-BOX-MULTI
              end-evaluate
              move 4   to accept-control
           end-perform 

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       COP-BROWSE-FOLDER.
           initialize opensave-data
           move "Choose a folder" to opnsav-title

           call "C$OPENSAVEBOX" using opensave-browse-folder, 
                                      opensave-data
                               giving opensave-status

           if opensave-status > 0
              display message "chosen folder: " opnsav-filename 
                      title   "Call: C$OPENSAVEBOX"
                      icon    1
           else
              display message "Operation Cancelled"
                      title   "Call: C$OPENSAVEBOX"
                      icon    3
           end-if
           .

       cop-open-box.
           initialize opensave-data
           move "Choose a file" to opnsav-title
           move "isCOBOL source files (*.cbl)|*.cbl|All files (*.*)|*.*"
                                to opnsav-filters

           call "C$OPENSAVEBOX" using opensave-open-box, 
                                      opensave-data
                               giving opensave-status

           if opensave-status > 0
              display message "chosen file: " opnsav-filename 
                      title   "Call: C$OPENSAVEBOX"
                      icon    1
           else
              display message "Operation Cancelled"
                      title   "Call: C$OPENSAVEBOX"
                      icon    3
           end-if
           .

       cop-save-box.
           initialize opensave-data
           move "Save to file" to opnsav-title
           move "isCOBOL source files (*.cbl)|*.cbl|All files (*.*)|*.*"
                                to opnsav-filters

           call "C$OPENSAVEBOX" using opensave-save-box, 
                                      opensave-data
                               giving opensave-status

           if opensave-status > 0
              display message "chosen file to save: " opnsav-filename 
                      title   "Call: C$OPENSAVEBOX"
                      icon    1
           else
              display message "Operation Cancelled"
                      title   "Call: C$OPENSAVEBOX"
                      icon    3
           end-if
           .

       cop-save-box-checked.
           initialize opensave-data
           move "isCOBOL source files (*.cbl)|*.cbl|All files (*.*)|*.*"
                                to opnsav-filters

           call "C$OPENSAVEBOX" using opensave-save-box-checked
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              display message "chosen file to save: " opnsav-filename 
                      title   "Call: C$OPENSAVEBOX"
                      icon    1
           else
              display message "Operation Cancelled"
                      title   "Call: C$OPENSAVEBOX"
                      icon    3
           end-if
           .

       cop-browse-folder-multi.
           initialize opensave-data
           move "Choose some folders" to opnsav-title

           call "C$OPENSAVEBOX" using opensave-browse-folder-multi, 
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              initialize wrk-message
              string "first chosen folder: " delimited by size
                      opnsav-filename        delimited by trailing space
                      into wrk-message
              perform until 1 = 2
                 call "C$OPENSAVEBOX" using opensave-next, 
                                            opensave-data
                                     giving opensave-status
                 if opensave-status > 0
                    string wrk-message   delimited by size
                          x"0D0A"        delimited by size
                          "next chosen folder: "  delimited by size
                          opnsav-filename   delimited by trailing space
                      into wrk-message
                 else
                    exit perform 
                 end-if
              end-perform
              display message wrk-message 
                      title   "Call: C$OPENSAVEBOX"
                      icon    1
           else
               display message "Operation Cancelled"
                       title   "Call: C$OPENSAVEBOX"
                       icon    3
           end-if
           .

       cop-open-box-multi.
           initialize opensave-data
           move "Choose some files" to opnsav-title
           move "isCOBOL source files (*.cbl)|*.cbl|All files (*.*)|*.*"
                                to opnsav-filters

           call "C$OPENSAVEBOX" using opensave-open-box-multi, 
                                      opensave-data
                               giving opensave-status

           if opensave-status > 0
              initialize wrk-message
              string "first chosen file: "  delimited by size
                      opnsav-filename       delimited by trailing space
                      into wrk-message

              perform until 1 = 2
                 call "C$OPENSAVEBOX" using opensave-next, 
                                            opensave-data
                                     giving opensave-status
                 if opensave-status > 0
                    string wrk-message         delimited by size
                          x"0D0A"              delimited by size
                          "next chosen file: " delimited by size
                          opnsav-filename   delimited by trailing space
                      into wrk-message
                 else
                    exit perform 
                 end-if
              end-perform
              display message wrk-message 
                      title   "Call: C$OPENSAVEBOX"
                      icon    1
           else
              display message "Operation Cancelled"
                      title   "Call: C$OPENSAVEBOX"
                      icon    3
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
