      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CHANGEDIR.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select FILE1 assign to "-F changedir.txt"
           organization line sequential
           status file-status
           .

       FILE SECTION.
       FD  FILE1.
       01  file1-rec   pic x(50).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  wstatus                 pic 9(9) comp-4.
       77  current-dir-name        pic x any length.
       77  new-dir-name            pic x any length.
       77  original-dir-name       pic x any length.

       77  file-status             pic xx.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                03
              col                 03
              title               "Current working directory:" 
              .
           03 ef-current-dir
              entry-field
              size                50 cells
              line                05
              col                 03 
              value               current-dir-name
              read-only
              .
           03 label
              line                07
              col                 03
              title               "New working directory:" 
              .
           03 ef-new-dir
              entry-field
              size                50 cells
              line                9
              col                 03
              value               new-dir-name
              .
           03 push-button  
              line                11
              col                 3
              title               "&Change Directory" 
              exception-value     13
              size                15
              self-act
              .
           03 Pb-exit  
              push-button
              line                20
              col                 62
              size                8 cells
              title               "Exit" 
              exception-value     27
              .

       PROCEDURE DIVISION.
       MAIN.

      *    retrive the actualy directory by C$CHDIR
           call "C$CHDIR" using original-dir-name

           move original-dir-name to current-dir-name
           call "C$GETENV" using "user.home"
                                 new-dir-name

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$CHDIR Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 13
                   perform CHANGE-DIR
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font

      *    set the working directory by C$CHDIR
           call "C$CHDIR" using original-dir-name

           goback
           .

       CHANGE-DIR.

      *    change dir by C$CHDIR
           inquire ef-new-dir value new-dir-name
           call "C$CHDIR" using new-dir-name
                         giving wstatus
           evaluate wstatus
           when 0
                open output file1
                write file1-rec from "This file was written after changi
      -                              "ng the directory with C$CHDIR"
                close file1

                display message "Current working directory: " 
                                new-dir-name
                                x"0A" "Check the file changedir.txt "
                                "in the new working directory."
                        title   "Working Directory"   
                move new-dir-name  to current-dir-name
                modify ef-current-dir value current-dir-name
           when other
                display message "C$CHDIR failed" 
                        title   "Working Directory"
           end-evaluate.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
