      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CGETLASTFILE.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select tmp-file assign to path-file
           organization line sequential
           file status tmp-file-status.

       FILE SECTION.
       fd tmp-file.
           01 tmp-rec pic x(60).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  wrkdir                  pic x(256).

       77  tmp-file-status         pic x(2).
       77  fileOp                  pic x(20).
       77  fileName                pic x(100).

       77  msg-declarative         pic x(150).

       SCREEN SECTION.
       01  Mask.
           03  push-button
               line                3 
               col                 2
               size                10 cells
               title               "Open File" 
               exception-value     101
               .
           03  push-button
               line                5 
               col                 2
               size                10 cells
               title               "Close File" 
               exception-value     102
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.

       DECLARATIVES.
       TMP-FILE-ERR section.
           use after standard error procedure on tmp-file.
           call "C$GETLASTFILEOP"     USING fileOp
           call "C$GETLASTFILENAME"   USING fileName

           initialize msg-declarative
           string "File status: " delimited by size
                  tmp-file-status delimited by trailing space
                  x"0D0A"         delimited by size
                  "File name retrived by C$GETLASTFILENAME: " 
                                  delimited by size
                  fileName        delimited by trailing space
                  x"0D0A"         delimited by size
                  "File operation retrived by C$GETLASTFILEOP: "
                                  delimited by size
                  fileOp          delimited by trailing space
                  low-value       delimited by size
                  into msg-declarative
           display message box msg-declarative

       END DECLARATIVES.


       INI.   
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  
                       "C$GETLASTFILEOP and C$GETLASTFILENAME Routines"
                   control font control-font
                   lines 21
                   min-lines 21
                   size 70
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           move "C:\PATH-DONT-EXIST\tmp-file"   to path-file

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept 
              evaluate crt-status
              when 101
                   open output tmp-file
              when 102
                   close tmp-file
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
