      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CCREATETMPFILE.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select tmp-file assign to dest-file
           organization line sequential.

       FILE SECTION.
       fd tmp-file.
           01 tmp-rec pic x(60).

       WORKING-STORAGE SECTION.
       copy "isopensave.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  opensave-status         pic s9.
       77  fi-prefix               pic x(10).
       77  fi-suffix               pic x(10).
       77  fi-path                 pic x(256).
       77  dest-file               pic x(256).
       77  wstatus                 pic s9.
       77  risp                    pic 9.
       
       SCREEN SECTION.
       01  Mask.
           03 label               
              line                 2 
              col                  2
              size                 10 cells
              title                "File prefix:"
              .
           03 f-prefix
              entry-field
              line                 2 
              col                  + 2
              value                fi-prefix
              size                 10 cells
              max-text             10
              boxed
              .
           03 label               
              line                 4 
              col                  2
              size                 10 cells
              title                "File suffix:"
              .
           03 f-suffix
              entry-field
              line                 4 
              col                  + 2
              value                fi-suffix
              size                 10 cells
              max-text             10
              boxed
              .
           03 label               
              line                 6 
              col                  2
              size                 10 cells
              title                "Path:"
              .
           03 f-path
              entry-field
              line                 6 
              col                  + 2
              value                fi-path
              size                 52 cells
              max-text             256
              boxed
              .
           03 push-button
              line                 6
              col                  + 2
              title                "..."
              size                 4 cells
              exception-value      101
              self-act
              .
           03 push-button
              line                 8 
              col                  13
              title                "Create &File"
              size                 15 cells
              exception-value      102
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN. 
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$CREATE_TMP_FILE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                initialize opensave-data
                call "C$OPENSAVEBOX" using opensave-browse-folder
                                           opensave-data
                                     giving opensave-status
                if opensave-status > 0
                   modify f-path value opnsav-filename
                end-if
           when 102
                call "c$create_tmp_file" using dest-file 
                                               fi-prefix 
                                               fi-suffix
                                               fi-path
                                         giving wstatus
                evaluate wstatus
                when 0
                     display message "Created file: " dest-file
                     open output tmp-file
                     write tmp-rec 
                          from "File created by C$CREATE_TMP_FILE"
                     close tmp-file
                when 1
                     display message "The file couldn�t be created"
                when 2
                     display message "fileName is missing or it is not "
                     "big enough to store the full path-name, "
                     "the file is removed"
                end-evaluate
           end-evaluate
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .