      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CCOVPROF.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  isrun-command           pic x any length.
       77  wrk-command-option      pic x any length.

       77  java-class-path         pic x any length.
       77  java-home               pic x any length.
       77  java-name               pic x any length.
       77  file-separator          pic x any length.

       77  kind-of-execution       pic 9 value 1.
           88 profile              value 1.
           88 coverage             value 2.

       SCREEN SECTION.
       01  Mask.
           03 label 
              line                 3
              lines                2
              col                  3
              size                 65
              title                "The profiling feature is enabled "
                                 & "only if the program is started "
                                 & "with the -profile option or with "
                                 & "the -J-javaagent:isprofiler.jar"
              .
           03 label 
              line                 6
              lines                2
              col                  3
              size                 65
              title                "The code coverage feature is "
                                 & "enabled only if the program is "
                                 & "started with the -coverage option "
                                 & "or with the -J-javaagent:isprofiler"
                                 & ".jar=coverage"
              .
           03 label 
              line                 10
              lines                2
              col                  3
              title                "Enable"
              .
           03 radio-button 
              line                 10 
              col                  12
              title                "Profile"
              group                1
              group-value          1 
              value                kind-of-execution
              . 
           03 radio-button 
              line                 10 
              col                  25
              title                "Coverage"
              group                1
              group-value          2 
              value                kind-of-execution
              . 
           03 push-button
              line                 13
              col                  20
              size                 30
              title                "&Run program"
              exception-value      102
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$COVERAGE and C$PROFILER Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           accept terminal-abilities from terminal-info
           if is-remote
              display message "This sample shows the usage of "
                              "'Isrun -profile option',"
                              " so it's not available in the execution "
                              "under Application Server environment."
                              x"0D0A"
                              "To use the Profiler in "
                              "Application Server environment use the "
                              "'-javaagent' option, "
                              "see details on documentation"
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              if crt-status = 102
                 perform CREATE-RUNTIME-COMMAND
                 call "C$SYSTEM" using isrun-command
                                giving return-code
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CREATE-RUNTIME-COMMAND.
           accept system-information from system-info.

           call "C$GETENV" using "java.class.path"
                                 java-class-path

           if os-is-win-family
              move "javaw" to java-name
              string '"'  delimited by size
                     java-class-path delimited by size
                     '"'  delimited by size
                     into java-class-path 
           else
              move "java" to java-name
           end-if

           call "C$GETENV" using "java.home"
                                  java-home

           call "C$GETENV" using "file.separator"
                                  file-separator

           evaluate true
           when profile
                move "-profile" to wrk-command-option
           when coverage
                move "-coverage" to wrk-command-option
           end-evaluate

           initialize isrun-command
           string java-home                    delimited by size
                  file-separator               delimited by size
                  "bin"                        delimited by size
                  file-separator               delimited by size
                  java-name                    delimited by size
                  " -cp "                      delimited by size
                  java-class-path              delimited by size
                  " com.iscobol.invoke.Isrun " delimited by size
                  wrk-command-option           delimited by size
                  " "                          delimited by size
                  "CCOVPROF-ELABORATION"       delimited by size
                  " "                          delimited by size
                  kind-of-execution            delimited by size
                  into isrun-command
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .