      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CCARG-MAIN.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    usage handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  w-para-1                pic x(30) value "abc".
       77  w-para-2                pic 9(5)V99 value 123.
       77  num1                    pic 99.

       77  e-param-1               pic 9 value 1.
       77  e-param-2               pic 9 value 1.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       SCREEN SECTION.
       01  Mask.
           03 cb-param1
              Check-box
              col                  2 
              line                 2
              size                 22 
              title                "Alphanumeric parameter"
              value                e-param-1
              exception-value      102
              .
           03 ef-param1
              entry-field
              line                 2 
              col                  + 2
              size                 15
              value                w-para-1
              enabled              e-param-1
              id                   100
              .
           03 cb-param2
              Check-box
              col                  2 
              line                 4
              size                 22
              title                "Numeric parameter"
              value                e-param-2
              exception-value      103
              .
           03 ef-param2
              entry-field
              line                 4
              col                  + 2
              size                 15 
              numeric
              max-text             5
              right
              value                w-para-2
              enabled              e-param-2
              .
           03 label
              line                6
              col                 2
              lines               3  cells
              size                60 cells
              title               "Click the button below to call a prog
      -                           "ram passing the checked parameters. T
      -                           "he called program will display inform
      -                           "ation about the received parameters."
              .
           03 push-button
              title                "&Call Program"
              line                 11
              col                  2
              size                 15 
              exception-value      200
              .
           03 push-button
              line                 20 
              col                  2 
              size                 20 cells
              title                "COBOL source code" 
              exception-value      101
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       main.
           accept base-sorg-path from environment "home_source".

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  resizable layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$CARG Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask
           move 100 to control-id
           move 4   to accept-control

           perform until crt-status = 27  or close-win = 1
              accept mask
                 on exception 
                    continue
              end-accept
              evaluate crt-status
              when 101 
                   perform VIEW-SOURCE
              when 102
                   inquire cb-param1 value e-param-1 
                   modify ef-param1 enabled e-param-1
              when 103
                   inquire cb-param2 value e-param-2 
                   modify ef-param2 enabled e-param-2
              when 200
                   initialize num1  
                   inspect w-para-1 tallying num1
                           for characters before initial trailing space
                   if num1 = zero
                      move 1 to num1
                   end-if
                   evaluate true
                   when e-param-1 = 0 and e-param-2 = 0
                        call "CCARG-CALLED"
                   when e-param-1 = 1 and e-param-2 = 0
                        call "CCARG-CALLED" using w-para-1(1:num1)
                   when e-param-1 = 0 and e-param-2 = 1  
                        call "CCARG-CALLED" using w-para-2
                   when e-param-1 = 1 and e-param-2 = 1
                        call "CCARG-CALLED" using w-para-1(1:num1)
                                                  w-para-2
                   end-evaluate
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
           
       VIEW-SOURCE.
           initialize command
           string base-sorg-path      delimited by trailing space
                  "s-routines"        delimited by space
                  "/CCARG-CALLED.cbl" delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
           