      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLSCRCHARS.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  fixed-font              handle of font fixed-font.
       77  close-win               pic 9 value 0.

       01  screen-position. 
           03 row-number           pic x comp-x. 
           03 column-number        pic x comp-x.
       77  screen-depth            pic x comp-x. 
       77  screen-width            pic x comp-x.
       77  character-buffer        pic x(128).
       77  string-length           pic xx comp-x.
       77  status-code             pic s9.
       77  new-string              pic x(30) value "My new string".
 
       77  Vrows  pic 99.
       77  Vcols  pic 99.

       77  wcharacter              pic x comp-x.
       77  wattribute              pic x comp-x.

       PROCEDURE DIVISION.
       MAIN.
           display window
                   line 2
                   title  "CBL_CLEAR_SCR, CBL_GET_SCR_SIZE, CBL_READ_SCR
      -                   "_CHARS, CBL_WRITE_SCR_CHARS, CBL_WRITE_SCR_N_
      -                   "CHAR Routines"
                   lines 24
                   size 80
                   font fixed-font
                   handle hWin 
                   event  WIN-EVT
                   .

           perform DRAW-MASK

           perform until crt-status = 27 or close-win = 1
              accept new-string at 1104 update
                    on exception 
                       continue 
              end-accept
              evaluate crt-status
              when 1
                   perform SHOW-RESULT
              when 2
                   perform READ-SIZE
              when 3
                   perform CLEAR-SCREEN
                   move 27   to crt-status
              when 27
                   exit perform
              end-evaluate
           end-perform

           destroy hWin
           goback
           .

       DRAW-MASK.
           display box line 1 col 2 lines 7 size 78

           display "String to read"      line 01 position 4.

           display "This line is the string to be read" 
                                         line 04 position 25.

           display box line 9 col 2 lines 4 size 78
           display "New String"      line 10 position 4.

           display box line 14 col 2 lines 5 size 78
           display "Writen strings" line 14 position 4.

           display box line 20 col 2 lines 6 size 78

           display "F1  - Read the strings" 
                                         line 21 position 4.
           display "F2  - Read the size of the screen"    
                                         line 21 position 40.
           display "F3  - Clear the screen and fill with *" 
                                         line 22 position 4.
           display "ESC - exit" 
                                         line 23 position 4.
           .

       SHOW-RESULT.
           initialize character-buffer
                      string-length
                      status-code

           perform READ-SCR.

           move 15  to row-number, 
           move 3   to column-number

           perform WRITE-SCR
           move 16  to row-number
           move new-string   to character-buffer
           perform WRITE-SCR
           .

       READ-SIZE.
           call "CBL_GET_SCR_SIZE" using screen-depth, 
                                         screen-width 
                               returning status-code.
           move screen-depth to VrowS
           move screen-width to Vcols.

           display "Screen size    x" line 23 position 40.
           display Vrows line 23 position 52.
           display Vcols line 23 position 57.

       READ-SCR.
           move 3   to row-number 
           move 24  to column-number

           move 40 to string-length.
           call "CBL_READ_SCR_CHARS"  
                 using screen-position, 
                       character-buffer, 
                       string-length  
             returning status-code

           if status-code = 0
              display message box "Unable to read from the screen"
           end-if
           .

       WRITE-SCR.
           display space line row-number + 1 size 60 col 5.

           move 50 to string-length.
           call "CBL_WRITE_SCR_CHARS"  
                 using screen-position, 
                       character-buffer, 
                       string-length  
             returning status-code
           if status-code = 0
              display message box "Unable to write to the screen"
           end-if
           .

       CLEAR-SCREEN.
           move 0 to wcharacter.
           call "CBL_CLEAR_SCR" using wcharacter, wattribute.

           move 0      to row-number, 
           move 0      to column-number
           move 1840   to string-length.
           move 42     to wcharacter
           call "CBL_WRITE_SCR_N_CHAR"  
                 using screen-position, 
                       wcharacter, 
                       string-length  
             returning status-code
           if status-code = 0
              display message box "Unable to fill the screen"
           end-if.

           display "Press enter to exit" line 24 position 4.
           accept omitted.


       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .