      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    ASYNC.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  hThread                 handle.
       77  t-status                pic 9.

       SCREEN SECTION.
       01  Mask.
           03 pb-call
              push-button
              line                 3
              col                  3
              size                 15 cells
              title                "Create Thread"
              exception-value      101
              .
           03 pb-check
              push-button
              line                 5
              col                  3
              size                 15 cells
              title                "Check Thread"
              exception-value      102
              .
           03 Pb-exit
              push-button
              line                 20
              col                  62
              size                 8 cells
              title                "Exit"
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.   
           move 0 to hThread

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$ASYNCRUN and C$ASYNCPOLL Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    evaluate crt-status
                    when 27
                         call "C$ASYNCPOLL" using hThread, t-status
                         if t-status = zero
                            display message 
                                       "Stop the Thread before exit"
                                    icon mb-warning-icon
                            move zero  to crt-status
                         end-if
                    when 101
                         call "C$ASYNCRUN" using hThread, "THE_THREAD"
                         modify pb-call enabled 0
                    when 102
                         call "C$ASYNCPOLL" using hThread, t-status
                         if t-status = 1
                            display message "Thread does not exist"
                                    icon mb-warning-icon
                            modify pb-call enabled 1
                         else
                            display message "Thread is running"
                                    icon mb-default-icon
                         end-if
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win 
           end-if
           .