      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. helpprg is initial.

       WORKING-STORAGE SECTION. 
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".
       77  help-message      pic x any length.
       77  help-part-1       pic x any length.
       77  help-part-2       pic x any length.

       77  h-notif           handle of window.
       77  control-font      handle of font.
       77                    pic 9.
           88 show-help      value 1 false 0.

       77  notif-bmp-handle  pic s9(9) comp-4.
       77  hint-row          pic 9(6)v99.
       77  hint-col          pic 9(6)v99.

       LINKAGE SECTION.
       01  event-data.
           03  event-type            pic x(4) comp-x.
           03  event-window-handle   handle of window.
           03  event-control-handle  handle.
           03  event-control-id      pic xx comp-x.
           03  event-data-1          signed-short.
           03  event-data-2          signed-long.
           03  event-action          pic x comp-x.

       SCREEN SECTION.
       01  mask-notification.
           03 Bitmap
              line              2.0
              column            2.2
              size              32 pixels 
              lines             32 pixels 
              bitmap-handle     notif-bmp-handle
              bitmap-number     1
              .
           03 Label
              line              1.8
              column            7.2
              size              35 
              foreground-color  rgb x#CFCFCF
              title             "<HTML><b>Mouseover hook</b></HTML>"
              transparent
              .
           03 Label
              line              2.8
              lines             2
              column            7.2
              size              50 
              foreground-color  rgb x#939392
              title             help-message
              transparent
              .

       PROCEDURE DIVISION using event-data.
       MAIN.
           set show-help  to true
           evaluate event-data-2
           when 1
                move "Title"                to help-part-1
                move "Song title"           to help-part-2
           when 2
                move "Length"               to help-part-1
                move "Song length"          to help-part-2
           when 3
                move "Artist"               to help-part-1
                move "Artist or Group name" to help-part-2
           when 4
                move "Genre"                to help-part-1
                move "Song genre"           to help-part-2
           when 5
                move "Label"                to help-part-1
                move "Song label"           to help-part-2
           when 6
                move "Year"                 to help-part-1
                move "Song year"            to help-part-2
           when 7
                move "Comments"             to help-part-1
                move "Type your comments"   to help-part-2
           when other
                set show-help   to false
           end-evaluate

           if show-help
              perform SHOW-HELP-ROUTINE
           end-if
           goback.

       SHOW-HELP-ROUTINE.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           perform FORMAT-HTML.
           perform DISPLAY-HINT.
           perform DISPLAY-NOTIFICATION.

       DISPLAY-HINT.
           perform CALCULATE-HELP-POSITION
           call "w$hint" using help-message
                               hint-col 
                               hint-row
                               6000
           .

       DISPLAY-NOTIFICATION.

           call "W$BITMAP" using wbitmap-load 
                                 "files/cursor.png"
                       returning notif-bmp-handle

           display notification window
                   bottom right 
                   lines 5
                   size 31
                   control font control-font
                   before time 300
                   visible 0
                   background-color rgb x#343332
                   handle h-notif.

           display mask-notification
                   upon h-notif.
           modify h-notif visible 1.

       CALCULATE-HELP-POSITION.
           evaluate event-type
           when cmd-help
                inquire event-control-handle line hint-row
                                             col hint-col
           when cmd-help-mouse
                call "W$MOUSE" using get-mouse-status 
                                     mouse-info
                move mouse-col-ex  to hint-col
                move mouse-row-ex  to hint-row
           end-evaluate
           add 1  to hint-row
                     hint-col
           .

       FORMAT-HTML.
           initialize help-message
           string "<HTML><b>"   delimited by size
                  help-part-1   delimited by size
                  "</b><br><i>" delimited by size
                  help-part-2   delimited by size
                  "</i></HTML>" delimited by size
                  into help-message 
           .

