      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. status-bar.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.    
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  hSt                     handle of status-bar.

       SCREEN SECTION.
       01  Mask
           before                  DESC-FIELD
           .
           03 label
              line                 2
              col                  2
              size                 8 cells
              title                "Title:"
              .       
           03 Ef1 
              entry-field    
              line                 2
              col                  12
              size                 54 cells
              id                   1 
              .    
           03 label
              line                 4 
              col                  2
              size                 8 cells
              title                "Length:"
              .         
           03 Ef2                  
              entry-field    
              line                 4
              col                  12
              size                 54 cells
              id                   2   
              .       
           03 label
              line                 6
              col                  2
              size                 8 cells
              title                "Artist:"
              .                      
           03 Ef3
              entry-field    
              line                 6
              col                  12
              size                 54 cells
              id                   3
              .
           03 label
              line                 8
              col                  2
              size                 8 cells
              title                "Genre:"
              .                      
           03 Ef4
              entry-field    
              line                 8
              col                  12
              size                 54 cells
              id                   4
              .
           03 label
              line                 10
              col                  2
              size                 8 cells
              title                "Label:"
              .
           03 Ef5
              entry-field    
              line                 10
              col                  12
              size                 54 cells
              id                   5     
              .
           03 label
              line                 12
              col                  2
              size                 8 cells
              title                "Year:"
              .                      
           03 Ef6
              entry-field    
              line                 12
              col                  12
              size                 54 cells
              id                   6     
              .
           03 Pb-exit  
              push-button
              line                 18 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.       
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "STATUS-BAR Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask 

           display status-bar panel-widths (10, 40, -1)
                              panel-style  (panel-flat, 
                                            panel-lowered, 
                                            panel-lowered) 
                              panel-text ("Status-bar", 
                                          " ",
                                          "Double click here")
                              grip
                              event EV-STATUS
                              handle hSt

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform
          
           destroy Mask
           destroy hSt
           destroy hWin
           destroy control-font
           goback
           .

       DESC-FIELD.
           evaluate control-id
           when 1
                modify hSt panel-index 2
                           panel-text "Input the title of the song"
           when 2
                modify hSt panel-index 2
                           panel-text "Input the length of the song"
           when 3
                modify hSt panel-index 2
                           panel-text "Input the name of the Artist"
           when 4
                modify hSt panel-index 2
                           panel-text "Input the genre of the Album"
           when 5
                modify hSt panel-index 2
                           panel-text "Input the label of the Album"
           when 6     
                modify hSt panel-index 2
                           panel-text "Input the year of the Album"
           when other 
                modify hSt panel-index 2
                           panel-text spaces
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       EV-STATUS.
           evaluate event-type
           when msg-st-dblclick
                if event-data-1 = 3
                   display message "msg-st-dblclick event on status bar"
                end-if
           end-evaluate
           .
