      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. radio-button.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.
       
       77  hBmpRB                  pic s9(9) comp-4.
       77  var                     pic 9.
       77  var1                    pic 9.
       77  var2                    pic 9.
       77  var-alpha               pic x(10).
       77  wrk-message             pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                 2 
              col                  2
              lines                11 cells 
              size                 21 cells
              title                "options"
              .
           03 Rb1 
              radio-button
              line                 5 
              col                  3
              title                "option 1"
              group                1
              group-value          1
              value                var
              . 
           03 Rb2 
              radio-button
              line                 7 
              col                  3
              title                "option 2"
              group                1 
              group-value          2
              value                var
              .
           03 Rb3 
              radio-button
              line                 9 
              col                  3
              title                "option 3"
              group                1 
              group-value          3
              value                var
              .
           03 frame 
              engraved
              line                 2 
              col                  25
              lines                11 cells
              size                 21 cells
              title                "Alphanumeric options"
              .
           03 RbA1 
              radio-button 
              line                 5 
              col                  26
              title                "Red"
              group                2
              group-value          "red" 
              value                var-alpha
              .
           03 rbA2 
              radio-button 
              line                 7 
              col                  26
              title                "Blue"  
              group                2
              group-value          "Blue" 
              value                var-alpha
              size                 15
              . 
           03 RbA3 
              radio-button 
              line                 9 
              col                  26
              title                "Green" 
              group                2
              group-value          "Green"
              value                var-alpha
              . 
           03 frame
              engraved
              line                 2 
              col                  49
              lines                11 cells 
              size                 21 cells
              title                "Optional"
              .
           03 RbL1 
              radio-button 
              line                 5 
              col                  52
              title                "Optional 1"
              group                3
              group-value          1 
              value                var1
              left-text
              exception-value      101
              .
           03 rbL2 
              radio-button 
              line                 7 
              col                  52
              title                "Optional 2"  
              group                3
              group-value          2 
              value                var1
              left-text
              exception-value      101
              . 
           03 RbL3 
              radio-button 
              line                 9 
              col                  52
              title                "Optional 3" 
              group                3
              group-value          3
              value                var1
              left-text
              exception-value      101
              . 
           03 lb-optional
              label
              line                 11
              col                  52
              .
           03 frame 
              engraved
              line                 14
              col                  25
              lines                7 cells
              size                 21 cells
              title                "graphical options"
              .         
           03 RbA 
              radio-button
              line                 16
              col                  26
              lines                19 
              size                 19
              bitmap 
              bitmap-width         19
              bitmap-handle        hBmpRB
              bitmap-number        1
              bitmap-pressed       2
              bitmap-rollover      3
              bitmap-rollover-selected 4
              bitmap-selected      5
              bitmap-scale         2
              title                "bitmap only"
              group                4 
              group-value          1
              value                var2
              . 
           03 RbB 
              radio-button 
              flat
              line                 18
              col                  26
              lines                2 cells
              size                 20 cells
              bitmap 
              bitmap-width         19
              bitmap-handle        hBmpRB
              bitmap-number        1
              bitmap-pressed       2
              bitmap-rollover      3
              bitmap-rollover-selected 4
              bitmap-selected      5
              bitmap-scale         2
              title                "bitmap and text"
              title-position       2
              group                4
              group-value          2 
              transparent
              value var2
              .
           03 Pb1 
              push-button
              line                 14 
              col                  2      
              size                 15 cells
              title                "&Confirm"
              exception-value      100
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "W$BITMAP" using wbitmap-load, "files/roll.gif"
                          giving hBmpRB

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "RADIO-BUTTON Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    evaluate crt-status
                    when 100
                         perform CHECK-CHOICE
                    when 101
                         perform VIEW-OPTIONAL
                    end-evaluate
              end-accept
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, hBmpRB
           goback
           .

       CHECK-CHOICE.
           initialize wrk-message
           string "You've chosen option "   delimited by size
                  var                       delimited by size
                  x"0D0A"                   delimited by size
                  "You've chosen "          delimited by size
                  var-alpha                 delimited by size
                  x"0D0A"                   delimited by size
                  "You've chosen optional " delimited by size
                  var1                      delimited by size
                  into wrk-message

           evaluate var2
           when 1
                string wrk-message          delimited by size
                       x"0D0A"              delimited by size
                       "You've checked the graphical button"
                                            delimited by size
                       into wrk-message 
           when 2 
                string wrk-message          delimited by size
                       x"0D0A"              delimited by size
                       "You've checked the graphical button with text"
                                            delimited by size
                       into wrk-message 
           end-evaluate

           display message wrk-message
           .

       VIEW-OPTIONAL.
           evaluate var1
           when 1 
                modify lb-optional title "Optional 1"
           when 2 
                modify lb-optional title "Optional 2"
           when 3 
                modify lb-optional title "Optional 3"
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
