      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.     JAVABEAN.

       configuration section.
       repository.
           class BorderLayout   as "java.awt.BorderLayout"
           class JavaBean   
                    as "com.iscobol.gui.server.CobolGUIJavaBean"
           class ChartFactory   as "org.jfree.chart.ChartFactory"
           class ChartPanel     as "org.jfree.chart.ChartPanel"
           class JFreeChart     as "org.jfree.chart.JFreeChart"
           class PiePlot3D      as "org.jfree.chart.plot.PiePlot3D"
           class XYSeries       as "org.jfree.data.xy.XYSeries"
           class XYSeriesCollection  
                    as "org.jfree.data.xy.XYSeriesCollection"
           class DPDataset    
                    as "org.jfree.data.general.DefaultPieDataset"
           class DCDataset  
                    as "org.jfree.data.category.DefaultCategoryDataset"
           class PlotOrientation 
                    as "org.jfree.chart.plot.PlotOrientation"
           .

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0. 
       77  control-font            handle of font.

       77  chartValue1              pic s9(3) value 15.
       77  chartValue2              pic s9(3) value 52.
       77  chartValue3              pic s9(3) value 20.
       77  chartValue4              pic s9(3) value 10.
       77  chartValue5              pic s9(3) value 76.

       77  JBPiePlot                object reference JavaBean.
       77  wDPDataset               object reference DPDataset.
       77  wPiePlot3D               object reference PiePlot3D.
       77  wJFChart                 object reference JFreeChart.
       77  tmpFloat                 object reference "float".
       
       SCREEN SECTION.
       01  Mask.
           03 chart1 
              java-bean no-box
              clsid "javax.swing.JPanel"
              line 2 
              col 3
              lines 16
              size 68
              object in JBPiePlot
              layout-data rlm-resize-both
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
      
       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "JAVA-BEAN Control"
                   control font control-font
                   lines 21 
                   min-lines 21 
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
           display Mask
      
           perform INIT

           modify  hWin visible 1

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue 
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font

           goback
           .

       INIT.
           JBPiePlot:>callMethod("setLayout" BorderLayout:>new)
           set tmpFloat to 0.50
           set wDPDataset to DPDataset:>new
           wDPDataset:>setValue
                       ("foo" as string function abs(chartValue1))
           wDPDataset:>setValue
                       ("bar" as string function abs(chartValue2))
           wDPDataset:>setValue
                       ("baz" as string function abs(chartValue3))
           wDPDataset:>setValue
                       ("qux" as string function abs(chartValue4))
           wDPDataset:>setValue
                       ("foobar" as string function abs(chartValue5))
           set wPiePlot3D to PiePlot3D:>new(wDPDataset)
           wPiePlot3D:>setForegroundAlpha(tmpFloat)
           set wJFChart to JFreeChart:>new("Pie Chart 3D" wPiePlot3D)
           JBPiePlot:>callMethod("add" ChartPanel:>new(wJFChart)
                                 BorderLayout:>CENTER)
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
