      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. grid-std.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".

       01  tab-album.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(5)  value "4:03".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Yellow Submarine".
           03 filler               pic x(5)  value "2:40".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Revolver".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1966.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(5)  value "2:21".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Yesterday".
           03 filler               pic x(5)  value "2:07".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Angie".
           03 filler               pic x(5)  value "4:30".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Goats Head Soup".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "R.S.Records".
           03 filler               pic 9(4)  value 1973.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Start Me Up".
           03 filler               pic x(5)  value "3:32".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Tattoo You".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value 
                                               "Rolling Stones records".
           03 filler               pic 9(4)  value 1981.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Satisfaction".
           03 filler               pic x(5)  value "3:45".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Out of Our Heads".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Decca/ABKCO".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Rain Fall Down".
           03 filler               pic x(5)  value "4:55".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "A Bigger Bang".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Polydor Records".
           03 filler               pic 9(4)  value 2005.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Maria Maria".
           03 filler               pic x(5)  value "4:19".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Supernatural".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "BMG Arista/Ariola".
           03 filler               pic 9(4)  value 1999.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Oye como va".
           03 filler               pic x(5)  value "4:36".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Abraxas".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value 
                                               "Lightning in the sky".
           03 filler               pic x(5)  value "3:50".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Marathon".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Foo Foo".
           03 filler               pic x(5)  value "6:29".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Shaman".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Arista".
           03 filler               pic 9(4)  value 2002.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Money for Nothing".
           03 filler               pic x(5)  value "6:19".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value 
                                                  "After Midnight Live". 
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(30) value "Immortal".
           03 filler               pic 9(4)  value 2006.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "After Midnight".
           03 filler               pic x(5)  value "2:51".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Eric Clapton".
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(30) value 
                                               "Atco, Polydor Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Bad Love".
           03 filler               pic x(5)  value "6:25".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "24 Nights".
           03 filler               pic x(15) value "Blues rock".
           03 filler               pic x(30) value "Duck Records".
           03 filler               pic 9(4)  value 1991.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value 
                                               "Next Time You See Her".
           03 filler               pic x(5)  value "4:02".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Slowhand".
           03 filler               pic x(15) value "Blues".
           03 filler               pic x(30) value "Polydor".
           03 filler               pic 9(4)  value 1977.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Albachiara".
           03 filler               pic x(5)  value "4:05".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value 
                                         "Non siamo mica gli americani".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Lotus LOP".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Tango".
           03 filler               pic x(5)  value "3:07".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Liberi Liberi".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Emi".
           03 filler               pic 9(4)  value 1988.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(5)  value "4:38".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1987.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(5)  value "5:40".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1983.

       01  tab-album-red           redefines tab-album.
           03 ta-item              occurs 20.
              05 ta-prog           pic z(3).
              05 ta-title          pic x(30).
              05 ta-length         pic x(5).
              05 ta-Artist         pic x(20).
              05 ta-album          pic x(30).
              05 ta-genre          pic x(15).
              05 ta-label          pic x(30).
              05 ta-year           pic 9(4).

       77  crt-status              special-names crt status pic 9(5).
       77  hMain                   handle of window.
       77  hWin                    handle of window.
       77  hsearch                 handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9    value 0.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  cont                    pic 9(2) value 0.

       01  gd-data.
           05 gd-prog              pic z(3).
           05 gd-title             pic x(30).
           05 gd-length            pic x(5).
           05 gd-Artist            pic x(20).
           05 gd-album             pic x(30).
           05 gd-genre             pic x(15).
           05 gd-label             pic x(30).
           05 gd-year              pic 9(4).

       77  idx                     pic 9(3).

      *Variable for the grid search
       78  sizeofSearchString      value 256.
       01  SearchString            pic x(sizeofSearchString).
       01  SearchStringLength      pic 999 value 0.

       01  my-search-option.
           03 DirValue             pic x(8).
           03 WrapValue            pic x(20).
           03 CaseValue            pic x(10).
           03 MatchValue           pic x(25).
           03 LocValue             pic x(25).
           03 SkipValue            pic x(25).
           03 MoveValue            pic x(25).
           03 ColValue             pic x(30).
       
       78  78Forward               value "Forward".
       78  78Backward              value "Backward".
       78  78Wrap                  value "Yes".
       78  78NoWrap                value "No".
       78  ComboSize               value 22.
       78  78NoCase                value "Ignore".
       78  78Case                  value "Respect".
       78  78Any                   value "Contains".
       78  78Lead                  value "Start with".
       78  78All                   value "Match all".
       78  78Vis                   value "Visible data".
       78  78Hid                   value "Hidden data".
       78  78AllData               value "Any data".
       78  78Skip                  value "Next cell".
       78  78NoSkip                value "Current cell".
       78  78Move                  value "Move Selection".
       78  78NoMove                value "Do not move selection".
       78  78AllCol                value "All columns".
       78  78CurCol                value "Current column".
       01  EnableFindNext          pic 9 value 0.
           88 FindNextEnabled      value 1, false 0.
       01  SearchResult            pic 9.
       
       01  CursorX                 SIGNED-SHORT.
       01  CursorY                 SIGNED-LONG.

       SCREEN SECTION.

       01  Mask.
           03 label
              line                 1
              col                  2
              size                 60 cells
              title                "User can change column position and
      -                           "sort data by clicking on the heading"
              transparent
              . 
           03 label
              line                 3 
              col                  2 
              size                 60 cells
              title                "User cannot edit the second column"
              transparent
              .
           03 push-button
              title                "Search options"
              line                 3
              col                  39
              size                 14
              exception-value      5008
              .
           03 push-button
              title                "Find Next"
              line                 3 
              col                  55
              size                 14
              exception-value      5009
              .
           03 Gd
              grid 
              line                 5
              col                  2
              lines                8 
              size                 68 cells
              display-columns      (1, 5, 25, 35, 55, 80, 100, 120)
              data-columns         (1, 4, 34, 39, 59, 89, 104, 134)
              alignment            ("C", "L", "C", "L", "L", "L", "L", 
                                    "R")
              data-types           ("Z(3)", "X(30)", "X(5)", "X(20)", 
                                    "X(30)", "X(15)", "X(30)", "9(4)") 
              virtual-width        130
              boxed
              column-headings 
              row-headings 
              centered-headings
              tiled-headings
              Adjustable-Columns
              reordering-columns
              sortable-columns
              vscroll
              row-background-color-pattern = (-16777215, -14675438)
              end-color            -16774581
              heading-color        257
              border-color         rgb x#ACACAC
              heading-cursor-background-color 
                                   rgb x#D2D2D2
              heading-cursor-foreground-color 
                                   rgb x#217346
              cursor-frame-color   rgb x#217346
              row-rollover-background-color 
                                   rgb x#B7DFC9
              row-rollover-foreground-color 
                                   rgb x#217346
              heading-rollover-background-color 
                                   rgb x#9FD5B7
              heading-rollover-foreground-color 
                                   rgb x#000000
              id                   101
              event                GD-EVT
              .
           03 label
              line                 20 
              col                  2 
              title                "Row: "
              .
           03 lb-row
              label
              line                 20
              col                  7 
              size                 3 cells
              title                "2"
              .
           03 label
              line                 20
              col                  10 
              title                "Col: "
              .
           03 lb-col
              label
              line                 20 
              col                  15
              size                 3 cells
              title                "1"
              .
           03 lb-edit
              label
              line                 20 
              col                  20 
              size                 10 cells
              color                4101
              .
           03 push-button
              line                 20 
              col                  39
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       01  mask-search.
           03 label
              line                 2
              col                  2
              title                "Find:"
              .
           03 EFSearch 
              entry-field  
              line                 2
              col                  16
              value                SearchString
              size                 40
              max-text             sizeofSearchString
              notify-change
              event                EFSEARCH-EVENT
              .
           03 label
              line                 4
              col                  2
              title                "Direction:"
              .
           03 combo-box    
              drop-list
              col                  16
              size                 ComboSize cells
              unsorted
              item-to-add          (78Forward, 78Backward)
              value                DirValue
              .
           03 label
              line                 6
              col                  2
              title                "Wrap:"
              .
           03 combo-box    
              drop-list
              col                  16
              size                 ComboSize cells
              unsorted
              item-to-add          (78Wrap, 78NoWrap)
              value                WrapValue
              .
           03 label
              line                 8
              col                  2
              title                "Case sensitive:"
              .
           03 combo-box    
              drop-list
              col                  16
              size                 ComboSize cells
              unsorted
              item-to-add          (78NoCase, 78Case)
              value                CaseValue
              .
           03 label
              line                 10
              col                  2
              title                "Criteria:"
              .
           03 combo-box
              drop-list
              col                  16
              size                 ComboSize cells
              unsorted
              item-to-add          (78Any, 78Lead, 78All)
              value                MatchValue
              .
           03 label        
              line                 12
              col                  2
              title                "Type of data:"
              .
           03 combo-box    
              drop-list
              col                  16
              size                 ComboSize cells
              unsorted
              item-to-add          (78Vis, 78Hid, 78AllData)
              value                LocValue
              .
           03 label
              line                 14
              col                  2
              title                "Start from:"
              .
           03 combo-box    
              drop-list
              col                  16
              size                 ComboSize cells
              unsorted
              item-to-add          (78Skip, 78NoSkip)
              value                SkipValue
              .
           03 label        
              line                 16
              col                  2
              title                "Cursor:"
              .
           03 combo-box    
              drop-list
              col                  16
              size                 ComboSize cells
              unsorted
              item-to-add          (78Move, 78NoMove)
              value                MoveValue
              .
           03 label
              line                 18
              col                  2
              title                "Search in:"
              .
           03 combo-box
              drop-list
              col                  16
              size                 ComboSize cells
              unsorted
              item-to-add          (78AllCol, 78CurCol)
              value                ColValue
              .
           03 PBFindNext
              push-button  
              line                 16
              col                  42
              size                 16 cells
              title                "Find"
              exception-value      3
              default-button
              enabled              EnableFindNext
              .
           03 push-button  
              col                  42
              line                 18
              size                 16 cells
              title                "Cancel"
              cancel-button
              .


       PROCEDURE DIVISION.   
       MAIN.
           accept base-sorg-path from environment "home_source".
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title "GRID Control"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display mask

           modify  gd mass-update 1
           modify  gd x 2, y 1, cell-data "Title"
           modify  gd x 2, y 1, column-protection 1
           modify  gd x 3, y 1, cell-data "Length"
           modify  gd x 4, y 1, cell-data "Artist"
           modify  gd x 5, y 1, cell-data "Album"
           modify  gd x 6, y 1, cell-data "Genre"
           modify  gd x 7, y 1, cell-data "Label"
           modify  gd x 8, y 1, cell-data "Year"

           modify  gd insertion-index 2
           perform varying idx from 1 by 1 until idx > 20
              move idx to ta-prog(idx)
              move ta-item(idx)  to gd-data
              modify Gd record-to-add gd-data
           end-perform
           modify  gd mass-update 0

           perform until crt-status = 27 or close-win = 1
              accept Mask
                   on exception 
                      continue
              end-accept
              evaluate crt-status
              when 2
                   perform VIEW-SORG
              when 5008
                   perform SEARCH-GRID
              when 5009
                   perform FIND-GRID
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy mask
           destroy hWin
           destroy control-font
           goback
           .

       GD-EVT.
           evaluate event-type
           when msg-goto-cell
           when msg-goto-cell-mouse
           when msg-goto-cell-drag
                modify lb-row value event-data-2
                modify lb-col value event-data-1
           when msg-begin-entry
                modify lb-edit value "Editing.."
           when msg-finish-entry
           when msg-cancel-entry
                modify lb-edit value spaces
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       SEARCH-GRID.
           display floating window
                   system menu 
                   title "Search grid options"
                   lines 20 
                   size 60
                   control font control-font
                   event WIN-EVT
                   handle hsearch

           if my-search-option = space
              move 78Forward to DirValue
              move 78Wrap    to WrapValue
              move 78NoCase  to CaseValue
              move 78Any     to MatchValue
              move 78Vis     to LocValue
              move 78NOSkip  to SkipValue
              move 78Move    to MoveValue
              move 78AllCol  to ColValue
           end-if
           display mask-search.

           perform until crt-status = 27
              accept mask-search on exception continue end-accept
              if crt-status = 3
                 perform FIND
                 if SearchResult not = GRDSRCH-NOT-FOUND
                    exit perform
                 end-if
              end-if
              if close-win = 1
                 move 0 to  close-win
                 exit perform
              end-if
           end-perform
           destroy mask-search
           destroy hsearch
           move zero   to crt-status
           move 101    to control-id
           move 4      to accept-control.

       FIND-GRID.
           if SearchString = space
              perform SEARCH-GRID
           else
              move 78Move to MoveValue
              perform FIND-NEXT
              move 101    to control-id
              move 4      to accept-control
           end-if.

       FIND.
           if SearchStringLength = 0
              exit paragraph
           end-if.
           perform GET-SEARCH-VALUES.
           modify Gd, search-options = GRID-SEARCH-OPTIONS.
           modify Gd (CursorY, CursorX) search-text = SearchString
                                        length      = SearchStringLength
                                        giving SearchResult.
           perform FIND-RESULT.

       FIND-RESULT.
           if SearchResult = GRDSRCH-NOT-FOUND
              display message box "Can not find the specified text"
           else
              inquire Gd cursor-y CursorY, 
                         cursor-x CursorX
              modify lb-row value CursorY
              modify lb-col value CursorX
           end-if.

       FIND-NEXT.
           if SearchStringLength = 0
              exit paragraph  
           end-if.
           inquire Gd, search-options = GRID-SEARCH-OPTIONS
                           cursor-x in CursorX
                           cursor-y in CursorY.
           if not GRID-SEARCH-SKIP-CURRENT
              set GRID-SEARCH-SKIP-CURRENT to true
              modify Gd, search-options = GRID-SEARCH-OPTIONS
           end-if
           modify Gd (CursorY, CursorX),
                  search-text    = SearchString
                  length         = SearchStringLength
                  giving           SearchResult
                  .
           perform FIND-RESULT.

       EFSEARCH-EVENT.
           evaluate event-type
           when NTF-CHANGED
                inquire event-control-handle value in SearchString
                                            length in SearchStringLength
                perform ENABLE-BUTTONS-SEARCH
                set event-action to event-action-continue
           end-evaluate.

       ENABLE-BUTTONS-SEARCH.
           if SearchStringLength = 0
              if FindNextEnabled
                 set FindNextEnabled to false
                 modify PBFindNext, enabled = EnableFindNext
              end-if
           else
              if not FindNextEnabled
                 set FindNextEnabled to true
                 modify PBFindNext, enabled = EnableFindNext
              end-if
           end-if.

       GET-SEARCH-VALUES.
           inquire gd, cursor-x in CursorX
                       cursor-y in CursorY.
           if DirValue = 78forward
              set GRID-SEARCH-FORWARDS    to true
           else                 
              set GRID-SEARCH-FORWARDS    to false
           end-if.
           if WrapValue = 78Wrap   
              set GRID-SEARCH-WRAP        to true
           else
              set GRID-SEARCH-WRAP        to false
           end-if.
           if CaseValue = 78NoCase 
              set GRID-SEARCH-IGNORE-CASE to true
           else
              set GRID-SEARCH-IGNORE-CASE to false
           end-if
         
           evaluate MatchValue
           when 78Any
                set GRID-SEARCH-MATCH-ANY       to true
           when 78Lead
                set GRID-SEARCH-MATCH-LEADING   to true
           when 78All
                set GRID-SEARCH-MATCH-ALL       to true
           end-evaluate.
           evaluate LocValue
           when 78Vis
                set GRID-SEARCH-VISIBLE         to true
           when 78Hid
                set GRID-SEARCH-HIDDEN          to true
           when 78AllData
                set GRID-SEARCH-ALL-DATA        to true
           end-evaluate.
         
           if SkipValue = 78Skip   
              set GRID-SEARCH-SKIP-CURRENT to true
           else
              set GRID-SEARCH-SKIP-CURRENT to false
           end-if.
           if MoveValue = 78Move   
              set GRID-SEARCH-MOVES-CURSOR to true
           else
              set GRID-SEARCH-MOVES-CURSOR to false
           end-if.
           if ColValue = 78AllCol
              set GRID-SEARCH-ALL-COLUMNS  to true
           else
              move CursorX to GRID-SEARCH-COLUMN
           end-if.

       VIEW-SORG.
           initialize command
           string base-sorg-path   delimited by trailing space
                  "s-gui"          delimited by space
                  "/GRID-STD.cbl"  delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
