      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. bitmap.   


       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0. 
       77  control-font            handle of font.
 
       77  bitmap-path             pic x(256).
       77  bmp-handle              pic s9(9) comp-4. 
       77  v-local                 pic 9.
       77  scale-type              pic 9 value 1.
           88 original             value 1.
           88 strech               value 2.
           88 fit                  value 3.

       77  wrk-scale               pic 9.
       77  v-bmp1                  pic 9 value 1.

       SCREEN SECTION.
       01  Mask.
           03 frame
              line                 1
              col                  2
              lines                17 cells
              size                 68 cells
              .
           03 Bmp1 
              bitmap
              line                 2
              col                  3
              lines                15 cells
              size                 66 cells
              bitmap-handle        bmp-handle
              visible              v-bmp1
              .
           03 Ef1  
              entry-field 
              line                 18 
              col                  2 
              size                 60 cells
              max-text             256
              value                bitmap-path
              .
           03 Pb1  
              push-button
              line                 18 
              col                  62 
              size                 8 cells
              title                "..." 
              exception-value      101
              visible              v-local
              self-act
              .
           03 Pb-image  
              push-button
              line                 20 
              col                  2 
              size                 12 cells
              title                "Load image" 
              exception-value      102
              self-act
              .
           03 radio-button
              group                1
              group-value          1
              line                 20.2
              col                  15 
              title                "Original size"
              value                scale-type
              exception-value      103
              self-act
              .
           03 radio-button
              group                1
              group-value          2
              line                 20.2
              col                  32
              title                "Strech" 
              value                scale-type
              exception-value      103
              self-act
              .
           03 radio-button
              group                1
              group-value          3
              line                 20.2 
              col                  44 
              title                "Fit" 
              value                scale-type
              exception-value      103
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to v-local
           else
              move 1      to v-local
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "BITMAP Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           move "files/img.png" to bitmap-path
           move zero to bmp-handle

           display Mask

           perform LOAD-IMAGE

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    evaluate crt-status 
                    when 101
                         perform CHOOSE-IMAGE
                    when 102
                         perform LOAD-IMAGE
                    when 103
                         perform CHANGE-SCALE
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-IMAGE
           goback
           .

       LOAD-IMAGE.
           perform DESTROY-IMAGE

           call "W$BITMAP" using wbitmap-load, bitmap-path
                           giving bmp-handle

           evaluate bmp-handle
           when -1
                move 0 to v-bmp1
                display message "File not found or not readable"
                                icon 3
           when -2
                move 0 to v-bmp1
                display message "Out of memory loading the bitmap"
                                icon 3
 
           when -3
                move 0 to v-bmp1
                display message "Not a valid bitmap"
                                icon 3
 
           when -4
                move 0 to v-bmp1
                display message "Format not supported"
                                icon 3
           when other
                move 1 to v-bmp1
           end-evaluate

           subtract 1 from scale-type giving wrk-scale 

           modify Bmp1 bitmap-handle bmp-handle
                       bitmap-scale  wrk-scale
                       visible v-bmp1 
           .

       CHANGE-SCALE.
           subtract 1 from scale-type giving wrk-scale 
           modify Bmp1 bitmap-handle bmp-handle
                       bitmap-scale wrk-scale.

       DESTROY-IMAGE.
           if function handle-type (bmp-handle) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy, bmp-handle
           end-if.

       CHOOSE-IMAGE.
           initialize opensave-data

           string "BMP Files (*.bmp)|*.bmp|"
                  "JPG Files (*.jpg)|*.jpg|"
                  "GIF Files (*.gif)|*.gif|"
                  "PNG Files (*.png)|*.png|"
                  "All images (*.bmp;*.jpg;*.gif;*.png)|"
                  "*.bmp;*.jpg;*.gif;*.png"
                  delimited by size
                  into opnsav-filters.

           move 5   to opnsav-default-filter

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data.

           if opnsav-basename not = spaces
              move opnsav-filename to bitmap-path
              modify Ef1 value opnsav-filename  
              perform LOAD-IMAGE
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
