      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CALL-ISMIGRATE.   

       WORKING-STORAGE SECTION.
       77  ismigrate-input  pic x(256).
       77  ismigrate-output pic x(256).
       77  curr-dir         pic x(256).
       77  data-folder      pic x(50).

       01  more-info.
           03 read-count    long.
           03 write-count   long.
           03 skip-count    long.
           03 error-buffer. 
              05 err-1      pic x(128).
              05 err-2      pic x(256).

       PROCEDURE DIVISION.
       main. 
           call "c$chdir" using curr-dir.
           accept data-folder from environment "hook.data"
           if data-folder = spaces
              move "." to data-folder
           end-if

           set environment "ismigrate_input_file_index"    to "jisam". 
           set environment "ismigrate_output_file_index"   to "jisam".
           set environment "ismigrate_no_directories"      to "1".
           set environment "ismigrate_no_echo"             to "1".
           set environment "ismigrate_additional_bytes"    to "1".
           set environment "ismigrate_hook"                to "ISHOOK".
           set environment "file.index.index_suffix"       to ".idx"
           set environment "file.index.data_suffix"        to ".dat".

           string curr-dir              delimited by trailing spaces
                  "/"                   delimited by size
                  data-folder           delimited by trailing spaces
                  "/"                   delimited by size
                  "songs"               delimited by size
                                        into ismigrate-input.

           initialize ismigrate-output
           string ismigrate-input  delimited by trailing space
                  "new"            delimited by size
                  into ismigrate-output

           display "Migrating " ismigrate-input

           call "ISMIGRATE" using ismigrate-input, 
                                  ismigrate-output,
                                  more-info
                           giving return-code
           if return-code = 0
              display "migration OK"
              display read-count  " read, "
                      write-count " written, "
                      skip-count  " skipped"
           else
              display err-1
              display err-2
           end-if

           goback.

