      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
           >>IMP OPTION "-b"
       IDENTIFICATION DIVISION. 
       CLASS-ID. AuditTrigger AS "AuditTrigger" INHERITS DYNAMICISAM.
       
       CONFIGURATION SECTION.
       REPOSITORY.
           CLASS JINT            as "int"
           CLASS JLONG           as "long"
           CLASS JSTRING         as "java.lang.String" 
           CLASS JBOOL           as "boolean"
           CLASS JBYTEARRAY      as "byte[]"
           CLASS DYNAMICFILE     as "com.iscobol.rts.DynamicFile"
           CLASS KEYDESCRIPTION  as "com.iscobol.rts.KeyDescription"
           CLASS KEYDESCRIPTIONS as "com.iscobol.rts.KeyDescription[]"
           >>EVALUATE auditfilesystem
           >>WHEN "jisam"
              CLASS DYNAMICISAM  as "com.iscobol.io.DynamicJIsam"
           >>WHEN "ctreej"
              CLASS DYNAMICISAM  as "com.iscobol.io.DynamicCtreeJ"
           >>WHEN "easydb"
              CLASS DYNAMICISAM  as "com.iscobol.io.DynamicEasyDB"
           >>WHEN other
              CLASS DYNAMICISAM  as "com.iscobol.io.DynamicJIsam"
           >>END-EVALUATE
           CLASS STRINGBUFFER    as "java.lang.StringBuffer"
           .

       IDENTIFICATION DIVISION.
       OBJECT.

       WORKING-STORAGE SECTION.
       copy "audit.wrk".

       01  cblt-splitjoin-buf.
           03 cblte-sj-param-length            pic x(2) comp-x.
           03 cblte-sj-split-join-flag1        pic x comp-x.
           03 cblte-sj-split-join-flag2        pic x comp-x.
           03 cblte-sj-device-offset           pic x(2) comp-x.
           03 cblte-sj-device-length           pic x(2) comp-x.
           03 cblte-sj-basename-offset         pic x(2) comp-x.
           03 cblte-sj-basename-length         pic x(2) comp-x.
           03 cblte-sj-extension-offset        pic x(2) comp-x.
           03 cblte-sj-extension-length        pic x(2) comp-x.
           03 cblte-sj-total-length            pic x(2) comp-x.
           03 cblte-sj-split-buf-len           pic x(2) comp-x.
           03 cblte-sj-join-buf-len            pic x(2) comp-x.
           03 cblte-sj-first-component-length  pic x(2) comp-x.

       77  file-name                           pic x any length.
       77  wrk-basename                        pic x any length.

       01  audit-data.
           05 ad-open                          pic 9.
              88 ad-open-yes                   value 1 false 0.
           05 ad-close                         pic 9.
              88 ad-close-yes                  value 1 false 0.
           05 ad-delete-record                 pic 9.
              88 ad-delete-record-yes          value 1 false 0.
           05 ad-delete-file                   pic 9.
              88 ad-delete-file-yes            value 1 false 0.
           05 ad-read                          pic 9.
              88 ad-read-yes                   value 1 false 0.
           05 ad-write                         pic 9.
              88 ad-write-yes                  value 1 false 0.
           05 ad-rewrite                       pic 9.
              88 ad-rewrite-yes                value 1 false 0.
           05 ad-seg-info.
              10 ad-seg-info-occurs            occurs 16 times.
                 15 ad-key-size                pic 9(3).
                 15 ad-key-offset              pic 9(10).

       77  isam-name                           pic x(20).
       77  isam-rec                            pic x any length.

       PROCEDURE DIVISION.

      ******************************************************************

       IDENTIFICATION DIVISION.
       METHOD-ID. MY-OPEN AS "open" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT      OBJECT REFERENCE JINT. 

       LINKAGE SECTION.
       77  PATH        OBJECT REFERENCE JSTRING.
       77  OPENTYPE    OBJECT REFERENCE JINT.
       77  LOCKTYPE    OBJECT REFERENCE JINT.
       77  KEYS        OBJECT REFERENCE KEYDESCRIPTIONS.
       77  MAXREC      OBJECT REFERENCE JINT.
       77  MINREC      OBJECT REFERENCE JINT.
       77  NKEYS       OBJECT REFERENCE JINT.
       77  ACCESSMODE  OBJECT REFERENCE JINT.
       77  OPTIONL     OBJECT REFERENCE "boolean".
       77  ASSIGNEXT   OBJECT REFERENCE "boolean".
       PROCEDURE DIVISION USING PATH, 
                                OPENTYPE, 
                                LOCKTYPE, 
                                KEYS, 
                                MAXREC, 
                                MINREC, 
                                NKEYS, 
                                ACCESSMODE,
                                OPTIONL,
                                ASSIGNEXT
                     RETURNING RESULT.
       MAIN.      
      *AuditTrigger action - start
           perform AUDIT-SETTINGS
           if ad-open-yes
              SET ISAM-NAME TO wrk-basename
              set ao-open to true;;
              SELF:>write_audit (audit-operation, isam-name)
           end-if.  
      *AuditTrigger action - end

           SET RESULT TO SUPER:>open (PATH, 
                                      OPENTYPE, 
                                      LOCKTYPE, 
                                      KEYS, 
                                      MAXREC, 
                                      MINREC, 
                                      NKEYS, 
                                      ACCESSMODE,
                                      OPTIONL,
                                      ASSIGNEXT). 
           GOBACK.

       AUDIT-SETTINGS.
           set file-name TO PATH
           set cblte-sj-param-length  to size of cblt-splitjoin-buf
           set cblte-sj-split-buf-len to size of file-name
           call "CBL_SPLIT_FILENAME" using cblt-splitjoin-buf
                                            file-name

           move file-name
                     (cblte-sj-basename-offset:cblte-sj-basename-length)
                                   to wrk-basename.

           move all "0"   to audit-data.

           if wrk-basename not = "auditlog"
              if aso-file(1) = "ALL"
                 move aso-data(1)  to audit-data
              else
                 move all "0"   to audit-data
                 perform varying audit-idx from 1 by 1 
                                      until audit-idx > 10
                    if aso-file(audit-idx) = wrk-basename
                       move aso-data(audit-idx)   to audit-data
                       exit perform
                    end-if
                    if aso-file(audit-idx) = space
                       exit perform
                    end-if
                 end-perform
              end-if
           end-if.
       END METHOD.

      ******************************************************************

       IDENTIFICATION DIVISION.
       METHOD-ID. MY-CLOSE AS "close" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JINT.
       PROCEDURE DIVISION RETURNING RESULT.
       MAIN.
      *AuditTrigger action - start
           if ad-close-yes
              SET ISAM-NAME TO wrk-basename
              set ao-close to true;;
              SELF:>write_audit(audit-operation, isam-name)
           end-if.
      *AuditTrigger action - end
           SET RESULT TO SUPER:>close().
           GOBACK.
       END METHOD. 

      ******************************************************************

       IDENTIFICATION DIVISION.
       METHOD-ID. MY-READ AS "read" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD OBJECT REFERENCE JBYTEARRAY.
       77  OFFS      OBJECT REFERENCE JINT. 
       77  KEYNUM    OBJECT REFERENCE JINT.
       77  FLAGLOCK  OBJECT REFERENCE JINT.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                KEYNUM,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.
      *AuditTrigger action - start
           if ad-read-yes
              set ao-read    to true
              set ISAM-NAME  to wrk-basename
              set ISAM-REC   to THERECORD
              SELF:>write_audit(audit-operation, isam-name, isam-rec)
           end-if.
      *AuditTrigger action - end
           SET RESULT TO SUPER:>read (THERECORD,
                                      OFFS,
                                      KEYNUM,
                                      FLAGLOCK).
           GOBACK.
       END METHOD.

      ******************************************************************   

       IDENTIFICATION DIVISION.
       METHOD-ID. MY-READ AS "read" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD OBJECT REFERENCE JBYTEARRAY.
       77  OFFS      OBJECT REFERENCE JINT. 
       77  KEYS      OBJECT REFERENCE KEYDESCRIPTION.
       77  FLAGLOCK  OBJECT REFERENCE JINT.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                KEYS,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.
      *AuditTrigger action - start
           if ad-read-yes
              set ao-read  to true
              set ISAM-REC to THERECORD
              SELF:>write_audit(audit-operation, ISAM-NAME, ISAM-REC)
           end-if.
      *AuditTrigger action - end
           SET RESULT TO SUPER:>read (THERECORD,
                                      OFFS,
                                      KEYS,
                                      FLAGLOCK).
           GOBACK.
       END METHOD.  

      ****************************************************************** 

       IDENTIFICATION DIVISION.
       METHOD-ID. READ-NEXT AS "next" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD OBJECT REFERENCE JBYTEARRAY.
       77  OFFS      OBJECT REFERENCE JINT.      
       77  FLAGLOCK  OBJECT REFERENCE JINT.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.
           SET RESULT TO SUPER:>next (THERECORD,
                                      OFFS,
                                      FLAGLOCK).
      *AuditTrigger action - start
           if ad-read-yes
              set ao-read    to true
              SET ISAM-NAME  TO wrk-basename
              set ISAM-REC   to THERECORD
              SELF:>write_audit(audit-operation, ISAM-NAME, ISAM-REC)
           end-if.
      *AuditTrigger action - end
           GOBACK.
       END METHOD.  

      ****************************************************************** 

       IDENTIFICATION DIVISION.
       METHOD-ID. READ-PREV AS "previous" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD OBJECT REFERENCE JBYTEARRAY.
       77  OFFS      OBJECT REFERENCE JINT.      
       77  FLAGLOCK  OBJECT REFERENCE JINT.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.
           SET RESULT TO SUPER:>previous (THERECORD,
                                          OFFS,
                                          FLAGLOCK).
      *AuditTrigger action - start
           if ad-read-yes
              set ao-read    to true
              set isam-name  to wrk-basename
              set isam-rec   to THERECORD
              SELF:>write_audit(audit-operation, ISAM-NAME, ISAM-REC)
           end-if.
      *AuditTrigger action - end
           GOBACK.
       END METHOD.  

      ******************************************************************  

       IDENTIFICATION DIVISION.
       METHOD-ID. MY-WRITE AS "write" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
       77  OFFS       OBJECT REFERENCE JINT.  
       77  RECSIZE    OBJECT REFERENCE JINT.     
       77  FLAGLOCK   OBJECT REFERENCE JBOOL.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                RECSIZE,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.       
      *AuditTrigger action - start
           if ad-write-yes
              set ao-write   to true
              set isam-name  to wrk-basename
              set isam-rec   to THERECORD
              SELF:>write_audit(audit-operation, ISAM-NAME, ISAM-REC)
           end-if.
      *AuditTrigger action - end
           SET RESULT TO SUPER:>write (THERECORD,
                                       OFFS,
                                       RECSIZE,
                                       FLAGLOCK).
           GOBACK.
       END METHOD.  

      ******************************************************************  

       IDENTIFICATION DIVISION.
       METHOD-ID. MY-REWRITE AS "rewrite" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
       77  OFFS       OBJECT REFERENCE JINT.  
       77  RECSIZE    OBJECT REFERENCE JINT.     
       77  FLAGLOCK   OBJECT REFERENCE JBOOL.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS,
                                RECSIZE,
                                FLAGLOCK
                      RETURNING RESULT.
       MAIN.
      *AuditTrigger action - start
           if ad-close-yes
              set ao-rewrite to true
              set isam-name  to wrk-basename
              set ISAM-REC   to THERECORD
              SELF:>write_audit(audit-operation, ISAM-NAME, ISAM-REC)
           end-if.
      *AuditTrigger action - end
           SET RESULT TO SUPER:>rewrite (THERECORD,
                                         OFFS,
                                         RECSIZE,
                                         FLAGLOCK).
           GOBACK.
       END METHOD.  

      ******************************************************************   

       IDENTIFICATION DIVISION.
       METHOD-ID. MY-DELETE AS "delete" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JLONG.
       LINKAGE SECTION.
       77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
       77  OFFS       OBJECT REFERENCE JINT.
       PROCEDURE DIVISION USING THERECORD,
                                OFFS
                      RETURNING RESULT.
       MAIN.
      *AuditTrigger action - start
           if ad-delete-record-yes
              set ao-delete-record to true
              set isam-name        to wrk-basename
              set isam-rec         to THERECORD
              SELF:>write_audit(audit-operation, ISAM-NAME, ISAM-REC)
           end-if.
      *AuditTrigger action - end
           SET RESULT TO SUPER:>delete (THERECORD,
                                        OFFS).
           GOBACK.
       END METHOD.  

      ******************************************************************    

       IDENTIFICATION DIVISION.
       METHOD-ID. REMOVE AS "remove" OVERRIDE.
       WORKING-STORAGE SECTION.
       77  RESULT OBJECT REFERENCE JINT. 
       LINKAGE SECTION.
       77  NAME    OBJECT REFERENCE JSTRING.
       PROCEDURE DIVISION USING NAME
                      RETURNING RESULT.
       MAIN.
      *AuditTrigger action - start
           if ad-delete-file-yes
              set ao-delete-file   to true;;
              set isam-name        to wrk-basename
              SELF:>write_audit(audit-operation, ISAM-NAME)
           end-if.
      *AuditTrigger action - end
           SET RESULT TO SUPER:>remove (NAME).
           GOBACK.
       END METHOD.  

      ******************************************************************    

       IDENTIFICATION DIVISION.
       METHOD-ID. WRITE-AUDIT AS "write_audit".
       working-storage section.

       77  size-of-record  pic 9(10).
       01  msg.
           05 msg-filler     pic x(5) value "AUDIT".
           05 msg-ISAM-OP    PIC X(2).
           05 msg-ISAM-NAME  PIC X(20).
           05 msg-record     pic x(256).

       LINKAGE SECTION.
       77  ISAM-OP    PIC X(2).
       77  ISAM-NAME  PIC X(20).
       77  ISAM-REC   PIC x any length.
       77  idx        pic 9(3).

       PROCEDURE DIVISION USING ISAM-OP, ISAM-NAME, ISAM-REC.
       MAIN. 
      *
           move ISAM-OP   to msg-ISAM-OP
           move ISAM-NAME to msg-ISAM-NAME

           move 27        to size-of-record
           initialize msg-record
           perform varying idx from 1 by 1 until idx > 16
              if ad-key-offset(idx) = 0
                 exit perform
              end-if
              string msg-record delimited by trailing space
                     ISAM-REC(ad-key-offset(idx):ad-key-size(idx))
                                delimited by size
                     into msg-record
              add ad-key-size(idx) to size-of-record
           end-perform

           send msg(1:size-of-record) to th-auditlog
           
           call "C$WRITELOG" using "Spedito al thread "
                                   th-auditlog
           call "C$WRITELOG" using msg(1:size-of-record)

           GOBACK.
       END METHOD.

      ******************************************************************

       IDENTIFICATION DIVISION.
       METHOD-ID. WRITE-AUDIT AS "write_audit".
       WORKING-STORAGE SECTION.
       01  msg.
           05 msg-filler     pic x(5) value "AUDIT".
           05 msg-ISAM-OP    PIC X(2).
           05 msg-ISAM-NAME  PIC X(20).

       LINKAGE SECTION.
       77  ISAM-OP PIC X(2).
       77  ISAM-NAME PIC X(20).

       PROCEDURE DIVISION USING ISAM-OP, ISAM-NAME.
       MAIN. 
           move ISAM-OP   to msg-ISAM-OP
           move ISAM-NAME to msg-ISAM-NAME

           send msg to th-auditlog

           call "C$WRITELOG" using "Spedito al thread "
                                   th-auditlog
           call "C$WRITELOG" using msg

           GOBACK.
       END METHOD.

      ******************************************************************

       END OBJECT.

      ******************************************************************
