      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. ISRESETFILE.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       DATA DIVISION.
       FILE SECTION.
      
       WORKING-STORAGE SECTION.

           copy "common.wrk".
           copy "color.wrk".

       77  choice               pic x.
       77  reset-file           pic 9.

       screen section.

       01  mask-main.
           05 label
              foreground-color RGB 78-lbl-menu-foreground-color
              background-color RGB 78-lbl-menu-background-color
              right
              col 31
              line 1
              lines 2 
              size 29
              height-in-cells
              width-in-cells
              . 
           05 frame 
              raised
              line 3 
              col 31
              lines 12 cells
              size 29 cells
              .
           05 Label, 
              COL 32
              LINE 6
              SIZE 27
              LINES 4
              centered
              TITLE R"Reset_the_files_to_the_default_installation"
              transparent
              .
           05 pb-reset-file Push-Button
              col 38 
              line 9
              lines 2.2 cells
              size 16 cells
              exception-value 2001
              title R"&Reset_Files"
              self-act
              flat
              background-color     78-pb-background-color
              foreground-color     78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color

              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              .

       01  mask-tool.
           05 push-button 
              title R"&Exit"
              hint R"(Esc)"
              bitmap-handle h-tools
              bitmap-number 78-n-exit
              bitmap-rollover 78-n-exit-rollover
              title-position 2
              lines 2.2 cells
              size 12 cells
              bitmap-width 16
              col + 1.2
              exception-value 27
              self-act
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .

       PROCEDURE DIVISION.
       MAIN.

           move zero   to reset-file
           
           if not user-super
              display message box R"For_Super_user_only!"
              goback reset-file
           end-if.
           
           display independent graphical window      
                   title R"isCOBOL_Application_Reset_File"
                   lines 14
                   size 60
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2 
                   .
           
           call "ISTOOLTIP"
           cancel "ISTOOLTIP"
           
           display tool-bar 
                   lines 2.5 
                   control font h-font 
                   handle h-tool 
                   upon h-sta
           
           display mask-main upon h-sta
           display mask-tool upon h-tool
           
           modify h-sta visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform
           
           perform EXIT-PRG.
           
           goback reset-file
           .

       AFTER-ACCEPT.
           evaluate key-status
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           when 2001
                display message box R"Do_you_really_want_to_reset_the_fi
      -                          "les_to_the_default_installation?"
                        type mb-yes-no
                        default mb-no
                        icon mb-warning-icon
                        giving choice
                if choice = mb-yes
                   perform RESET-FILE-PROCEDURE
                   move 27 to key-status
                end-if
           end-evaluate.

       DISPLAY-SCREEN.

           display mask-main.
 
       EXIT-PRG.
           perform DESTROY-RESOURCE
           .

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       RESET-FILE-PROCEDURE.
      *> create the default file
           call "CHECKFILE"
           cancel "CHECKFILE".
           move 1   to reset-file.
