      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. ISCHARPROG.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
        copy "customer.sl".
       DATA DIVISION.
       FILE SECTION.
        COPY "customer.fd".
      
       WORKING-STORAGE SECTION.
      
       copy "common.wrk".
      
       77  STATUS-customer   PIC XX.
      
       01  screen-value.
           05 scr-id          pic  x(10).
           05 scr-fname       pic  x(20).
           05 scr-lname       pic  x(50).
           05 scr-tel1        pic  x(15).
           05 scr-tel2        pic  x(15).
           05 scr-fax         pic  x(15).
           05 scr-addr        pic  x(50).
           05 scr-contact     pic  x(20).
           05 scr-email       pic  x(30).
           
       78  id-ef-scr-id        value 100.
       78  id-ef-scr-fname     value 101.
       78  id-ef-scr-lname     value 102.
       78  id-ef-scr-tel1      value 103.
       78  id-ef-scr-tel2      value 104.
       78  id-ef-scr-fax       value 105.
       78  id-ef-scr-addr      value 106.
       78  id-ef-scr-contact   value 107.
       78  id-ef-scr-email     value 108.
           
       01                        pic 9.
           88 all-ok             value 1 false zero.

       77  choice               pic x.
       77  wrk-msg               pic x(80).
       77  cont                 pic 9(3).
      
       screen section.
       01  mask-main.
           05 col 02 line 02
              from R"Iscobol_Application_Customer".
           05 col 01 
              line 3
              from wrk-msg
              reverse.
        
           05 COL 3
              LINE 5
              from R"Customer_id"
              .
           05 ef-scr-id 
              COL 20 
              LINE 5
              using scr-id
              after AFT-ef-scr-id
              id id-ef-scr-id
              .
        
           05 COL 3
              line 6
              from R"First_Name"
              .
           05 ef-scr-fname  
              COL 20
              LINE 6
              using scr-fname
              id id-ef-scr-fname
              .
        
           05 COL 3
              line 7
              from R"Last_Name"
               .
           05 ef-scr-lname  
              COL 20
              LINE 7
              using scr-lname
              id id-ef-scr-lname
              .
        
           05 COL 3
              line 8
              from R"Telephone_1"
              .
           05 ef-scr-tel1  
              LINE 8
              COL 20
              using scr-tel1
              id id-ef-scr-tel1
              .
        
           05 COL 3
              line 9
              from R"Telephone_2"
              .
           05 ef-scr-tel2 
              COL 20
              LINE 9
              using scr-tel2
              id id-ef-scr-tel2
              .
        
           05 COL 3
              line 10
              from R"Fax"
               .
           05 ef-scr-fax 
              COL 20
              LINE 10
              using scr-fax
              id id-ef-scr-fax
              .
        
           05 COL 3
              line 11
              from R"Address_"
               .
           05 ef-scr-addr 
              COL 20
              LINE 11
              using scr-addr
              id id-ef-scr-addr
              .
        
           05 COL 3
              LINE 12
              from R"Contact"
              .
           05 ef-scr-contact 
              COL 20
              LINE 12
              using scr-contact
              id id-ef-scr-contact
              .
        
           05 COL 3
              LINE 13
              from R"E-mail"
              .
           05 ef-scr-email 
              COL 20
              LINE 13
              using scr-email
              id id-ef-scr-email
              .
        
           05 COL 2
              LINE 23
              from R"F2_New_-_F3_Save_-_F4_Delete"
              .
           05 COL 2
              LINE 24
              from R"F11_First_-_PgUp_Previous_-_PgDn_next_-_F12_Last_"
              .

       PROCEDURE DIVISION.
       DECLARATIVES.
       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       MAIN.
       
           display mask-main
          
           display box line 4 col 1 lines 18 size 80
          
           perform OPEN-FILES.
          
           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform       
          
           perform EXIT-PRG.
          
           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-new
                initialize cust-record
                perform DISPLAY-SCREEN
           when 78-exe-save
                perform SAVE-RECORD
           when 78-exe-delete
                perform DELETE-RECORD
                initialize cust-record
                perform DISPLAY-SCREEN
           when 11 
                perform READ-FIRST
                perform DISPLAY-SCREEN
           when 78-exe-prev
                perform READ-PREV
                perform DISPLAY-SCREEN
           when 78-exe-next
                perform READ-NEXT
                perform DISPLAY-SCREEN
           when 12 
                perform READ-LAST
                perform DISPLAY-SCREEN
           end-evaluate.

       DELETE-RECORD.
           move R"Are_you_sure_to_delete_the_selected_record?"
                                                  to wrk-msg
           display mask-main
           
           perform until choice = "Y" or "N"
              accept choice at line 03 col 79
              call "C$TOUPPER" using choice, 1
           end-perform
           if choice = "Y"
              move scr-id   to cust-id
              delete customer record
                 invalid
                    continue
              end-delete
            end-if.

       SAVE-RECORD.
           set all-ok  to true
           perform CONTROL-ALL
           
           if all-ok
              move scr-id      to cust-id
              move scr-fname   to cust-fname
              move scr-lname   to cust-lname
              move scr-tel1    to cust-tel1
              move scr-tel2    to cust-tel2
              move scr-fax     to cust-fax
              move scr-addr    to cust-addr
              move scr-contact to cust-contact
              move scr-email   to cust-email
           
              rewrite cust-record
                 invalid
                    write cust-record
              end-rewrite
           end-if.
 
       CONTROL-ALL.
           move space to wrk-msg
           if scr-id = space
              move R"Customer_id_is_mandatory!" to wrk-msg
              move id-ef-scr-id  to control-id
              set all-ok          to false
           end-if.
           
           
           if all-ok
              if scr-lname = space
                 move R"Last_name_is_mandatory!" to wrk-msg
                 move id-ef-scr-lname   to control-id
                 set all-ok             to false
              end-if
           end-if.
           
           if all-ok and scr-email not = space
              move zero   to cont
              inspect scr-email tallying cont for all "@"
              if cont not = 1
                 move R"Wrong_e-mail_address!" to wrk-msg
                 move id-ef-scr-email   to control-id
                 set all-ok             to false
              end-if
           end-if.
           
           display mask-main.
 
       READ-FIRST.
           move low-value  to cust-id
           start customer key not < cust-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize cust-record
              not invalid
                read customer next no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize cust-record
                end-read
           end-start.
 
       READ-LAST.
           move high-value  to cust-id
           start customer key not > cust-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize cust-record
              not invalid
                read customer previous no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize cust-record
                end-read
           end-start.
 
       READ-PREV.
           move space to wrk-msg
         
           if scr-id = space
              perform READ-LAST
           else
              move scr-id  to cust-id
              read customer no lock
                invalid
                   start customer key not < cust-key
                      invalid
                         initialize cust-record
                   end-start
              end-read
              read customer previous no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.

       READ-NEXT.
           move space to wrk-msg
           if scr-id = space
              perform READ-FIRST
           else
              move scr-id  to cust-id
              read customer no lock
                invalid
                   start customer key not > cust-key
                      invalid
                         initialize cust-record
                   end-start
              end-read
              read customer next no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.
 
 
       RECORD-NOT-FOUND.
           move R"Record_not_found"   to wrk-msg.
           display mask-main.
 
       DISPLAY-SCREEN.
           move cust-id          to scr-id
           move cust-fname       to scr-fname
           move cust-lname       to scr-lname
           move cust-tel1        to scr-tel1
           move cust-tel2        to scr-tel2
           move cust-fax         to scr-fax
           move cust-addr        to scr-addr
           move cust-contact     to scr-contact
           move cust-email       to scr-email
           
           display mask-main.
 
       OPEN-FILES.
           open I-O customer.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close customer.

       DESTROY-RESOURCE.
           destroy mask-main  
           .

       AFT-ef-scr-id.
           if key-status = 13
              perform LOAD-RECORD
           end-if.

       LOAD-RECORD.
           move space to wrk-msg
           move scr-id  to cust-id
           read customer no lock
              invalid
                 perform RECORD-NOT-FOUND
              not invalid
                 perform DISPLAY-SCREEN
           end-read.

           copy "dec-file.prd".
