      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. ISCALLRUN.
       configuration section.
       special-names.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       DATA DIVISION.
       FILE SECTION.
      
       WORKING-STORAGE SECTION.

       copy "common.wrk".
       copy "color.wrk".
      
       01  hWin                 handle of window.
       01  hMain                handle of thread.
       01  hTime                handle of thread.
       01  msg-string           pic x(1).
       78  stop-msg             value "X".
       01  receive-status       pic 99.
       01  ora                  pic 9(8).
       01  ora-disp.
           03 h-disp            pic 99.
           03 filler            pic x value ":".
           03 m-disp            pic 99.
           03 filler            pic x value ":".
           03 s-disp            pic 99.

       screen section.

       01 mask-main.
           05 Label, 
              col 2
              line 2
              title r"Standard_Window_for_call_run"
              transparent
              .
           05 label
              line 4
              col 2
              title r"Time_"
              transparent
              .
           05 lbTime
              label
              col + 3
              size 12
              cells
              transparent
              .
           05 push-button  
              line 6
              col 6
              exception-value 27
              title R"&Esc"
              .

       PROCEDURE DIVISION.

       MAIN.

           accept hMain from thread.
           
           display standard window 
                   title R"isCOBOL_Application_Example_of_call_run"
                   lines 7
                   size 28
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   gradient-color-1 78-pb-foreground-color
                   gradient-color-2 rgb 78-gradient-color-2 
                   .

           display mask-main upon h-sta

           modify h-sta visible 1

           perform thread SHOW-TIME handle hTime.

           perform until key-status = 27 
              accept mask-main 
                 on exception 
                    continue 
              end-accept

              if key-status = w-event
                 evaluate event-type
                 when cmd-close
                      move 27 to key-status
                 end-evaluate
              end-if
           end-perform.

           send stop-msg to hTime.
           wait for hTime.
           move 0 to hTime.
           
           perform EXIT-PRG.

           goback
           .

       SHOW-TIME.
           perform until 1 = 2
              accept ora from time
              move ora(5:2) to s-disp
              move ora(3:2) to m-disp
              move ora(1:2) to h-disp
              modify lbTime title ora-disp
              receive msg-string from hMain before time 100
                 not on exception  
                    if msg-string = stop-msg
                       exit perform
                    end-if
              end-receive
           end-perform. 

       EXIT-PRG.
           perform DESTROY-RESOURCE
           .

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main  
                   h-sta 
           .

