      *    Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.
      
       PROGRAM-ID. CALLRUN-BRIDGE.
       configuration section.
       special-names.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       DATA DIVISION.
       FILE SECTION.

       WORKING-STORAGE SECTION.
           copy "audit-linkage.wrk".

       77  fileprefix        pic x any length.
       77  resourcelanguage  pic x(2).
       77  resource-name     pic x any length.

       01  file-info.
           02  file-size     pic x(8) comp-x.
           02  file-date     pic 9(8) comp-x.
           02  file-time     pic 9(8) comp-x.

       77  file-names        pic x any length.
       77  wstatus           pic s9.

       01  audit             pic 9 external.
           88 audit-enabled  value 1 false zero.

       linkage section.
       77  prg-to-launch     pic x(15).
       77  user-logged       pic x(20).

       procedure division using prg-to-launch, user-logged. 

       MAIN.

           perform INITIAL-SETTINGS.

           if audit-enabled
      *    Start the thread in the AUDIT program. 
              set audit-start-log to true
              call "AUDIT" using audit-link

      *    Load the AUDIT settings into a table from the 
      *    auditfilesettings file
              move user-logged           to audit-user-logged
              set audit-load-settings to true 
              call "AUDIT" using audit-link

      *    Register the start of the execution of a COBOL program
      *    according to the audit settings
              move prg-to-launch to audit-prg-to-launch
              set audit-register-pgm-start  to true
              call "AUDIT" using audit-link 
           end-if
           
           call prg-to-launch
              on overflow
                 perform CALL-NOT-FOUND
           end-call
           cancel prg-to-launch 
           
           if audit-enabled
      *    Register the end of the execution of a COBOL program
      *    according to the audit settings
              move prg-to-launch to audit-prg-to-launch
              set audit-register-pgm-end to true
              call "AUDIT" using audit-link 

      *    Stop the thread in the AUDIT program. 
              set audit-stop-log to true
              call "AUDIT" using audit-link
           end-if.

           goback.

       CALL-NOT-FOUND.
           display message box R"Program_not_Found!".

           copy "isapplication.prd".