package calendarpanel;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

import javax.swing.ImageIcon;

import org.jbundle.util.calendarpanel.event.MyListSelectionListener;
import org.jbundle.util.calendarpanel.model.CalendarItem;
import org.jbundle.util.calendarpanel.model.swing.AbstractCalendarModel;

public class CalendarPanelModel extends AbstractCalendarModel {
   
   private static final long serialVersionUID = 1L;
   
   private Vector<CalendarPanelItem> items = new Vector<CalendarPanelItem>();
   private Set<CalendarPanelItem> itemSet = new TreeSet<CalendarPanelItem>();
   private Date startDate;
   private Date endDate;
   
   public void addMySelectionListener(EventListener l) {
      if(!contains(l))
         listenerList.add(MyListSelectionListener.class, (MyListSelectionListener)l);
   }
   
   private boolean contains(EventListener l) {
      EventListener[] ls = listenerList.getListeners(MyListSelectionListener.class);
      if(ls == null)
         return false;
      for(EventListener l0 : ls)
         if(l0 == l)
            return true;
      return false;
   }
   
   @Override
   public void free() {
      items.clear();
      itemSet.clear();
   }

   @Override
   public CalendarItem getItem(int i) {
      return items.elementAt(i);
   }

   @Override
   public Date getStartDate() {
      return startDate;
   }

   public void setStartDate(Date startDate) {
      this.startDate = startDate;
   }
   
   @Override
   public Date getEndDate() {
      return endDate;
   }

   public void setEndDate(Date endDate) {
      this.endDate = endDate;
   }
   
   @Override
   public Date getSelectDate() {
      return startDate;
   }

   @Override
   public ImageIcon getHeaderIcon() {
      return null;
   }
   
   @Override
   public int getRowCount() {
      return items.size();
   }
   
   public void addItem(CalendarPanelItem item) {
      if(itemSet.contains(item)) {
         items.remove(item);
         itemSet.remove(item);
      }
      items.addElement(item);
      itemSet.add(item);
   }
   
   public CalendarPanelItem[] getItems() {
      return items.toArray(new CalendarPanelItem[items.size()]);
   }
   
   public CalendarPanelItem[] getItems(Date startDate) {
      List<CalendarPanelItem> result = new ArrayList<CalendarPanelItem>();
      for(CalendarPanelItem it : items) {
         if(it.getStartDate().equals(startDate))
            result.add(it);
      }
      return result.toArray(new CalendarPanelItem[result.size()]);
   }
   
   public CalendarPanelItem removeItem(int idx) {
      CalendarPanelItem Return = items.remove(idx);
      if(Return != null)
         itemSet.remove(Return);
      return Return;
   }
   
   public void removeItem(CalendarPanelItem item) {
      items.remove(item);
      itemSet.remove(item);
   }
   
}
