import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

import com.iscobol.gui.client.KeyboardBuffer;

public class JavaProg {

   public static void main(String[] args) {
      openJFrame();
   }
   
   public static void openJFrame() {
      final JFrame f = new JFrame("JFrame");
      f.setSize(300, 300);
      f.setLocationRelativeTo(null);
      f.getContentPane().setLayout(new BorderLayout(10, 10));
      final JTextArea ta = new JTextArea();
      ta.setText("Edit me");
      ta.setLineWrap(true);
      f.getContentPane().add(ta, BorderLayout.CENTER);
      JPanel btnPanel = new JPanel(new GridLayout(3, 1, 10, 10));
      f.getContentPane().add(btnPanel, BorderLayout.SOUTH);
      final JButton btn1 = new JButton("Open modal JDialog");
      btnPanel.add(btn1);
      btn1.addActionListener(new ActionListener() {
         
         @Override
         public void actionPerformed(ActionEvent e) {
            openJDialog(f, true);
         }
      });    
      final JButton btn2 = new JButton("Open JOptionPane");
      btnPanel.add(btn2);
      btn2.addActionListener(new ActionListener() {
         
         @Override
         public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(f, "Message Box");
         }
      });
      final JButton btn3 = new JButton("Exit");
      btn3.setMnemonic((int) 'e');
      btnPanel.add(btn3);
      btn3.addActionListener(new ActionListener() {
         
         @Override
         public void actionPerformed(ActionEvent e) {
            f.dispose();
         }
      });
      f.addWindowListener(new WindowAdapter() {
         public void windowClosing(WindowEvent e) {
            f.dispose();
         }
      });
      f.setVisible(true);
      
   }
   
   public static void openJDialog(Window owner, boolean modal) {
      if(modal) {
         KeyboardBuffer.setBufferOff();
      }
      final JDialog d;
      if(owner instanceof Frame) {
         d = new JDialog((Frame) owner, "JDialog", modal);
      } else if(owner instanceof Dialog) {
         d = new JDialog((Dialog) owner, "JDialog", modal);
      } else {
         d = new JDialog((Frame) null, "JDialog", modal);
      }
            
      d.setSize(300, 300);
      d.setLocationRelativeTo(null);
      d.getContentPane().setLayout(new BorderLayout());
      final JTextArea ta = new JTextArea();
      ta.setText("Edit me");
      ta.setLineWrap(true);
      d.getContentPane().add(ta, BorderLayout.CENTER);
      JPanel btnPanel = new JPanel(new GridLayout(3, 1));
      d.getContentPane().add(btnPanel, BorderLayout.SOUTH);
      final JButton btn1 = new JButton("Close");
      btnPanel.add(btn1);
      btn1.addActionListener(new ActionListener() {
         
         @Override
         public void actionPerformed(ActionEvent e) {
            d.dispose();
         }
      });    
      final JButton btn2 = new JButton("Open JOptionPane");
      btnPanel.add(btn2);
      btn2.addActionListener(new ActionListener() {
         
         @Override
         public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(d, "Message Box");
         }
      });
      d.addWindowListener(new WindowAdapter() {
         public void windowClosing(WindowEvent e) {
            d.dispose();
         }
      });
      d.setVisible(true);
      if(modal) {
         KeyboardBuffer.setBufferOn();
      }
   }

}
