      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

      $SET "oop.trim_parameters" "0"
       identification division. 
       class-id. PreProcAddSections as "PreProcAddSections"
                 implements LinePreProcessor.

       environment division.
       configuration section.

       repository.
           class LinePreProcessor as 
                 "com.iscobol.compiler.custpreproc.LinePreProcessor"
           class JString          as "java.lang.String"
           class JStringArr       as "java.lang.String[]"
           class ProcessResult    as 
                 "com.iscobol.compiler.custpreproc.ProcessResult"
           class ProcessException as 
                 "com.iscobol.compiler.custpreproc.ProcessException"
           .
       identification division.
       object.
       
       data division.
       working-storage section.
       77  flg-cs   pic 9 value 0.
           88 cs-present  value 1.
           88 cs-missing  value 0.
       77  flg-ios  pic 9 value 0.
           88 ios-present value 1.
           88 ios-missing value 0.
       
       procedure division.

       identification division.
       method-id. process as "process" override.
       working-storage section.
       77  cbl-line       pic x any length. 
       77  cbl-new-line   pic x any length.
       77  cnt            pic 9(3). 
       77  7spaces        pic x(7) value space.
 
       linkage section.
      *    The original line of the source code
      *    Initialized to NULL at program end
       77  original-line     object reference JString.
      *    Contains the source format
      *    0 = UNKNOWN_FORMAT
      *    1 = ANSI_FIXED
      *    2 = TERMINAL_FIXED
      *    3 = ANSI_FREE
      *    4 = VARIABLE
      *    5 = LONG_LINE
       77  source-format     object reference "int".
      *    Source file name
       77  source-file-name  object reference JString.
      *    The line number of the line being processed
      *    Initialized to zero at program end
       77  line-number       object reference "int".
      *    Contains the compiler options
       77  compiler-options  object reference JStringArr.
      *    Contains the result of the preprocessor
       77  result            object reference ProcessResult.

       procedure division using original-line, 
                                source-format,
                                source-file-name, 
                                line-number, 
                                compiler-options,
                                result
                        raising ProcessException.

       MAIN.
           if line-number = 0 and original-line = null
              goback
           end-if.
           set cbl-line to original-line.
           call "C$TOUPPER" using cbl-line.
           evaluate function trim(cbl-line)
           when "CONFIGURATION SECTION." 
              set cs-present to true
           when "INPUT-OUTPUT SECTION."
              set ios-present to true
           when "SOURCE-COMPUTER."
           when "OBJECT-COMPUTER."
           when "SPECIAL-NAMES."
           when "REPOSITORY."
              if not cs-present
                 initialize cbl-new-line
                 if source-format = 1
                    string 7spaces delimited by size into cbl-new-line
                 end-if
                 string cbl-new-line 
                        "CONFIGURATION SECTION." 
                        x"0a" 
                        cbl-line delimited by size into cbl-new-line
                 end-string
                 result:>setReplace(cbl-new-line)
                 set cs-present to true
              end-if
           when "FILE-CONTROL."
           when "IO-CONTROL."
              if not ios-present
                 initialize cbl-new-line
                 if source-format = 1
                    string 7spaces delimited by size into cbl-new-line
                 end-if
                 string cbl-new-line 
                        "INPUT-OUTPUT SECTION." 
                        x"0a" 
                        cbl-line delimited by size into cbl-new-line
                 end-string
                 result:>setReplace(cbl-new-line)
                 set ios-present to true
              end-if
           end-evaluate.
    
       end method.
       end object.
       end class.
  