      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       identification division.
       program-id. READ-DATA.

       environment division.
       input-output section.
       file-control.

       select sortfile assign to "SortFile.txt"
                 organization is line sequential
                 file status is file-status.

       data division.
       file section.
       fd  sortfile.
       01  sortrec.
           05 sr-title       pic x(30).
           05 sr-length      pic x(5).
           05 sr-artist      pic x(20).
           05 sr-album       pic x(30).
           05 sr-genre       pic x(15).
           05 sr-label       pic x(30).
           05 sr-year        pic 9(4).

       working-storage section.
       77  file-status          pic x(2).
       01  crerr-status.
           03 crerr-file-status pic xx.
           03 crerr-ext-status  pic x(128).
       77  crerr-mesage         pic x any length.

       77  rerrname             pic x(50).
       77  fileop               pic x(50).

       77  idx                  pic 9(3).

       01  display-data.
           05 ds-artist         pic x(20).
           05 filler            pic x(3) value " | ".
           05 ds-year           pic X(4).
           05 filler            pic x(3) value " | ".
           05 ds-album          pic x(30).
           05 filler            pic x(3) value " | ".
           05 ds-title          pic x(28).
           05 filler            pic x(3) value " | ".
           05 ds-length         pic x(20).

       procedure division.
       declaratives.
       SORTFILE-ERROR section.
           use after error procedure on sortfile.
           call "C$RERR"          using crerr-status
                                        crerr-mesage
           call "C$RERRNAME"      using rerrname
           call "C$GETLASTFILEOP" using fileOp
           display " "  
           display "Error " crerr-file-status " " 
                   function trim(crerr-ext-status)
                   " on " rerrname
           display crerr-mesage
           display "on statement " fileOp.

       end declaratives.

       MAIN.
           perform DISPLAY-SORT-FILE.

           goback.

      ***---
       DISPLAY-SORT-FILE.
           display " "
           display "List of the data after the sort..."

           open input sortfile
           perform DISPLAY-DATA-HEADER

           perform varying idx from 1 by 1 until idx > 20
              read sortfile next
                 at end
                    exit perform
              end-read
              perform DISPLAY-RECORD
           end-perform.

           close sortfile
           .

       DISPLAY-RECORD.
           move sr-artist to ds-artist 
           move sr-year   to ds-year   
           move sr-album  to ds-album  
           move sr-title  to ds-title  
           move sr-length to ds-length 

           display display-data.

       DISPLAY-DATA-HEADER.
           display " "
           move "ARTIST"  to ds-artist 
           move "YEAR"    to ds-year   
           move "ALBUM"   to ds-album  
           move "TITLE"   to ds-title  
           move "LENGTH"  to ds-length 

           display display-data.

