/*
          ooo
   oo    ooo
    oo  ooo
v e r y a n t
      ooo

 6390 Greenwich Drive, #225,
 San Diego, CA 92122, USA

 @COPYRIGHT@.
*/


extern void EXTFH (char* op, char* fcd);

void (*extfhFunction)(char* op, char* fcd) = EXTFH;

#ifndef EXTBYEXTFH
/*
 * This function below allows to decide at run time if a
 * particular file must be handled by the EXTFH or
 * not, basing that decision on the file name and/or the file types.
 *
 * parameters:
 * path          the name of the file; this variable is 256 bye long
 *               and can be changed by the function; in such a case
 *               the modified name is passed back to the standard
 *               isCOBOL file manager;
 * type          an integer whose content indicates the file type
 *               according to the following table:
 */
# define TYPE_INDEX             1
# define TYPE_RELATIVE          2
# define TYPE_SEQUENTIAL        3
# define TYPE_LINE_SEQUENTIAL   4
# define TYPE_OUTPUT            5
# define TYPE_INPUT             6

# define INFO_EXTFH          0x01
# define INFO_ASA            0x02

/* The following function returns a 32 bit integer with some information
 * about the file. The return value has to be interpreted as a bit mask
 * whose bits have the following meaning:
 *
 * bit 0   INFO_EXTFH   set it means that the file must be handled by EXTFH
 * bit 1   INFO_ASA     set it meand that the file is of ASA type
 *
 * This is a stub function, it must be implemented or here
 * or in the same library containing the EXTFH function.
 */
int getFileHandlingInfo (char *path, int fileType)
{
   return INFO_EXTFH;
}

/* The following function has been deprecated and it is maintained for
 * compatibility purposes only; new programs must use getFileHandlingInfo
 *
 * returns       1 if the file must be handled by the EXTFH
 *               0 if the file must be handled by isCOBOL.
 *
 * This is a stub function, it must be implemented or here
 * or in the same library containing the EXTFH function.
 */
int isFileHandledByExtfh (char *path, int fileType)
{
   return 1;
}
#endif /* EXTBYEXTFH */
