/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.preproc;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.directives.COPYEXT;
import com.veryant.cobol.compiler.directives.COPYPATH;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import com.veryant.cobol.preproc.AbstractPreprocessor;
import com.veryant.cobol.preproc.CachedCobolLine;
import com.veryant.cobol.preproc.CobolLine;
import com.veryant.cobol.preproc.InternalPreprocessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;

public class CopyPreprocessor
extends AbstractPreprocessor {
    private ArrayDeque<InternalPreprocessor> sourceStack = new ArrayDeque(20);
    private InternalPreprocessor currentSourceFile;

    private boolean isCopyRecursive(InternalPreprocessor internalPreprocessor) {
        String string = internalPreprocessor.getFilePath();
        boolean bl = Utils.isWindows();
        String string2 = this.currentSourceFile.getFilePath();
        if (bl ? string2.equalsIgnoreCase(string) : string2.equals(string)) {
            return true;
        }
        for (InternalPreprocessor internalPreprocessor2 : this.sourceStack) {
            string2 = internalPreprocessor2.getFilePath();
            if (!(bl ? string2.equalsIgnoreCase(string) : string2.equals(string))) continue;
            return true;
        }
        return false;
    }

    private String applyExtension(String string) {
        Object object = string;
        if (Utils.getExtension(string).isEmpty()) {
            String[] stringArray;
            for (String string2 : stringArray = ((COPYEXT)this.getDirectives().getDirective(63)).getExtensions()) {
                object = string;
                if (!string2.isEmpty()) {
                    object = string + "." + string2;
                }
                if (Utils.isValidFile((String)object)) break;
            }
        }
        return object;
    }

    private InternalPreprocessor createSourceFile(File file) throws IOException {
        return new InternalPreprocessor(file.getAbsolutePath(), this.getDirectives());
    }

    private File lookupCopyFile(String string) {
        String[] stringArray;
        COPYPATH cOPYPATH = (COPYPATH)this.getDirectives().getDirective(67);
        for (String string2 : stringArray = cOPYPATH.getPaths()) {
            File file = new File(string2 + string);
            if (!file.exists()) continue;
            return file;
        }
        return new File(string);
    }

    public CopyPreprocessor(String string, Directives directives) throws IOException {
        super(string, directives);
        this.currentSourceFile = new InternalPreprocessor(string, directives);
    }

    @Override
    public CachedCobolLine getLine() throws IOException {
        while (true) {
            CachedCobolLine cachedCobolLine;
            if ((cachedCobolLine = this.currentSourceFile.getLine()) != null) {
                CobolLine cobolLine = cachedCobolLine.getCobolLine();
                if (cobolLine.getType() == 6) {
                    try {
                        InternalPreprocessor internalPreprocessor = this.createSourceFile(this.lookupCopyFile(this.applyExtension(cobolLine.getText())));
                        if (this.isCopyRecursive(internalPreprocessor)) {
                            throw new COBOLCompilerException(String.format("COPY recursion detected (%s,%s), Abort.", cachedCobolLine.getSourceFile(), cachedCobolLine.getSourceLine()));
                        }
                        this.sourceStack.add(this.currentSourceFile);
                        this.currentSourceFile = internalPreprocessor;
                    }
                    catch (IOException iOException) {
                        return new CachedCobolLine(cachedCobolLine.getSourceFile(), cachedCobolLine.getSourceLine(), new CobolLine(9, String.format("Cannot access file: %s", cobolLine.getText())), cachedCobolLine.getSourceColumn(), 0);
                    }
                }
                return cachedCobolLine;
            }
            this.currentSourceFile.close();
            this.currentSourceFile = null;
            if (this.sourceStack.isEmpty()) break;
            this.currentSourceFile = this.sourceStack.pop();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.currentSourceFile != null) {
            this.currentSourceFile.close();
            for (InternalPreprocessor internalPreprocessor : this.sourceStack) {
                internalPreprocessor.close();
            }
        }
    }
}

