/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.filehandler.FileLockData;
import com.veryant.cobol.filehandler.FileLockInformation;
import com.veryant.cobol.rununit.Console;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.Hashtable;

public final class FileLockManager {
    private static final Dictionary<String, FileLockData> locks = new Hashtable<String, FileLockData>();

    private static FileLockData getLockData(File file) throws IOException {
        String string = file.getPath();
        FileLockData fileLockData = locks.get(string);
        if (fileLockData == null) {
            fileLockData = new FileLockData(file);
            locks.put(string, fileLockData);
        }
        return fileLockData;
    }

    private static void updateLocks(FileLockData fileLockData) {
        if (fileLockData != null && fileLockData.hasNoLocks()) {
            locks.remove(fileLockData.getPath().toString());
        }
    }

    public static FileLockInformation tryLockSection(RandomAccessFile randomAccessFile, File file, long l, long l2) {
        boolean bl;
        FileLockData fileLockData = null;
        try {
            fileLockData = FileLockManager.getLockData(file);
        }
        catch (IOException iOException) {
            return null;
        }
        FileLock fileLock = fileLockData.tryLockSection(randomAccessFile, l, l2);
        FileLockManager.updateLocks(fileLockData);
        boolean bl2 = bl = l == 0L && l2 == Long.MAX_VALUE;
        if (!bl) {
            return new FileLockInformation(fileLockData, true);
        }
        return new FileLockInformation(fileLockData, fileLock);
    }

    public static void unlockSection(FileLockInformation fileLockInformation) {
        fileLockInformation.getLockData().unlockSection(fileLockInformation.getFileLock());
        FileLockManager.updateLocks(fileLockInformation.getLockData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileLockInformation tryLockFile(File file) {
        FileLockData fileLockData = null;
        try {
            fileLockData = FileLockManager.getLockData(file);
            FileLockInformation fileLockInformation = new FileLockInformation(fileLockData, fileLockData.tryLockFile());
            return fileLockInformation;
        }
        catch (IOException iOException) {
            Console.writeLine(iOException);
            FileLockInformation fileLockInformation = FileLockInformation.empty;
            return fileLockInformation;
        }
        finally {
            FileLockManager.updateLocks(fileLockData);
        }
    }

    public static void unlockFile(FileLockInformation fileLockInformation) {
        fileLockInformation.getLockData().unlockFile();
        FileLockManager.updateLocks(fileLockInformation.getLockData());
    }

    private static Path getNormalizedPath(File file) throws IOException {
        return file.toPath().toAbsolutePath().toRealPath(new LinkOption[0]);
    }
}

