/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.memory;

import com.veryant.cobol.compiler.Codepage;
import com.veryant.cobol.compiler.memory.HasChunk;
import com.veryant.cobol.compiler.memory.SimpleChunk;
import java.util.Arrays;

public class Literal
extends HasChunk<SimpleChunk> {
    private final Codepage codepage;
    private final byte[] literal;

    public Codepage getCodepage() {
        return this.codepage;
    }

    public byte[] getBytes() {
        return this.literal;
    }

    public int getLiteralSize() {
        return this.literal.length;
    }

    public Literal(Codepage codepage, byte[] byArray) {
        this.codepage = codepage;
        this.literal = byArray;
    }

    public Literal(Codepage codepage, byte[] byArray, int n) {
        this.codepage = codepage;
        this.literal = Arrays.copyOf(byArray, n);
    }

    public Literal(Codepage codepage, byte[] byArray, int n, int n2) {
        this.codepage = codepage;
        this.literal = Arrays.copyOfRange(byArray, n, n2);
    }

    public Literal substring(int n, int n2) {
        Literal literal = new Literal(this.getCodepage(), this.getBytes(), n, n2);
        literal.setChunk(new SimpleChunk(((SimpleChunk)this.getChunk()).getOffset() + n, n2));
        return literal;
    }

    public int hashCode() {
        return Arrays.hashCode(this.literal);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Literal) {
            return Arrays.equals(this.literal, ((Literal)object).literal);
        }
        return false;
    }

    public String toString() {
        return new String(this.literal, this.codepage.getCharset());
    }
}

