/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.Label;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Templates;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseEmitter;
import com.veryant.cobol.compiler.stmts.Exit;
import com.veryant.cobol.compiler.types.AbstractOperand;

public abstract class ExitEmitter
extends BaseEmitter {
    public static final String T_MAIN_CHECK = "$RUT$.getCallStackSize()>1";

    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        Exit exit = (Exit)iStatement;
        switch (exit.getExitType()) {
            case Exit: {
                break;
            }
            case ExitPerform: {
                Opcodes.LOAD_CONST(jvmCode, true);
                Opcodes.IF(jvmCode);
                Opcodes.BREAK_LABEL(jvmCode, new Label(exit.getInlinePerformStatement().getLabel()));
                Opcodes.FI(jvmCode);
                break;
            }
            case ExitPerformCycle: {
                Opcodes.LOAD_CONST(jvmCode, true);
                Opcodes.IF(jvmCode);
                Opcodes.CONTINUE_LABEL(jvmCode, new Label(exit.getInlinePerformStatement().getLabel()));
                Opcodes.FI(jvmCode);
                break;
            }
            case ExitParagraph: {
                Opcodes.RET_PROC(jvmCode);
                break;
            }
            case ExitSection: {
                break;
            }
            case ExitProgram: {
                AbstractOperand abstractOperand = ((Exit)iStatement).getExitCode();
                if (abstractOperand != null) {
                    com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, abstractOperand);
                    Opcodes.CAST(jvmCode, VMType.INT64);
                    Opcodes.INJECT(jvmCode, Templates.T_STORE_RETURN_CODE);
                }
                Opcodes.INJECT(jvmCode, VMType.BOOLEAN, T_MAIN_CHECK);
                Opcodes.IF(jvmCode);
                Opcodes.RET_TFO(jvmCode);
                Opcodes.FI(jvmCode);
            }
        }
    }
}

