/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.CompilerMessage;
import com.veryant.cobol.compiler.emitters.jvm.BuiltInEmitter;
import com.veryant.cobol.compiler.emitters.jvm.builtin.AlphaNumDisplay;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Base;
import com.veryant.cobol.compiler.emitters.jvm.builtin.BooleanLiteral;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Constant;
import com.veryant.cobol.compiler.emitters.jvm.builtin.IntermediateCondition;
import com.veryant.cobol.compiler.emitters.jvm.builtin.IntermediateResult;
import com.veryant.cobol.compiler.emitters.jvm.builtin.NumericBinary;
import com.veryant.cobol.compiler.emitters.jvm.builtin.NumericDisplay;
import com.veryant.cobol.compiler.emitters.jvm.builtin.NumericEdited;
import com.veryant.cobol.compiler.emitters.jvm.builtin.NumericLiteral;
import com.veryant.cobol.compiler.emitters.jvm.builtin.StringLiteral;
import com.veryant.cobol.exceptions.COBOLCompilerException;

public abstract class Mapper {
    private static final BuiltInEmitter UNSUPPORTED = (jvmCode, abstractOperand) -> {
        throw new COBOLCompilerException(new CompilerMessage(11, abstractOperand, new Object[0]));
    };
    private static final BuiltInEmitter[][] MAP = new BuiltInEmitter[BuiltIn.values().length][];

    private static void add(BuiltIn builtIn, BuiltInEmitter builtInEmitter, BuiltInEmitter builtInEmitter2, BuiltInEmitter builtInEmitter3, BuiltInEmitter builtInEmitter4) {
        Mapper.MAP[builtIn.ordinal()] = new BuiltInEmitter[]{builtInEmitter, builtInEmitter2, builtInEmitter3, builtInEmitter4};
    }

    static BuiltInEmitter get(BuiltIn builtIn, int n) {
        BuiltInEmitter builtInEmitter = MAP[builtIn.ordinal()][n];
        return builtInEmitter != null ? builtInEmitter : UNSUPPORTED;
    }

    static {
        Mapper.add(BuiltIn.NUMERIC_LITERAL, UNSUPPORTED, NumericLiteral.LOAD, Base.LOAD_ADDRESS, Constant.STORE);
        Mapper.add(BuiltIn.STRING_LITERAL, UNSUPPORTED, StringLiteral.LOAD, Base.LOAD_ADDRESS, Constant.STORE);
        Mapper.add(BuiltIn.BOOLEAN_LITERAL, UNSUPPORTED, BooleanLiteral.LOAD, Base.LOAD_ADDRESS, Constant.STORE);
        Mapper.add(BuiltIn.ALPHA, Base.NEW, AlphaNumDisplay.LOAD, Base.LOAD_ADDRESS, AlphaNumDisplay.STORE);
        Mapper.add(BuiltIn.ALPHA_EBCDIC, Base.NEW, AlphaNumDisplay.LOAD, Base.LOAD_ADDRESS, AlphaNumDisplay.STORE);
        Mapper.add(BuiltIn.ALPHA_NUM, Base.NEW, AlphaNumDisplay.LOAD, Base.LOAD_ADDRESS, AlphaNumDisplay.STORE);
        Mapper.add(BuiltIn.ALPHA_NUM_EBCDIC, Base.NEW, AlphaNumDisplay.LOAD, Base.LOAD_ADDRESS, AlphaNumDisplay.STORE);
        Mapper.add(BuiltIn.NATIONAL, Base.NEW, AlphaNumDisplay.LOAD, Base.LOAD_ADDRESS, AlphaNumDisplay.STORE);
        Mapper.add(BuiltIn.UNSIGNED, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.UNSIGNED_EBCDIC, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING_EBCDIC, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING_EBCDIC_SIGN_ASCII, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING_SIGN_EBCDIC, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING_ACU, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING_MBP, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING_REA, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING_SEP, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.LEADING_SEP_EBCDIC, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING_EBCDIC, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING_EBCDIC_SIGN_ASCII, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING_SIGN_EBCDIC, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING_ACU, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING_MBP, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING_REA, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING_SEP, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.TRAILING_SEP_EBCDIC, Base.NEW, NumericDisplay.LOAD, Base.LOAD_ADDRESS, NumericDisplay.STORE);
        Mapper.add(BuiltIn.COMP_2_SIGNED_DECIMAL, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_2_SIGNED_DECIMAL_ACU, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_2_UNSIGNED_DECIMAL, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_3_SIGNED, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_3_SIGNED_NCR, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_3_SIGNED_ACU, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_3_UNSIGNED, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_3_UNSIGNED_VAX, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_4_SIGNED, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_4_UNSIGNED, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_4_UNSIGNED_SIGN_DROP, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_5_SIGNED, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_5_UNSIGNED, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_5_UNSIGNED_SIGN_DROP, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_X_SIGNED, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_X_UNSIGNED, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.COMP_6, Base.NEW, NumericBinary.LOAD, Base.LOAD_ADDRESS, NumericBinary.STORE);
        Mapper.add(BuiltIn.EDT_NUM_ASCII, Base.NEW, AlphaNumDisplay.LOAD, Base.LOAD_ADDRESS, NumericEdited.STORE);
        Mapper.add(BuiltIn.EDT_NUM_EBCDIC, Base.NEW, AlphaNumDisplay.LOAD, Base.LOAD_ADDRESS, NumericEdited.STORE);
        Mapper.add(BuiltIn.INTERMEDIATE_RESULT, UNSUPPORTED, IntermediateResult.LOAD, UNSUPPORTED, Constant.STORE);
        Mapper.add(BuiltIn.INTERMEDIATE_CONDITION, UNSUPPORTED, IntermediateCondition.LOAD, UNSUPPORTED, Constant.STORE);
    }
}

