/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstFileKeyReference;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstSymbol;
import com.veryant.cobol.compiler.ast.common.AstAtEnd;
import com.veryant.cobol.compiler.ast.common.AstFileReference;
import com.veryant.cobol.compiler.ast.common.AstInvalidKey;
import com.veryant.cobol.compiler.ast.common.AstNotAtEnd;
import com.veryant.cobol.compiler.ast.common.AstNotInvalidKey;
import com.veryant.cobol.compiler.ast.common.AstTo;
import com.veryant.cobol.compiler.ast.statements.AstAbstractFileIOStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.Read;

public class AstReadStatement
extends AstAbstractFileIOStatement {
    public AstReadStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        AstFileKeyReference astFileKeyReference = this.findChild(AstFileKeyReference.class);
        if (astFileKeyReference != null) {
            AstFileReference astFileReference = this.findChild(AstFileReference.class);
            astFileKeyReference.validate(astFileReference.getFile());
        }
    }

    @Override
    public void walk() {
        Read read = new Read(this.getToken());
        for (AstNode astNode : this.getChildren()) {
            if (astNode instanceof AstSymbol) {
                block0 : switch (astNode.getToken().kind) {
                    case 484: {
                        read.getData().setReadType(Read.ReadType.Next);
                        break;
                    }
                    case 549: {
                        read.getData().setReadType(Read.ReadType.Previous);
                        switch (read.getData().getFile().getOrganization()) {
                            case Relative: 
                            case Indexed: {
                                break block0;
                            }
                        }
                        this.consoleWrite(72, astNode.getToken(), read.getData().getFile().getOrganization().getDescription());
                        break;
                    }
                    case 424: {
                        read.getData().setLockMode(Read.LockMode.WithKeptLock);
                        if (read.getData().getFile().isMultipleRecordLock()) break;
                        this.consoleWrite(75, this.getToken(), new Object[0]);
                        break;
                    }
                    case 485: {
                        read.getData().setLockMode(Read.LockMode.WithNoLock);
                        break;
                    }
                    case 380: {
                        read.getData().setLockMode(Read.LockMode.WithIgnoreLock);
                        break;
                    }
                    case 450: {
                        read.getData().setLockMode(Read.LockMode.WithLock);
                        break;
                    }
                    case 812: {
                        read.getData().setLockMode(Read.LockMode.WithWait);
                    }
                }
                continue;
            }
            if (astNode instanceof AstFileReference) {
                AstFileReference astFileReference = (AstFileReference)astNode;
                FileDeclaration fileDeclaration = astFileReference.getFile();
                read.getData().setFile(fileDeclaration);
                if (fileDeclaration.getAccessMode() == FileDeclaration.AccessMode.Sequential) {
                    read.getData().setReadType(Read.ReadType.Next);
                    continue;
                }
                switch (fileDeclaration.getOrganization()) {
                    case Relative: 
                    case Indexed: {
                        read.getData().setReadType(Read.ReadType.Record);
                    }
                }
                continue;
            }
            if (astNode instanceof AstTo) {
                read.getData().setIntoOperand(astNode.getChildOperand(0));
                continue;
            }
            if (astNode instanceof AstFileKeyReference) {
                astNode.walk();
                read.getData().setKey(((AstFileKeyReference)astNode).getKey());
                continue;
            }
            if (astNode instanceof AstInvalidKey) {
                if (read.getData().getReadType() != Read.ReadType.Record) {
                    this.consoleWrite(77, astNode.getToken(), read.getData().getFile().getOrganization().getDescription());
                }
                read.getData().setFailBody(this.walkAsBranch(astNode));
                continue;
            }
            if (astNode instanceof AstNotInvalidKey) {
                if (read.getData().getReadType() != Read.ReadType.Record) {
                    this.consoleWrite(77, astNode.getToken(), read.getData().getFile().getOrganization().getDescription());
                }
                read.getData().setSuccessBody(this.walkAsBranch(astNode));
                continue;
            }
            if (astNode instanceof AstAtEnd) {
                if (read.getData().getReadType() == Read.ReadType.Record) {
                    this.consoleWrite(77, astNode.getToken(), read.getData().getFile().getOrganization().getDescription());
                }
                read.getData().setFailBody(this.walkAsBranch(astNode));
                continue;
            }
            if (!(astNode instanceof AstNotAtEnd)) continue;
            if (read.getData().getReadType() == Read.ReadType.Record) {
                this.consoleWrite(77, astNode.getToken(), read.getData().getFile().getOrganization().getDescription());
            }
            read.getData().setSuccessBody(this.walkAsBranch(astNode));
        }
        this.getCode().addStatement(read);
    }
}

