/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolDouble;
import com.iscobol.types.CobolFloat;
import com.iscobol.types.CobolNum;
import com.iscobol.types.EncBytes;
import java.math.BigDecimal;

public class CobolVP18
extends CobolNum {
    protected int lnScale;
    static final char[] zeroes = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    CobolVP18(long unscaledVal, int scale) {
        super((byte)0);
        if (scale <= 0) {
            this.lnScale = 0;
        } else {
            while (scale > 18) {
                unscaledVal /= 10L;
                --scale;
            }
            this.lnScale = scale;
        }
        this.lnUnscValue = unscaledVal;
    }

    @Override
    public float floatValue() {
        return CobolVP18.floatValue(this.lnUnscValue, this.lnScale);
    }

    @Override
    public double doubleValue() {
        return CobolVP18.doubleValue(this.lnUnscValue, this.lnScale);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.lnUnscValue, this.lnScale);
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        return BigCobolDec.valueOf(this.lnUnscValue, this.lnScale);
    }

    @Override
    public CobolNum set(long nLong, int nScale, boolean rounding) {
        this.lnUnscValue = nLong;
        this.lnScale = nScale;
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bd) {
        if (bd.scale() < 0) {
            this.lnUnscValue = bd.unscaled18Digits(0);
            this.lnScale = 0;
        } else {
            this.lnUnscValue = bd.unscaled18Digits(this.lnScale);
        }
        return this;
    }

    @Override
    public CobolNum set(double db) {
        return this.set(db, false);
    }

    public CobolNum set(double db, boolean rounded) {
        double d = db * (double)fact[this.lnScale];
        if (d >= (double)fact[18]) {
            d %= (double)fact[18];
        }
        this.lnUnscValue = (long)d;
        if (rounded) {
            if (this.lnUnscValue < 0L) {
                if (d - (double)this.lnUnscValue <= -0.5) {
                    --this.lnUnscValue;
                }
            } else if (d - (double)this.lnUnscValue >= 0.5) {
                ++this.lnUnscValue;
            }
        }
        return this;
    }

    @Override
    public CobolNum set(float fl) {
        return this.set(fl, false);
    }

    public static long floatToUnscaledLong(float f, int scale) {
        long Return2;
        int exp;
        StringBuffer sb = new StringBuffer(Float.toString(f));
        int dp = sb.indexOf(".");
        int e = sb.indexOf("E");
        if (e > 0) {
            exp = Integer.parseInt(sb.substring(e + 1));
            sb.setLength(e);
        } else {
            exp = 0;
        }
        if (scale == 0 && exp == 0) {
            Return2 = Long.parseLong(sb.substring(0, dp));
        } else {
            if (exp > 0) {
                sb.append(zeroes, 0, exp);
            }
            sb.deleteCharAt(dp);
            int sbLength = sb.length();
            int end = (dp += exp) + scale;
            if (end > sbLength) {
                sb.append(zeroes, 0, end - sbLength);
            }
            int start = dp + scale > 18 ? dp + scale - 18 : 0;
            Return2 = Long.parseLong(sb.substring(start, dp + scale));
        }
        return Return2;
    }

    public CobolNum set(float fl, boolean rounded) {
        this.lnUnscValue = this.lnScale > 0 ? CobolVP18.floatToUnscaledLong(fl, this.lnScale) : (long)fl;
        if (rounded) {
            double d = fl * (float)fact[this.lnScale];
            if (d >= (double)fact[18]) {
                d %= (double)fact[18];
            }
            if (this.lnUnscValue < 0L) {
                if (d - (double)this.lnUnscValue <= -0.5) {
                    --this.lnUnscValue;
                }
            } else if (d - (double)this.lnUnscValue >= 0.5) {
                ++this.lnUnscValue;
            }
        }
        return this;
    }

    @Override
    public CobolNum set(CobolNum val, boolean rounded, boolean lenInBytes) {
        switch (val.type) {
            case 0: {
                return this.set(((CobolVP18)val).lnUnscValue, ((CobolVP18)val).lnScale, rounded);
            }
            case 3: {
                return this.set(val.floatValue(), rounded);
            }
            case 2: {
                return this.set(val.doubleValue(), rounded);
            }
            case 1: {
                return this.set(val.bigCobDecValue().setScale(this.lnScale, rounded ? 1 : 0));
            }
        }
        return null;
    }

    @Override
    public CobolNum add(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolVP18.addLn(this.lnUnscValue, this.lnScale, ((CobolVP18)val).lnUnscValue, ((CobolVP18)val).lnScale);
            }
            case 3: {
                return new CobolFloat((float)((double)this.lnUnscValue / factDouble[this.lnScale]) + val.floatValue());
            }
            case 2: {
                return new CobolDouble((double)this.lnUnscValue / factDouble[this.lnScale] + val.doubleValue());
            }
            case 1: {
                return this.addBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue());
            }
        }
        return null;
    }

    @Override
    public void addToMe(short i) {
        this.lnUnscValue = (short)this.lnUnscValue + i;
    }

    @Override
    public void subFromMe(short i) {
        this.lnUnscValue = (short)this.lnUnscValue - i;
    }

    @Override
    public void multiplyByMe(short i) {
        this.lnUnscValue = (short)this.lnUnscValue * i;
    }

    @Override
    public CobolNum multiply36(CobolNum val) {
        return this.multiply(val);
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, short i) {
        if (i == 0) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.lnUnscValue = (short)this.lnUnscValue / i;
        }
    }

    @Override
    public void divideIntoMeByZero(boolean checkdivbyzero) throws DivideByZeroException {
        int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
        switch (v) {
            default: {
                this.lnUnscValue = Long.MAX_VALUE;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.lnUnscValue = 0L;
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                this.lnUnscValue = Long.MAX_VALUE;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.lnUnscValue = 0L;
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public void addToMe(int i) {
        this.lnUnscValue = (int)this.lnUnscValue + i;
    }

    @Override
    public void subFromMe(int i) {
        this.lnUnscValue = (int)this.lnUnscValue - i;
    }

    @Override
    public void multiplyByMe(int i) {
        this.lnUnscValue = (int)this.lnUnscValue * i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, int i) {
        if (i == 0) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.lnUnscValue = (int)this.lnUnscValue / i;
        }
    }

    @Override
    public void addToMe(long i) {
        this.lnUnscValue += i;
    }

    @Override
    public void subFromMe(long i) {
        this.lnUnscValue -= i;
    }

    @Override
    public void multiplyByMe(long i) {
        this.lnUnscValue *= i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, long i) {
        if (i == 0L) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.lnUnscValue /= i;
        }
    }

    @Override
    public CobolNum add1() {
        return CobolVP18.addLn(this.lnUnscValue, this.lnScale, 1L, 0);
    }

    @Override
    public CobolNum subtract(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolVP18.addLn(this.lnUnscValue, this.lnScale, -val.lnUnscValue, val.scale());
            }
            case 3: {
                return new CobolFloat((float)((double)this.lnUnscValue / factDouble[this.lnScale]) - val.floatValue());
            }
            case 2: {
                return new CobolDouble((double)this.lnUnscValue / factDouble[this.lnScale] - val.doubleValue());
            }
            case 1: {
                return this.addBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue().negate());
            }
        }
        return null;
    }

    @Override
    public CobolNum subtract1() {
        return CobolVP18.addLn(this.lnUnscValue, this.lnScale, -1L, 0);
    }

    @Override
    public CobolNum multiply(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolVP18.multiplyLn(this.lnUnscValue, this.lnScale, ((CobolVP18)val).lnUnscValue, ((CobolVP18)val).lnScale);
            }
            case 3: {
                return new CobolFloat((float)((double)this.lnUnscValue / factDouble[this.lnScale]) * val.floatValue());
            }
            case 2: {
                return new CobolDouble((double)this.lnUnscValue / factDouble[this.lnScale] * val.doubleValue());
            }
            case 1: {
                return this.multiplyBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum divide(boolean checkdivbyzero, CobolNum val, int scale, boolean rounding) {
        switch (val.type) {
            case 0: {
                return CobolVP18.divideLn(checkdivbyzero, this.lnUnscValue, this.lnScale, ((CobolVP18)val).lnUnscValue, ((CobolVP18)val).lnScale, scale, rounding);
            }
            case 3: {
                return new CobolFloat((float)((double)this.lnUnscValue / factDouble[this.lnScale]) / val.floatValue());
            }
            case 2: {
                return new CobolDouble((double)this.lnUnscValue / factDouble[this.lnScale] / val.doubleValue());
            }
            case 1: {
                return CobolVP18.divideBd(checkdivbyzero, new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue(), scale, rounding);
            }
        }
        return null;
    }

    @Override
    public void toCobolByteArray(byte[] Return2, int len, byte[] encoded_digits) {
        int idx;
        long val = this.lnUnscValue < 0L ? -this.lnUnscValue : this.lnUnscValue;
        int digits = CobolVP18.getNumDigits(val);
        int zeros = len - digits;
        for (idx = 0; idx < zeros; ++idx) {
            Return2[idx] = EncBytes.C_0;
        }
        int i = digits - 1;
        while (zeros < 0) {
            val %= fact[i];
            ++zeros;
            --i;
        }
        while (idx < len) {
            Return2[idx++] = encoded_digits[(int)(val / fact[i])];
            val %= fact[i];
            --i;
        }
    }

    @Override
    public int toByteArray(byte[] Return2) {
        return CobolVP18.toByteArray(this.lnUnscValue, this.lnScale, Return2);
    }

    @Override
    public boolean isOverflow(CobolNum dest, int destIntPart) {
        switch (dest.type) {
            case 0: {
                int tot = destIntPart + this.lnScale;
                if (tot > 18) {
                    return false;
                }
                if (this.lnUnscValue < 0L) {
                    return this.lnUnscValue < factMin[tot];
                }
                return this.lnUnscValue > factMax[tot];
            }
            case 1: {
                int tot = destIntPart + this.lnScale;
                if (tot > 18) {
                    return false;
                }
                if (this.lnUnscValue < 0L) {
                    return this.lnUnscValue < factMin[tot];
                }
                return this.lnUnscValue > factMax[tot];
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum dest, int nBytes, boolean signed) {
        switch (dest.type) {
            case 0: {
                if (nBytes <= 8) {
                    return CobolVP18.isLongOverflowByte(this.lnUnscValue, nBytes, signed, this.lnScale - dest.scale());
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int compareTo(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolVP18.compareLn(this.lnUnscValue, this.lnScale, val.lnUnscValue, val.scale());
            }
            case 3: {
                float fDiff = this.floatValue() - val.floatValue();
                if (fDiff < 0.0f) {
                    return -1;
                }
                if (fDiff > 0.0f) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                double dDiff = this.doubleValue() - val.doubleValue();
                if (dDiff < 0.0) {
                    return -1;
                }
                if (dDiff > 0.0) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                return this.compareBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue());
            }
        }
        return 0;
    }

    @Override
    public int compareTo(long val, int scale) {
        return CobolVP18.compareLn(this.lnUnscValue, this.lnScale, val, scale);
    }

    @Override
    public long getUnscaledLong(boolean[] overflow) {
        overflow[0] = false;
        return this.lnUnscValue;
    }

    @Override
    public long getUnscaledLong() {
        return this.lnUnscValue;
    }

    @Override
    public void toBinaryByteArray(Memory Return2, int start, int len) {
        if (this.lnUnscValue >= 0L) {
            while (len > 8) {
                Return2.put(start++, (byte)0);
                --len;
            }
        } else {
            while (len > 8) {
                Return2.put(start++, (byte)-1);
                --len;
            }
        }
        for (int i = len - 1; i > 0; --i) {
            Return2.put(start++, (byte)(this.lnUnscValue >>> (i << 3)));
        }
        Return2.put(start, (byte)(this.lnUnscValue & 0xFFL));
    }

    @Override
    public void toBinaryByteArray(byte[] Return2, int start, int len) {
        if (this.lnUnscValue >= 0L) {
            while (len > 8) {
                Return2[start++] = 0;
                --len;
            }
        } else {
            while (len > 8) {
                Return2[start++] = -1;
                --len;
            }
        }
        for (int i = len - 1; i > 0; --i) {
            Return2[start++] = (byte)(this.lnUnscValue >>> (i << 3));
        }
        Return2[start] = (byte)(this.lnUnscValue & 0xFFL);
    }

    @Override
    public void setSizeDigit(int intPart, int decPart) {
        this.lnUnscValue %= fact[intPart + decPart];
    }

    @Override
    public void setSizeByteUnsigned(int nBytes) {
        this.lnUnscValue &= factBytes[nBytes][0];
    }

    @Override
    public void setSizeByteSigned(int nBytes) {
        if ((this.lnUnscValue & factBytes[nBytes][3]) != 0L) {
            this.lnUnscValue &= factBytes[nBytes][1];
            this.lnUnscValue |= factBytes[nBytes][2];
        } else {
            this.lnUnscValue &= factBytes[nBytes][1];
        }
    }

    @Override
    public void setScale(int scale, boolean rounding, boolean lenInBytes) {
        this.lnUnscValue = CobolVP18.computeUnscValue(this.lnUnscValue, this.lnScale, scale, rounding, lenInBytes);
        this.lnScale = scale;
    }

    @Override
    public final void roundUpIfNeeded(int scaleDiff) {
        this.lnUnscValue = CobolVP18.roundUpIfNeeded(this.lnUnscValue, scaleDiff);
    }

    @Override
    public int scale() {
        return this.lnScale;
    }

    @Override
    public int precision() {
        return CobolVP18.getNumDigits(this.lnUnscValue);
    }

    @Override
    public int signum() {
        if (this.lnUnscValue > 0L) {
            return 1;
        }
        if (this.lnUnscValue < 0L) {
            return -1;
        }
        return 0;
    }

    @Override
    public void negateMe() {
        this.lnUnscValue = -this.lnUnscValue;
    }

    @Override
    public CobolNum negate() {
        return new CobolVP18(-this.lnUnscValue, this.lnScale);
    }

    @Override
    public void shift(int tenExp) {
        this.lnUnscValue = tenExp < 0 ? (this.lnUnscValue /= fact[-tenExp]) : (this.lnUnscValue *= fact[tenExp]);
    }

    @Override
    public String toString() {
        String Return2;
        if (this.lnScale == 0) {
            Return2 = Long.toString(this.lnUnscValue);
        } else {
            boolean sign;
            if (this.lnUnscValue < 0L) {
                Return2 = Long.toString(-this.lnUnscValue);
                sign = true;
            } else {
                Return2 = Long.toString(this.lnUnscValue);
                sign = false;
            }
            int strLen = Return2.length() - this.lnScale;
            if (strLen > 0) {
                Return2 = Return2.substring(0, strLen) + "." + Return2.substring(strLen);
            } else {
                while (Return2.length() < this.lnScale) {
                    Return2 = "0" + Return2;
                }
                Return2 = "0." + Return2;
            }
            if (sign) {
                Return2 = "-" + Return2;
            }
        }
        return Return2;
    }

    @Override
    public int shortValue() {
        return (short)(this.lnUnscValue / fact[this.lnScale]);
    }

    @Override
    public int intValue() {
        return (int)(this.lnUnscValue / fact[this.lnScale]);
    }

    @Override
    public long longValue() {
        return this.lnUnscValue / fact[this.lnScale];
    }

    @Override
    public int shortValue(boolean rounding) {
        if (rounding && this.lnScale > 0) {
            return (short)(CobolVP18.roundUpIfNeeded(this.lnUnscValue, this.lnScale) / fact[this.lnScale]);
        }
        return (short)(this.lnUnscValue / fact[this.lnScale]);
    }

    @Override
    public int intValue(boolean rounding) {
        if (rounding && this.lnScale > 0) {
            return (int)(CobolVP18.roundUpIfNeeded(this.lnUnscValue, this.lnScale) / fact[this.lnScale]);
        }
        return (int)(this.lnUnscValue / fact[this.lnScale]);
    }

    @Override
    public long longValue(boolean rounding) {
        if (rounding && this.lnScale > 0) {
            return CobolVP18.roundUpIfNeeded(this.lnUnscValue, this.lnScale) / fact[this.lnScale];
        }
        return this.lnUnscValue / fact[this.lnScale];
    }

    @Override
    public CobolNum integerFunc() {
        long lval = this.lnUnscValue / fact[this.lnScale];
        if (this.lnUnscValue >= 0L || this.lnUnscValue % fact[this.lnScale] == 0L) {
            return new CobolVP18(lval, 0);
        }
        return new CobolVP18(--lval, 0);
    }

    @Override
    public CobolNum integerPart() {
        return new CobolVP18(this.lnUnscValue / fact[this.lnScale], 0);
    }
}

