/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.TreeSet;

public class SetDataColumns
extends PrintCommand {
    private int[] myCols;

    private static int[] normalizeAndSort(int[] a) {
        if (a == null || a.length == 0) {
            return null;
        }
        TreeSet<Integer> l = new TreeSet<Integer>();
        for (int i : a) {
            if (i <= 1) continue;
            l.add(i);
        }
        if (l.size() == 0) {
            return null;
        }
        if (l.size() == 1) {
            return new int[]{(Integer)l.iterator().next()};
        }
        int[] ret = new int[l.size()];
        int i = 0;
        for (Integer I2 : l) {
            ret[i++] = I2;
        }
        return ret;
    }

    public SetDataColumns(GuiFactory gf, int[] classCols, int[] cols) {
        super(gf, 8);
        if (classCols == null || cols == null) {
            this.myCols = SetDataColumns.normalizeAndSort(cols);
        } else {
            int i;
            this.myCols = new int[classCols.length + cols.length];
            for (i = 0; i < classCols.length; ++i) {
                this.myCols[i] = classCols[i];
            }
            for (int j = 0; j < cols.length; ++j) {
                this.myCols[i] = cols[j];
                ++i;
            }
            this.myCols = SetDataColumns.normalizeAndSort(this.myCols);
        }
    }

    public SetDataColumns(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 8);
        int dim = inOut.readInt();
        if (dim >= 0) {
            this.myCols = new int[dim];
            for (int i = 0; i < this.myCols.length; ++i) {
                this.myCols[i] = inOut.readInt();
            }
        }
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        if (this.myCols != null) {
            inOut.writeInt(this.myCols.length);
            for (int i = 0; i < this.myCols.length; ++i) {
                inOut.writeInt(this.myCols[i]);
            }
        } else {
            inOut.writeInt(-1);
        }
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, g2d, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        pc.dataCols = this.getCols();
        return true;
    }

    int[] getCols() {
        int[] dataCols;
        if (this.myCols != null) {
            dataCols = new int[this.myCols.length];
            System.arraycopy(this.myCols, 0, dataCols, 0, this.myCols.length);
        } else {
            dataCols = null;
        }
        return dataCols;
    }
}

