/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.FactoryData;
import com.iscobol.rts.Finalizable;
import com.iscobol.rts.FinalizableBefore;
import com.iscobol.rts.ICoverage;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class IscobolSystem
implements RuntimeErrorsNumbers {
    private static boolean isAS;
    private static ICoverage coverage;
    private static boolean unitTest;
    private static HashSet _loadedClasses;
    private static ConcurrentHashMap threads;

    public static void setLoaded(Class c) {
        _loadedClasses.add(c.getName());
    }

    public static boolean isLoadedClass(String bName) {
        return _loadedClasses.contains(bName);
    }

    private static synchronized ConcurrentHashMap getConcurrentHashMap(Thread thr) {
        return (ConcurrentHashMap)threads.get(thr);
    }

    private static synchronized ConcurrentHashMap getConcurrentHashMap() {
        Thread ct = Thread.currentThread();
        ConcurrentHashMap Return2 = (ConcurrentHashMap)threads.get(ct);
        if (Return2 == null) {
            Return2 = new Context((Object)null);
            threads.put(ct, Return2);
        }
        return Return2;
    }

    public static synchronized void duplicateEnv(Thread src, Thread dst) {
        ConcurrentHashMap ht;
        if (threads.get(dst) == null && (ht = (ConcurrentHashMap)threads.get(src)) != null) {
            threads.put(dst, ht);
        }
    }

    public static synchronized void duplicateEnv(Thread t) {
        IscobolSystem.duplicateEnv(Thread.currentThread(), t);
    }

    public static synchronized void duplicateVar(Class key, Thread t) {
        Object value = IscobolSystem.get(key);
        if (value != null) {
            ConcurrentHashMap ht = (ConcurrentHashMap)threads.get(t);
            if (ht == null) {
                ht = new Context((Object)null);
                threads.put(t, ht);
            }
            ht.put(key, value);
        }
    }

    public static synchronized ConcurrentHashMap destroyEnv(Thread t) {
        ConcurrentHashMap Return2;
        block2: {
            Return2 = null;
            try {
                Return2 = (ConcurrentHashMap)threads.remove(t);
            }
            catch (ThreadDeath _ex) {
                if (Return2 != null) break block2;
                Return2 = (ConcurrentHashMap)threads.remove(t);
            }
        }
        return Return2;
    }

    public static boolean destroyAndFinalizeEnv(Thread t) {
        ConcurrentHashMap ht = IscobolSystem.getConcurrentHashMap(t);
        if (ht != null) {
            Object o;
            String threadName = Config.markNoIscobolRuntimeThread();
            Enumeration e = ht.elements();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                if (o == null || !(o instanceof FinalizableBefore) || !(o instanceof Finalizable)) continue;
                ((Finalizable)o).myFinalize();
            }
            e = ht.elements();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                if (o == null || !(o instanceof Finalizable)) continue;
                ((Finalizable)o).myFinalize();
            }
            Thread.currentThread().setName(threadName);
            IscobolSystem.destroyEnv(t);
            return true;
        }
        return false;
    }

    public static void set(Class key, Object value) {
        IscobolSystem.getConcurrentHashMap().put(key, value);
    }

    public static Object get(Class key) {
        return IscobolSystem.getConcurrentHashMap().get(key);
    }

    public static Object get(Thread thr, Class key) {
        ConcurrentHashMap hs = IscobolSystem.getConcurrentHashMap(thr);
        if (hs != null) {
            return hs.get(key);
        }
        return null;
    }

    public static Object getIfExists(Class key, Thread ct) {
        ConcurrentHashMap ht = (ConcurrentHashMap)threads.get(ct);
        if (ht != null) {
            return ht.get(key);
        }
        return null;
    }

    public static Object remove(Class key) {
        return IscobolSystem.getConcurrentHashMap().remove(key);
    }

    public static synchronized boolean removeThread(Thread tt) {
        return threads.remove(tt) != null;
    }

    public static synchronized void removeThreadFamily(Vector thv) {
        for (int i = thv.size() - 1; i >= 0; --i) {
            threads.remove(thv.elementAt(i));
        }
    }

    public static synchronized Vector getThreadFamily(Thread tt) {
        Vector<Thread> Return2 = new Vector<Thread>();
        ConcurrentHashMap ht = (ConcurrentHashMap)threads.get(tt);
        if (ht != null) {
            Return2.addElement(tt);
            Enumeration en = threads.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                if (threads.get(key) != ht) continue;
                Return2.addElement((Thread)key);
            }
        }
        return Return2;
    }

    public static String info(String eol) {
        ConcurrentHashMap ht = threads;
        ByteArrayOutputStream Return2 = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(Return2);
        ps.print(eol);
        ps.print("==>>IscobolSystem ThreadFamilies List");
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            ps.print(eol);
            ps.print(" =>>key [" + k + "]" + k.getClass());
            Exception e = (Exception)((ConcurrentHashMap)ht.get(k)).get(Exception.class);
            if (e == null) continue;
            ps.print(eol);
            e.printStackTrace(ps);
        }
        return Return2.toString();
    }

    public static void setContext(Context ctx, Object xInfo) {
        if (ctx == null) {
            ctx = new Context(xInfo);
        }
        ctx.thd = Thread.currentThread();
        ctx.ctx = threads.get(ctx.thd);
        threads.put(ctx.thd, ctx);
    }

    public static void setContext(Context ctx) {
        IscobolSystem.setContext(ctx, null);
    }

    public static Context unsetContext() {
        Context Return2 = (Context)threads.remove(Thread.currentThread());
        if (Return2 != null && Return2.ctx != null) {
            threads.put(Return2.thd, Return2.ctx);
        }
        return Return2;
    }

    public static Context getContext() {
        return (Context)IscobolSystem.getConcurrentHashMap();
    }

    public static Object getContextExtraInfo() {
        Object ctx = threads.get(Thread.currentThread());
        if (ctx instanceof Context) {
            return ((Context)ctx).extraInfo;
        }
        return null;
    }

    public static void setAS(boolean as) {
        isAS = as;
    }

    public static boolean isAS() {
        return isAS;
    }

    public static ICoverage getCoverage() {
        return coverage;
    }

    public static void setCoverage(ICoverage coverage) {
        IscobolSystem.coverage = coverage;
    }

    public static boolean isUnitTest() {
        return unitTest;
    }

    public static void setUnitTest(boolean unitTest) {
        IscobolSystem.unitTest = unitTest;
    }

    public static void debug() {
        Enumeration e = threads.keys();
        System.out.println("-->Threads<--");
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
        System.out.println("-->End Thr<--");
    }

    public static synchronized void resetSystemResources(String resPropName, String resPropValue) {
        for (Object v : threads.values()) {
            Config c;
            ConcurrentHashMap map = (ConcurrentHashMap)v;
            FactoryData fd = (FactoryData)map.get(FactoryData.class);
            if (fd != null) {
                fd.resource = null;
                fd.systemResource = null;
            }
            if ((c = (Config)map.get(Config.class)) == null) continue;
            Config.setProperty(c, resPropName, resPropValue, false);
        }
    }

    static {
        _loadedClasses = new HashSet();
        threads = new Context((Object)null);
    }

    public static class Context
    extends ConcurrentHashMap {
        Thread thd;
        Object ctx;
        public final Object extraInfo;

        Context(Object xInfo) {
            this.extraInfo = xInfo;
        }

        public void finalize() {
            if (this.size() > 0) {
                IscobolSystem.setContext(this);
                this.ctx = null;
                IscobolSystem.unsetContext();
            }
        }
    }
}

