/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.issort;

import com.iscobol.types.NumericVar;

public class RpnEvaluator {
    static final int[] fixedRight = new int[255];
    final byte[] colSeq;
    private final Condition[] condStack;
    private final boolean[] results;
    private int nItems;

    public RpnEvaluator(int size, byte[] cs) {
        if (cs == null) {
            this.colSeq = new byte[255];
            for (int i = 0; i < 255; ++i) {
                this.colSeq[i] = (byte)i;
            }
        } else {
            this.colSeq = cs;
        }
        this.condStack = new Condition[size];
        this.results = new boolean[size > 0 ? size : 1];
        this.results[0] = true;
    }

    public void addAnd() {
        this.condStack[this.nItems++] = new And();
    }

    public void addByteCompare(byte[] lRec, int lOffs, Operator op, byte[] rRec, int rOffs, int len) {
        this.condStack[this.nItems++] = new ByteCompare(lRec, lOffs, op, rRec, rOffs, len);
    }

    public void addSubstringSearch(byte[] txt, int tOff, int tLen, Operator op, byte[] pat, int pOff, int pLen) {
        this.condStack[this.nItems++] = new SubstringSearch(txt, tOff, tLen, op, pat, pOff, pLen);
    }

    public void addSubstringFaster(byte[] txt, int tOff, int tLen, Operator op, byte[] pat) {
        this.condStack[this.nItems++] = new SubstringFaster(txt, tOff, tLen, op, pat);
    }

    public void addVarCompare(NumericVar lVar, Operator op, NumericVar rVar) {
        this.condStack[this.nItems++] = new VarCompare(lVar, op, rVar);
    }

    public void addVarIntCompare(NumericVar lVar, Operator op, long rVar) {
        this.condStack[this.nItems++] = new VarIntCompare(lVar, op, rVar);
    }

    public void addOr() {
        this.condStack[this.nItems++] = new Or();
    }

    public boolean evaluate() {
        int resultsIdx = 0;
        block10: for (int i = 0; i < this.nItems; ++i) {
            Condition cond = this.condStack[i];
            switch (cond.op) {
                case EQ: {
                    this.results[resultsIdx++] = cond.evaluate() == 0;
                    continue block10;
                }
                case NE: {
                    this.results[resultsIdx++] = cond.evaluate() != 0;
                    continue block10;
                }
                case GT: {
                    this.results[resultsIdx++] = cond.evaluate() > 0;
                    continue block10;
                }
                case LT: {
                    this.results[resultsIdx++] = cond.evaluate() < 0;
                    continue block10;
                }
                case GE: {
                    this.results[resultsIdx++] = cond.evaluate() >= 0;
                    continue block10;
                }
                case LE: {
                    this.results[resultsIdx++] = cond.evaluate() <= 0;
                    continue block10;
                }
                case AND: {
                    resultsIdx -= 2;
                    int n = resultsIdx++;
                    this.results[n] = this.results[n] & this.results[resultsIdx];
                    continue block10;
                }
                case OR: {
                    resultsIdx -= 2;
                    int n = resultsIdx++;
                    this.results[n] = this.results[n] | this.results[resultsIdx];
                }
            }
        }
        return this.results[0];
    }

    static {
        for (int i = 0; i < fixedRight.length; ++i) {
            RpnEvaluator.fixedRight[i] = -1;
        }
    }

    public class VarIntCompare
    extends Condition {
        private final NumericVar lVar;
        private final long rVar;

        public VarIntCompare(NumericVar lVar, Operator op, long rVar) {
            super(op);
            this.lVar = lVar;
            this.rVar = rVar;
        }

        @Override
        int evaluate() {
            long diff = this.lVar.tolong() - this.rVar;
            if (diff == 0L) {
                return 0;
            }
            if (diff > 0L) {
                return 1;
            }
            return -1;
        }
    }

    public class VarCompare
    extends Condition {
        private final NumericVar lVar;
        private final NumericVar rVar;

        public VarCompare(NumericVar lVar, Operator op, NumericVar rVar) {
            super(op);
            this.lVar = lVar;
            this.rVar = rVar;
        }

        @Override
        int evaluate() {
            return this.lVar.compareTo(this.rVar);
        }
    }

    public class SubstringFaster
    extends SubstringSearch {
        public SubstringFaster(byte[] txt, int tOff, int tLen, Operator op, byte[] pat) {
            super(txt, tOff, tLen, op, pat, 0, pat.length);
            System.arraycopy(fixedRight, 0, this.right, 0, fixedRight.length);
            for (int i = 0; i < pat.length; ++i) {
                this.right[pat[i]] = i;
            }
        }

        @Override
        final int evaluate() {
            return this.intEvaluate();
        }
    }

    public class SubstringSearch
    extends Condition {
        private final byte[] txt;
        private final int tOff;
        private final int tLen;
        private final byte[] pat;
        private final int pOff;
        private final int pLen;
        int[] right;
        private final int myTRUE;
        private final int myFALSE;

        public SubstringSearch(byte[] txt, int tOff, int tLen, Operator op, byte[] pat, int pOff, int pLen) {
            super(op);
            this.right = new int[255];
            this.txt = txt;
            this.tOff = tOff;
            this.tLen = tLen;
            this.pat = pat;
            this.pOff = pOff;
            this.pLen = pLen;
            if (op == Operator.EQ) {
                this.myTRUE = 0;
                this.myFALSE = -1;
            } else {
                this.myTRUE = -1;
                this.myFALSE = 0;
            }
        }

        @Override
        int evaluate() {
            System.arraycopy(fixedRight, 0, this.right, 0, fixedRight.length);
            for (int i = 0; i < this.pLen; ++i) {
                this.right[this.pat[this.pOff + i]] = i;
            }
            return this.intEvaluate();
        }

        final int intEvaluate() {
            int Return2 = this.myFALSE;
            int shift = 1;
            int iEnd = this.tOff + this.tLen - this.pLen + 1;
            for (int i = this.tOff; i < iEnd; i += shift) {
                int j = this.pOff + this.pLen - 1;
                int k = i + this.pLen - 1;
                while (j >= this.pOff) {
                    if (this.txt[k] != this.pat[j]) {
                        shift = j - this.pOff - this.right[this.txt[k]];
                        if (shift >= 1) break;
                        shift = 1;
                        break;
                    }
                    --j;
                    --k;
                }
                if (j >= this.pOff) continue;
                Return2 = this.myTRUE;
                break;
            }
            return Return2;
        }
    }

    public class ByteCompare
    extends Condition {
        private final byte[] lRec;
        private final int lOffs;
        private final byte[] rRec;
        private final int rOffs;
        private final int len;

        public ByteCompare(byte[] lRec, int lOffs, Operator op, byte[] rRec, int rOffs, int len) {
            super(op);
            this.lRec = lRec;
            this.lOffs = lOffs;
            this.rRec = rRec;
            this.rOffs = rOffs;
            this.len = len;
        }

        @Override
        int evaluate() {
            int e1 = this.lOffs + this.len;
            int li = this.lOffs;
            int ri = this.rOffs;
            while (li < e1) {
                int d = RpnEvaluator.this.colSeq[this.lRec[li] & 0xFF] - RpnEvaluator.this.colSeq[this.rRec[ri] & 0xFF];
                if (d != 0) {
                    return d;
                }
                ++li;
                ++ri;
            }
            return 0;
        }
    }

    public class Or
    extends Condition {
        public Or() {
            super(Operator.OR);
        }

        @Override
        int evaluate() {
            return 0;
        }
    }

    public class And
    extends Condition {
        public And() {
            super(Operator.AND);
        }

        @Override
        int evaluate() {
            return 0;
        }
    }

    public abstract class Condition {
        final Operator op;

        Condition(Operator op) {
            this.op = op;
        }

        abstract int evaluate();
    }

    public static enum Operator {
        EQ,
        NE,
        GT,
        LT,
        GE,
        LE,
        AND,
        OR;

    }
}

