/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.issort;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DynamicJavaSort;
import com.iscobol.io.IndexFile;
import com.iscobol.io.LineSequentialDFile;
import com.iscobol.io.RelativeDFile;
import com.iscobol.io.SeqVarLenFile;
import com.iscobol.io.SequentialDFile;
import com.iscobol.issort.RpnEvaluator;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.rts.DynamicSort;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.SortKey;
import com.iscobol.rts.SortKeyItem;
import com.iscobol.rts.VarType;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.Pic9Comp_3;
import com.iscobol.types.Pic9Comp_4;
import com.iscobol.types.Pic9Comp_5;
import com.iscobol.types.Pic9Comp_6;
import com.iscobol.types.PicDisplay;
import com.iscobol.types.PicNativeFloat;
import com.iscobol.types.PicX;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class IsSort
implements VarType {
    public static final int COMP_OPT = 66;
    private static final int PRIO_MIN = 0;
    private static final int PRIO_OR = 3;
    private static final int PRIO_AND = 6;
    private static final int PRIO_CLOSEPAR = 99;
    private static final int TYPE_UNKNOWN = -1;
    private static final int TYPE_SS = -2;
    private final ArrayDeque<String> tokens;
    private final ArrayList<FileDesc> use = new ArrayList();
    private final ArrayList<FileDesc> give = new ArrayList();
    private ArrayDeque<CondDesc> rpnCond = new ArrayDeque();
    private FileDesc lastFile;
    private Error _errorCode = Error.SORT000U;
    private String _errorDesc;
    private int cobErrno;
    private boolean merge;
    private int maxRecLenFound;
    private final SortKey sortFields = new SortKey();
    private DynamicSort sortImpl;
    private PicX sortRecord;
    private String sortPath = "";
    private boolean include;
    private boolean omit;
    private int condFormat = 1;

    public IsSort(Reader in) {
        this.tokens = IsSort.tokenizer(in);
        try {
            this.parse();
        }
        catch (NoSuchElementException _ex) {
            this.setErrorCode(Error.SORT015U, "unexpected commands end");
            return;
        }
        if (this.hasErrors()) {
            return;
        }
        if (this.maxRecLenFound <= 0) {
            this.setErrorCode(Error.SORT015U, "no record description found");
            return;
        }
        this.process();
    }

    private boolean setErrorCode(Error e, String desc) {
        this._errorCode = e;
        this._errorDesc = desc;
        return false;
    }

    public boolean hasErrors() {
        return this._errorCode.code != 0;
    }

    public Error getErrorCode() {
        return this._errorCode;
    }

    public String getErrorDesc() {
        return this._errorDesc;
    }

    public void buildFileArray(ArrayList<FileDesc> fdl, CobolFile[] files, ICobolVar[] names) {
        int i = 0;
        for (FileDesc fd : fdl) {
            if (fd.recMax == 0) {
                fd.recMax = this.maxRecLenFound;
                fd.recLen = this.maxRecLenFound;
            }
            CobolVarHelper cvh = new CobolVarHelper("all", 66).picX("record", fd.recMax).picX("name", fd.name.length());
            ICobolVar rec = cvh.get("record");
            ICobolVar name = cvh.get("name");
            name.set(fd.name);
            names[i] = name;
            switch (fd.org) {
                case 1: {
                    files[i] = new IndexFile(fd.name, fd.recMax, rec, fd.recLen, false, 1);
                    if (fd.keys.size() <= 0) break;
                    int size = fd.keys.size();
                    PicX[] seg = new PicX[size];
                    int j = 0;
                    boolean dup = false;
                    for (KeyDesc kd : fd.keys) {
                        if (kd.type != 5) {
                            if (j > 0) {
                                CobolVar[] key = new PicX[j];
                                for (int k = 0; k < j; ++k) {
                                    key[k] = seg[k];
                                }
                                files[i].key(key, dup);
                                j = 0;
                            }
                            dup = kd.type == 2 || kd.type == 4;
                        }
                        seg[j++] = new PicX((byte[])null, kd.offset, kd.length, null, null, null, false, false);
                    }
                    CobolVar[] key = new PicX[j];
                    for (int k = 0; k < j; ++k) {
                        key[k] = seg[k];
                    }
                    files[i].key(key, dup);
                    break;
                }
                case 2: {
                    files[i] = new RelativeDFile(fd.name, fd.recMax, rec, fd.recLen, false, 1);
                    break;
                }
                case 3: {
                    if (fd.recLen == fd.recMax) {
                        files[i] = new SequentialDFile(fd.name, fd.recMax, rec, fd.recLen, false, 1);
                        break;
                    }
                    files[i] = new SeqVarLenFile(fd.name, fd.recMax, rec, fd.recLen, false);
                    break;
                }
                case 4: {
                    files[i] = new LineSequentialDFile(fd.name, fd.recMax, rec, fd.recLen, false, 1);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown file type " + fd.org);
                }
            }
            ++i;
        }
    }

    public void initSort() {
        int rc;
        this.sortRecord = new PicX(new byte[this.maxRecLenFound], 0, this.maxRecLenFound, null, null, null, false, false);
        this.sortImpl = new DynamicJavaSort();
        CobolFile[] using = new CobolFile[this.use.size()];
        ICobolVar[] uNames = new ICobolVar[this.use.size()];
        CobolFile[] giving = new CobolFile[this.give.size()];
        ICobolVar[] gNames = new ICobolVar[this.give.size()];
        if (using.length > 0) {
            this.buildFileArray(this.use, using, uNames);
        }
        if (giving.length > 0) {
            this.buildFileArray(this.give, giving, gNames);
        }
        if (this.omit || this.include) {
            try {
                if (this.merge) {
                    this.sortImpl.initMerge(this.sortPath, this.sortRecord, this.sortFields, null, null, giving, gNames);
                } else {
                    this.sortImpl.initSort(this.sortPath, this.sortRecord, this.sortFields, null, null, giving, gNames);
                }
                rc = this.processFiles(using, uNames);
            }
            catch (CobolIOException ex) {
                rc = 0;
                this.setErrorCode(Error.SORT100U, ex.getMessage());
            }
        } else {
            try {
                rc = this.merge ? this.sortImpl.initMerge(this.sortPath, this.sortRecord, this.sortFields, using, uNames, giving, gNames) : this.sortImpl.initSort(this.sortPath, this.sortRecord, this.sortFields, using, uNames, giving, gNames);
            }
            catch (CobolIOException ex) {
                rc = 0;
                this.setErrorCode(Error.SORT100U, ex.getMessage());
            }
        }
        if (rc != 1) {
            this.setErrorCode(Error.SORT100U, "system error: permanent I/O error");
        }
    }

    private int processFiles(CobolFile[] using, ICobolVar[] uNames) {
        RpnEvaluator eval = new RpnEvaluator(this.rpnCond.size(), null);
        int Return2 = 1;
        for (CondDesc cd : this.rpnCond) {
            byte[] lRec;
            if (cd.op == 10) {
                eval.addAnd();
                continue;
            }
            if (cd.op == 11) {
                eval.addOr();
                continue;
            }
            if (cd.leftType == 16) {
                if (cd.rightType != 16) continue;
                if (cd.cData != null) {
                    lRec = cd.cData.getBytes();
                    eval.addByteCompare(this.sortRecord.getMemory(), cd.leftOffset, cd.getEnumOp(), lRec, 0, Math.min(cd.leftLength, lRec.length));
                    continue;
                }
                eval.addByteCompare(this.sortRecord.getMemory(), cd.leftOffset, cd.getEnumOp(), this.sortRecord.getMemory(), (int)cd.rightValueOrOffset, Math.min(cd.leftLength, cd.rightLength));
                continue;
            }
            if (cd.leftType == -2) {
                if (cd.cData != null) {
                    lRec = cd.cData.getBytes();
                    if (cd.leftLength > lRec.length) {
                        eval.addSubstringFaster(this.sortRecord.getMemory(), cd.leftOffset, cd.leftLength, cd.getEnumOp(), lRec);
                        continue;
                    }
                    eval.addSubstringSearch(lRec, 0, lRec.length, cd.getEnumOp(), this.sortRecord.getMemory(), cd.leftOffset, cd.leftLength);
                    continue;
                }
                if (cd.leftLength > cd.rightLength) {
                    eval.addSubstringSearch(this.sortRecord.getMemory(), cd.leftOffset, cd.leftLength, cd.getEnumOp(), this.sortRecord.getMemory(), (int)cd.rightValueOrOffset, cd.rightLength);
                    continue;
                }
                eval.addSubstringSearch(this.sortRecord.getMemory(), (int)cd.rightValueOrOffset, cd.rightLength, cd.getEnumOp(), this.sortRecord.getMemory(), cd.leftOffset, cd.leftLength);
                continue;
            }
            NumericVar lVar = this.getNumericVar(this.sortRecord, cd.leftType, cd.leftOffset, cd.leftLength);
            if (cd.rightLength > 0) {
                NumericVar rVar = this.getNumericVar(this.sortRecord, cd.rightType, (int)cd.rightValueOrOffset, cd.rightLength);
                eval.addVarCompare(lVar, cd.getEnumOp(), rVar);
                continue;
            }
            eval.addVarIntCompare(lVar, cd.getEnumOp(), cd.rightValueOrOffset);
        }
        if (using != null && using.length > 0) {
            for (int i = 0; i < using.length; ++i) {
                try {
                    using[i].open(uNames[i], 1, 1);
                    while (Return2 == 1) {
                        int rl = using[i].readNext(false, this.sortRecord);
                        if (this.include) {
                            if (!eval.evaluate()) continue;
                            Return2 = this.sortImpl.releaseRecord(rl);
                            continue;
                        }
                        if (this.omit) {
                            if (eval.evaluate()) continue;
                            Return2 = this.sortImpl.releaseRecord(rl);
                            continue;
                        }
                        Return2 = this.sortImpl.releaseRecord(rl);
                    }
                }
                catch (AtEndException atEndException) {
                    // empty catch block
                }
                using[i].close();
            }
            if (Return2 == 1) {
                Return2 = this.sortImpl.endInput();
            }
        }
        return Return2;
    }

    private void process() {
        this.initSort();
    }

    private void parse() throws NoSuchElementException {
        while (!this.tokens.isEmpty()) {
            String word = this.tokens.pop().toLowerCase();
            if (word.equals("merge")) {
                this.merge = true;
                if (this.fields()) continue;
                return;
            }
            if (word.equals("sort")) {
                this.merge = false;
                if (this.fields()) continue;
                return;
            }
            if (word.equals("use")) {
                word = this.tokens.pop();
                this.lastFile = new FileDesc(word);
                this.use.add(this.lastFile);
                continue;
            }
            if (word.equals("give")) {
                word = this.tokens.pop();
                this.lastFile = new FileDesc(word);
                this.give.add(this.lastFile);
                continue;
            }
            if (word.equals("org")) {
                if (this.lastFile == null) {
                    this.setErrorCode(Error.SORT015U, "org with no use/give");
                    return;
                }
                word = this.tokens.pop().toLowerCase();
                if (word.equals("ix")) {
                    this.lastFile.org = 1;
                    continue;
                }
                if (word.equals("rl")) {
                    this.lastFile.org = 2;
                    continue;
                }
                if (word.equals("sq")) {
                    this.lastFile.org = 3;
                    continue;
                }
                if (word.equals("ls")) {
                    this.lastFile.org = 4;
                    continue;
                }
                this.setErrorCode(Error.SORT015U, "unknown org `" + word + "`");
                return;
            }
            if (word.equals("record")) {
                if (this.lastFile == null) {
                    this.setErrorCode(Error.SORT015U, "record with no use/give");
                    return;
                }
                if (this.record()) continue;
                return;
            }
            if (word.equals("key")) {
                if (this.lastFile == null) {
                    this.setErrorCode(Error.SORT015U, "key with no use/give");
                    return;
                }
                if (this.key()) continue;
                return;
            }
            if (word.equals("omit")) {
                if (this.omit || this.include) {
                    this.setErrorCode(Error.SORT015U, "only 1 omit/include clause allowed");
                    return;
                }
                this.omit = true;
                if (!this.cond()) continue;
                return;
            }
            if (word.equals("include")) {
                if (this.omit || this.include) {
                    this.setErrorCode(Error.SORT015U, "only 1 omit/include clause allowed");
                    return;
                }
                this.include = true;
                if (this.cond()) continue;
                return;
            }
            this.setErrorCode(Error.SORT015U, "unexpected token `" + word + "`");
            return;
        }
    }

    private String skipComma() throws NoSuchElementException {
        String Return2 = this.tokens.pop();
        if (",".equals(Return2)) {
            Return2 = this.tokens.pop();
        }
        return Return2;
    }

    private boolean eatComma() throws NoSuchElementException {
        String word = this.tokens.pop();
        return this.checkComma(word);
    }

    private boolean checkComma(String word) throws NoSuchElementException {
        if (!",".equals(word)) {
            return this.setErrorCode(Error.SORT015U, "expected `,`, found `" + word + "`");
        }
        return true;
    }

    private NumericVar getNumericVar(PicX parent, int type, int offset, int length) {
        NumericVar Return2;
        switch (type) {
            case 1: {
                Return2 = new PicDisplay(parent, offset, length, 0, false, null, null, null, 0, false, false, false);
                break;
            }
            case 5: {
                Return2 = new PicDisplay(parent, offset, length, 0, true, null, null, null, 0, false, true, false);
                break;
            }
            case 3: {
                Return2 = new PicDisplay(parent, offset, length, 0, true, null, null, null, 0, false, false, false);
                break;
            }
            case 4: {
                Return2 = new PicDisplay(parent, offset, length, 0, true, null, null, null, 0, true, true, false);
                break;
            }
            case 2: {
                Return2 = new PicDisplay(parent, offset, length, 0, true, null, null, null, 0, true, false, false);
                break;
            }
            case 12: {
                Return2 = new Pic9Comp_4(parent, offset, length, false, 0, 0, null, null, null, false, true);
                break;
            }
            case 11: {
                Return2 = new Pic9Comp_4(parent, offset, length, true, 0, 0, null, null, null, false, true);
                break;
            }
            case 14: {
                Return2 = new Pic9Comp_5(parent, offset, length, false, 0, 0, null, null, null, false, true);
                break;
            }
            case 13: {
                Return2 = new Pic9Comp_5(parent, offset, length, true, 0, 0, null, null, null, false, true);
                break;
            }
            case 10: {
                Return2 = new Pic9Comp_6((CobolVar)parent, offset, length * 2, 0, null, null, null, false);
                break;
            }
            case 8: {
                Return2 = new Pic9Comp_3((CobolVar)parent, offset, length * 2 - 1, 0, true, null, null, null, 0, false);
                break;
            }
            case 15: {
                Return2 = new PicNativeFloat(parent, offset, length, null, null, null, false);
                break;
            }
            default: {
                throw new RuntimeException("Internal error: unhandled type=" + type);
            }
        }
        return Return2;
    }

    private int getType(String word) {
        if ((word = word.toLowerCase()).equals("bi") || word.equals("cx")) {
            return 12;
        }
        if (word.equals("c5")) {
            return 14;
        }
        if (word.equals("c6")) {
            return 10;
        }
        if (word.equals("ch")) {
            return 16;
        }
        if (word.equals("fl")) {
            return 15;
        }
        if (word.equals("li")) {
            return 5;
        }
        if (word.equals("ls")) {
            return 4;
        }
        if (word.equals("nu")) {
            return 1;
        }
        if (word.equals("pd")) {
            return 8;
        }
        if (word.equals("sb")) {
            return 11;
        }
        if (word.equals("s5")) {
            return 13;
        }
        if (word.equals("zd") || word.equals("ti")) {
            return 3;
        }
        if (word.equals("ts")) {
            return 2;
        }
        if (word.equals("ss")) {
            return -2;
        }
        return -1;
    }

    private boolean cond() throws NoSuchElementException {
        String word = this.tokens.pop();
        if ("format".equals(word.toLowerCase())) {
            word = this.tokens.pop();
            if ("=".equals(word)) {
                word = this.tokens.pop();
            }
            this.condFormat = this.getType(word);
            if (this.condFormat == -1) {
                return this.setErrorCode(Error.SORT015U, "unknown type `" + word + "`");
            }
            word = this.skipComma();
        }
        if ("cond".equals(word.toLowerCase())) {
            word = this.tokens.pop();
            if (!"=".equals(word)) {
                this.tokens.push(word);
            }
            if (this.condition()) {
                if (!this.tokens.isEmpty()) {
                    word = this.tokens.pop();
                    if ("format".equals(word.toLowerCase())) {
                        word = this.tokens.pop();
                        if ("=".equals(word)) {
                            word = this.tokens.pop();
                        }
                        this.condFormat = this.getType(word);
                        if (this.condFormat == -1) {
                            return this.setErrorCode(Error.SORT015U, "unknown type `" + word + "`");
                        }
                    } else {
                        word = this.tokens.pop();
                    }
                }
                for (CondDesc cd : this.rpnCond) {
                    if (cd.leftType == -1) {
                        cd.leftType = this.condFormat;
                    }
                    if (cd.rightType == -1) {
                        cd.rightType = this.condFormat;
                    }
                    if (cd.leftType == 15 && cd.leftLength != 4 && cd.leftLength != 8) {
                        return this.setErrorCode(Error.SORT015U, "length must be 4 or 8 for floating point numbers");
                    }
                    if (cd.rightType != 15 || cd.rightLength == 4 || cd.rightLength == 8) continue;
                    return this.setErrorCode(Error.SORT015U, "length must be 4 or 8 for floating point numbers");
                }
                return true;
            }
            return false;
        }
        return this.setErrorCode(Error.SORT015U, "unexpected token `" + word + "`");
    }

    private boolean condition() throws NoSuchElementException {
        this.operand(this.tokens.pop());
        this.operator(0);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean operand(String word) throws NoSuchElementException {
        int logOp;
        int lLen;
        int lOffs;
        if (word.equals("(")) {
            this.condition();
            word = this.skipComma();
            if (word.equals(")")) return true;
            return this.setErrorCode(Error.SORT015U, "expected parenthesis, found `" + word + "`");
        }
        long rValOrOffs = 0L;
        int rLen = -99;
        int rType = -99;
        String cData = null;
        try {
            lOffs = Integer.parseInt(word) - 1;
        }
        catch (NumberFormatException _ex) {
            return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
        }
        word = this.skipComma();
        try {
            lLen = Integer.parseInt(word);
        }
        catch (NumberFormatException _ex) {
            return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
        }
        word = this.skipComma();
        int lType = this.getType(word);
        if (lType != -1) {
            word = this.skipComma();
        }
        if ((word = word.toLowerCase()).equals("eq")) {
            logOp = 1;
        } else if (word.equals("ne")) {
            logOp = 2;
        } else if (word.equals("gt")) {
            logOp = 3;
        } else if (word.equals("lt")) {
            logOp = 4;
        } else if (word.equals("ge")) {
            logOp = 5;
        } else {
            if (!word.equals("le")) return this.setErrorCode(Error.SORT015U, "unknown logical operator `" + word + "`");
            logOp = 6;
        }
        if (lType == -2) {
            if (logOp != 1 && logOp != 2) {
                return this.setErrorCode(Error.SORT015U, "Only either `eq` or `ne` are allowed with type `ss`");
            }
            word = this.skipComma();
            if (!"c".equals(word.toLowerCase())) return this.setErrorCode(Error.SORT015U, "Only `c'<string>'` supported with type `ss`");
            cData = this.skipComma();
        } else {
            word = this.skipComma();
            if ("c".equals(word.toLowerCase())) {
                cData = this.skipComma();
                rType = 16;
            } else {
                try {
                    rValOrOffs = Long.parseLong(word);
                }
                catch (NumberFormatException _ex) {
                    return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
                }
                if (!this.tokens.isEmpty()) {
                    word = this.skipComma();
                    try {
                        rLen = Integer.parseInt(word);
                    }
                    catch (NumberFormatException _ex) {
                        rLen = -99;
                    }
                    if (rLen == -99) {
                        this.tokens.push(word);
                    } else {
                        --rValOrOffs;
                        if (!this.tokens.isEmpty() && (rType = this.getType(word = this.skipComma())) < 0) {
                            this.tokens.push(word);
                        }
                    }
                }
            }
        }
        this.rpnCond.add(new CondDesc(lOffs, lLen, lType, logOp, rValOrOffs, rLen, rType, cData));
        return true;
    }

    int getPrio(String word) {
        switch (CondDesc.getOp(word)) {
            case 11: {
                return 3;
            }
            case 10: {
                return 6;
            }
        }
        return 99;
    }

    private boolean operator(int lastPrio) throws NoSuchElementException {
        if (!this.tokens.isEmpty()) {
            String word = this.skipComma();
            int thisPrio = this.getPrio(word);
            if (thisPrio == 99) {
                this.tokens.push(word);
            } else if (lastPrio >= thisPrio) {
                this.tokens.push(word);
            } else {
                this.operand(this.skipComma());
                if (!this.tokens.isEmpty()) {
                    String nextOp = this.skipComma();
                    int nextPrio = this.getPrio(nextOp);
                    this.tokens.push(nextOp);
                    if (nextPrio == 99) {
                        this.rpnCond.add(new CondDesc(word));
                    } else if (nextPrio > thisPrio) {
                        this.operator(thisPrio);
                        this.rpnCond.add(new CondDesc(word));
                        this.operator(lastPrio);
                    } else {
                        this.rpnCond.add(new CondDesc(word));
                        this.operator(lastPrio);
                    }
                } else {
                    this.rpnCond.add(new CondDesc(word));
                }
            }
        }
        return true;
    }

    private boolean fields() throws NoSuchElementException {
        String word = this.tokens.pop();
        if ("fields".equals(word.toLowerCase())) {
            word = this.tokens.pop();
            if ("=".equals(word)) {
                word = this.tokens.pop();
            }
            if ("(".equals(word)) {
                ArrayList<SortKeyItem> sFields = new ArrayList<SortKeyItem>();
                word = ",";
                do {
                    boolean descending;
                    int length;
                    int offset;
                    if (!this.checkComma(word)) {
                        return false;
                    }
                    word = this.tokens.pop();
                    try {
                        offset = Integer.parseInt(word) - 1;
                    }
                    catch (NumberFormatException _ex) {
                        return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
                    }
                    if (!this.eatComma()) {
                        return false;
                    }
                    word = this.tokens.pop();
                    try {
                        length = Integer.parseInt(word);
                    }
                    catch (NumberFormatException _ex) {
                        return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
                    }
                    if (!this.eatComma()) {
                        return false;
                    }
                    word = this.tokens.pop();
                    int type = this.getType(word);
                    if (type < 0) {
                        return this.setErrorCode(Error.SORT002U, "not nupported `" + word + "`");
                    }
                    if (!this.eatComma()) {
                        return false;
                    }
                    word = this.tokens.pop();
                    if ("a".equals(word.toLowerCase())) {
                        descending = false;
                    } else if ("d".equals(word.toLowerCase())) {
                        descending = true;
                    } else {
                        return this.setErrorCode(Error.SORT015U, "expected `a` or `d`, found `" + word + "`");
                    }
                    sFields.add(new SortKeyItem(descending, type, offset, length, 0, this.sortFields));
                } while (!")".equals(word = this.tokens.pop()));
                SortKeyItem[] keyArray = new SortKeyItem[sFields.size()];
                sFields.toArray(keyArray);
                this.sortFields.keyArray = keyArray;
                return true;
            }
        }
        return this.setErrorCode(Error.SORT015U, "unexpected token `" + word + "`");
    }

    private boolean key() throws NoSuchElementException {
        int type = 0;
        String word = this.tokens.pop();
        if ("=".equals(word)) {
            word = this.tokens.pop();
        }
        if ("(".equals(word)) {
            word = ",";
            int nKey = 0;
            do {
                int length;
                int offset;
                if (!this.checkComma(word)) {
                    return false;
                }
                word = this.tokens.pop();
                try {
                    offset = Integer.parseInt(word) - 1;
                }
                catch (NumberFormatException _ex) {
                    return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
                }
                if (!this.eatComma()) {
                    return false;
                }
                word = this.tokens.pop();
                try {
                    length = Integer.parseInt(word);
                }
                catch (NumberFormatException _ex) {
                    return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
                }
                if (!this.eatComma()) {
                    return false;
                }
                word = this.tokens.pop();
                if ((word = word.toLowerCase()).equals("p")) {
                    type = 1;
                } else {
                    if (word.equals("pd")) {
                        return this.setErrorCode(Error.SORT002U, "key type `" + word + "`");
                    }
                    if (word.equals("a")) {
                        type = 3;
                    } else if (word.equals("ad")) {
                        type = 4;
                    } else if (word.equals("c")) {
                        type = 5;
                    } else {
                        return this.setErrorCode(Error.SORT015U, "unexpected key type `" + word + "`");
                    }
                }
                if (nKey == 0) {
                    if (type != 1) {
                        return this.setErrorCode(Error.SORT015U, "the first key must be declared as primary");
                    }
                } else if (type == 1) {
                    return this.setErrorCode(Error.SORT015U, "only the first key can be declared as primary");
                }
                this.lastFile.keys.add(new KeyDesc(offset, length, type));
                ++nKey;
            } while (!")".equals(word = this.tokens.pop()));
            return true;
        }
        return this.setErrorCode(Error.SORT015U, "unexpected token `" + word + "`");
    }

    private boolean record() throws NoSuchElementException {
        int recMax;
        int recLen;
        int format = 102;
        String word = this.tokens.pop();
        if ("f".equals(word.toLowerCase())) {
            format = 102;
        } else if ("v".equals(word.toLowerCase())) {
            format = 118;
        } else {
            return this.setErrorCode(Error.SORT015U, "expected `f` or `v`, found `" + word + "`");
        }
        word = this.tokens.pop();
        try {
            recLen = Integer.parseInt(word);
        }
        catch (NumberFormatException _ex) {
            return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
        }
        if (format == 118) {
            word = this.tokens.pop();
            try {
                recMax = Integer.parseInt(word);
            }
            catch (NumberFormatException _ex) {
                return this.setErrorCode(Error.SORT015U, "expected integer, found `" + word + "`");
            }
        } else {
            recMax = recLen;
        }
        this.lastFile.format = (char)format;
        this.lastFile.recLen = recLen;
        this.lastFile.recMax = recMax;
        if (recMax > this.maxRecLenFound) {
            this.maxRecLenFound = recMax;
        }
        return true;
    }

    private static void debug(String desc) {
        System.out.println(desc);
    }

    private static void exit(Error e, String desc) {
        if (e == Error.SORT015U && desc == null) {
            System.err.println("");
            System.err.println("usage: java IsSort -v");
            System.err.println("       java IsSort <instructions>");
            System.err.println("       java IsSort take <filename>");
            System.err.println("");
        } else if (e.code != 0) {
            System.err.print("Error " + e.code + " - " + e.mesg);
            if (desc != null) {
                System.err.println(": " + desc);
            } else {
                System.err.println("");
            }
        }
        System.exit(e.code);
    }

    private static void exit(Error e) {
        IsSort.exit(e, null);
    }

    public static void main(String[] argv) {
        IsSort sort;
        if (argv.length == 0) {
            IsSort.exit(Error.SORT015U);
        }
        if ("-v".equalsIgnoreCase(argv[0])) {
            String version = RuntimeProperties.getFullVersionNumber();
            if (version.startsWith("isCOBOL")) {
                version = "isCOBOL-Sort" + version.substring(7);
            }
            System.out.println(version);
            return;
        }
        if ("take".equalsIgnoreCase(argv[0])) {
            if (argv.length == 2) {
                FileReader fr;
                try {
                    fr = new FileReader(argv[1]);
                }
                catch (FileNotFoundException ex) {
                    IsSort.exit(Error.SORT015U, ex.getMessage());
                    fr = null;
                }
                sort = new IsSort(fr);
            } else {
                IsSort.exit(Error.SORT015U);
                sort = null;
            }
        } else {
            StringBuilder sb = new StringBuilder(argv[0]);
            for (int i = 1; i < argv.length; ++i) {
                sb.append(" ");
                sb.append(argv[i]);
            }
            sort = new IsSort(new StringReader(sb.toString()));
        }
        IsSort.exit(sort.getErrorCode(), sort.getErrorDesc());
    }

    private static ArrayDeque<String> tokenizer(Reader in) {
        ArrayDeque<String> Return2 = new ArrayDeque<String>();
        boolean ST_NEW = true;
        int ST_WORD = 2;
        int ST_STR_OP = 3;
        int ST_STR_CL = 4;
        int ST_COMM = 5;
        int status = 1;
        int stringDelimiter = 0;
        StringBuilder word = null;
        try {
            int c;
            block40: while ((c = in.read()) >= 0) {
                switch (c) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 26: 
                    case 32: {
                        switch (status) {
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 4: {
                                Return2.add(word.toString());
                                word = null;
                                status = 1;
                                break;
                            }
                            case 3: {
                                word.append((char)c);
                                break;
                            }
                            case 5: {
                                if (c != 10) break;
                                status = 1;
                            }
                        }
                        continue block40;
                    }
                    case 40: 
                    case 41: 
                    case 44: 
                    case 61: {
                        switch (status) {
                            case 1: {
                                Return2.add(Character.toString((char)c));
                                break;
                            }
                            case 2: 
                            case 4: {
                                Return2.add(word.toString());
                                word = null;
                                Return2.add(Character.toString((char)c));
                                status = 1;
                                break;
                            }
                            case 3: {
                                word.append((char)c);
                                break;
                            }
                        }
                        continue block40;
                    }
                    case 42: {
                        switch (status) {
                            case 1: {
                                status = 5;
                                break;
                            }
                            case 2: 
                            case 4: {
                                Return2.add(word.toString());
                                word = null;
                                status = 5;
                                break;
                            }
                            case 3: {
                                word.append((char)c);
                                break;
                            }
                        }
                        continue block40;
                    }
                    case 34: 
                    case 39: {
                        switch (status) {
                            case 2: {
                                Return2.add(word.toString());
                            }
                            case 1: {
                                word = new StringBuilder();
                                status = 3;
                                stringDelimiter = c;
                                break;
                            }
                            case 3: {
                                if (c == stringDelimiter) {
                                    status = 4;
                                    break;
                                }
                                word.append((char)c);
                                break;
                            }
                            case 4: {
                                if (c == stringDelimiter) {
                                    word.append((char)c);
                                    status = 3;
                                    break;
                                }
                                Return2.add(word.toString());
                                word = new StringBuilder();
                                status = 3;
                                stringDelimiter = c;
                                break;
                            }
                        }
                        continue block40;
                    }
                }
                switch (status) {
                    case 1: {
                        word = new StringBuilder(Character.toString((char)c));
                        status = 2;
                        break;
                    }
                    case 2: {
                        word.append((char)c);
                        break;
                    }
                    case 4: {
                        Return2.add(word.toString());
                        word = new StringBuilder(Character.toString((char)c));
                        status = 2;
                        break;
                    }
                    case 3: {
                        word.append((char)c);
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        switch (status) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Return2.add(word.toString());
                break;
            }
        }
        return Return2;
    }

    public static enum Error {
        SORT002U(2, "Unsupported feature"),
        SORT015U(15, "Command statement error(s) detected"),
        SORT100U(100, "I/O error"),
        SORT000U(0, "Success");

        public final int code;
        public final String mesg;

        private Error(int c, String m) {
            this.code = c;
            this.mesg = m;
        }
    }

    private static class CondDesc {
        static final int INVALID_OP = -1;
        static final int EQ = 1;
        static final int NE = 2;
        static final int GT = 3;
        static final int LT = 4;
        static final int GE = 5;
        static final int LE = 6;
        static final int AND = 10;
        static final int OR = 11;
        final int leftOffset;
        final int leftLength;
        int leftType;
        final int op;
        final long rightValueOrOffset;
        final int rightLength;
        int rightType;
        final String cData;

        static int getOp(String word) {
            if ((word = word.toLowerCase()).equals("|") || word.equals("or")) {
                return 11;
            }
            if (word.equals("&") || word.equals("and")) {
                return 10;
            }
            return -1;
        }

        CondDesc(String word) {
            this.leftOffset = -1;
            this.leftLength = -1;
            this.leftType = -1;
            this.op = CondDesc.getOp(word);
            this.rightValueOrOffset = -1L;
            this.rightLength = -1;
            this.rightType = -1;
            this.cData = null;
            if (this.op == -1) {
                throw new RuntimeException("Internal error: logic op = " + this.op);
            }
        }

        CondDesc(int lOffs, int lLen, int lty, int o, long rValOrOffs, int rLen, int rty, String cd) {
            if (o != 1 && o != 2 && o != 3 && o != 4 && o != 5 && o != 6) {
                throw new RuntimeException("Internal error: op = " + o);
            }
            this.leftOffset = lOffs;
            this.leftLength = lLen;
            this.leftType = lty;
            this.op = o;
            this.rightValueOrOffset = rValOrOffs;
            this.rightLength = rLen;
            this.rightType = rty;
            this.cData = cd;
        }

        RpnEvaluator.Operator getEnumOp() {
            switch (this.op) {
                case 1: {
                    return RpnEvaluator.Operator.EQ;
                }
                case 2: {
                    return RpnEvaluator.Operator.NE;
                }
                case 3: {
                    return RpnEvaluator.Operator.GT;
                }
                case 4: {
                    return RpnEvaluator.Operator.LT;
                }
                case 5: {
                    return RpnEvaluator.Operator.GE;
                }
                case 6: {
                    return RpnEvaluator.Operator.LE;
                }
            }
            return null;
        }

        public String toString() {
            String Return2;
            if (this.op == 11) {
                Return2 = "OR";
            } else if (this.op == 10) {
                Return2 = "AND";
            } else {
                String[] opDescr = new String[]{"", "eq", "ne", "gt", "lt", "ge", "le"};
                Return2 = "lOffs=" + this.leftOffset + ",lLen=" + this.leftLength + ",lType=" + this.leftType + ",op=" + opDescr[this.op];
                Return2 = this.rightLength <= 0 ? (this.cData != null ? Return2 + ",cData=" + this.cData : Return2 + ",rValue=" + this.rightValueOrOffset) : Return2 + ",rOffs=" + this.rightValueOrOffset + ",rLen=" + this.rightLength + ",rType=" + this.rightType;
            }
            return Return2;
        }
    }

    private class FileDesc {
        static final int ORG_IX = 1;
        static final int ORG_RL = 2;
        static final int ORG_SQ = 3;
        static final int ORG_LS = 4;
        final String name;
        char format = (char)102;
        int recLen;
        int recMax;
        int org = 3;
        final ArrayList<KeyDesc> keys = new ArrayList();

        FileDesc(String n) {
            this.name = n;
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.name;
        }
    }

    private class KeyDesc {
        static final int KEY_P = 1;
        static final int KEY_PD = 2;
        static final int KEY_A = 3;
        static final int KEY_AD = 4;
        static final int KEY_C = 5;
        final int offset;
        final int length;
        final int type;

        KeyDesc(int offs, int len, int t) {
            if (t < 1 || t > 5) {
                throw new IllegalArgumentException("Type");
            }
            this.offset = offs;
            this.length = len;
            this.type = t;
        }
    }
}

