/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.logger.Logger;

public class TransactionException
extends CobolIOException {
    private String transStatus;
    private static DummyDataStream ds = new DummyDataStream();

    public static void get(int type, String efs, int op) {
        try {
            CobolIOException.get(type, efs, ds, op);
        }
        catch (CobolIOException ex) {
            throw new TransactionException(ex, efs);
        }
    }

    public TransactionException(CobolIOException cioe, String efs) {
        super(cioe);
        this.transStatus = efs;
    }

    public String getTransactionStatus() {
        switch (this.transStatus.length()) {
            case 0: {
                return "00";
            }
            case 1: {
                return "0" + this.transStatus;
            }
            case 2: {
                return this.transStatus;
            }
        }
        return this.transStatus.substring(this.transStatus.length() - 2, this.transStatus.length());
    }

    public String getFileStatus() {
        if (ds != null) {
            return ds.getFileStatus();
        }
        return "";
    }

    public String getExtendedStatus() {
        if (ds != null) {
            return ds.getExtendedStatus();
        }
        return "";
    }

    public String getStatusMessage() {
        if (ds != null) {
            return ds.getStatusMessage();
        }
        return "";
    }

    private static class DummyDataStream
    implements DataStream {
        private String fs = "00";
        private String extFs = "00";
        private String statusMsg = "";

        private DummyDataStream() {
        }

        @Override
        public void setFileStatus(String f) {
            this.fs = f;
        }

        @Override
        public String getFileStatus() {
            return this.fs;
        }

        @Override
        public void setExtendedStatus(String f) {
            this.extFs = f;
        }

        @Override
        public String getExtendedStatus() {
            return this.extFs;
        }

        @Override
        public void setStatusMessage(String f) {
            this.statusMsg = f;
        }

        @Override
        public String getStatusMessage() {
            return this.statusMsg;
        }

        @Override
        public void setLastException(CobolIOException ex) {
        }

        @Override
        public CobolIOException getLastException() {
            return null;
        }

        @Override
        public String getLogicName() {
            return "Transaction";
        }

        @Override
        public String getOsPath() {
            return "";
        }

        @Override
        public Logger getLogger() {
            return null;
        }

        @Override
        public void finalize() {
        }
    }
}

